/****************************************************************
**
** Implementation of Options dialog
**
****************************************************************/

//
// $Id: optdialog.cpp,v 1.5 1999/03/06 15:22:43 pi Exp pi $
//
// $Log: optdialog.cpp,v $
// Revision 1.5  1999/03/06 15:22:43  pi
// Intermediate Checkin
//
// Revision 1.4  1998/10/27 22:04:13  pi
// Bug Fixes for V 0.61
//
// Revision 1.3  1998/10/23 11:59:08  pi
// Checkin for V 0.6
//
// Revision 1.2  1998/10/04 15:57:56  pi
// After first version of Options dialog
//
// Revision 1.1  1998/08/23 19:55:51  pi
// Initial revision
//
//

extern "C" {
    #include <stdlib.h>
}

#include <iostream.h>

#include <qlayout.h>

#include "optdialog.h"


///////////////////////////////////////////////////////////////////////
// Constructor
///////////////////////////////////////////////////////////////////////
OptDialog::OptDialog(OptionSet os, QWidget *parent, const char *name) :
    QTabDialog(parent, name, false) 
{
    setCaption(i18n("kload: Preferences"));
    
    QLabel *label;
    QVBoxLayout *vbox;
    QLineEdit test;
    test.setText("X");
    test.adjustSize();
    int height = test.height() + 2;

    this->np = os.nPanels; 
    
    /////////////////////////////////////////////////////////////////
    // General Options //////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////
    
    QWidget *go = new QWidget(this);
    QGridLayout *ggo = new QGridLayout(go, 2, 2, 20, 6);
    
    // Redraw Interval Spinbox
    QGroupBox *gf = new QGroupBox(i18n("Sampling Interval"),go);
    ggo->addWidget(gf,0,0);
    vbox = new QVBoxLayout(gf, 20);
    redrawInterval = new QSpinBox(1,60,1,gf);
    redrawInterval->setMinimumSize( redrawInterval->sizeHint() );
    redrawInterval->setMaximumHeight(redrawInterval->sizeHint().height() );
    redrawInterval->setSuffix(i18n(" sec"));    
    vbox->addWidget(redrawInterval);
    
    // Alignment Button Group
    
    QButtonGroup *bg = new QButtonGroup(i18n("Alignment"),go);
    ggo->addWidget(bg,1,0);

    // Create a layout for the radio buttons
    vbox = new QVBoxLayout(bg, 10);

    vbox->addSpacing( bg->fontMetrics().height() );

    alignment[0] = new QRadioButton(i18n("&Vertical"),bg);
    alignment[0]->setMinimumSize(alignment[0]->sizeHint() );
    vbox->addWidget(alignment[0]);
    alignment[1] = new QRadioButton(i18n("&Horizontal"),bg);
    alignment[1]->setMinimumSize(alignment[1]->sizeHint() );
    vbox->addWidget(alignment[1]);
    
    vbox->activate();
    
    // Active Panels CheckBox
    
    bg = new QButtonGroup(i18n("Active Panels"), go);
    ggo->addMultiCellWidget(bg,0,1,1,1);
    
    vbox = new QVBoxLayout(bg,10);
    vbox->addSpacing(bg->fontMetrics().height());
    for (int i = 0;i < os.nPanels;i++) {
        panelVis[i] = new QCheckBox(os.label[i],bg);
        panelVis[i]->setMinimumSize(panelVis[i]->sizeHint());
        vbox->addWidget(panelVis[i]);
    }
    
    this->addTab(go,i18n("&General Options"));
    ggo->activate();

    /////////////////////////////////////////////////////////////////
    ///Double Click /////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////    
    QWidget *dc = new QWidget(this);
    
    QGridLayout *gdc = new QGridLayout(dc, os.nPanels + 1, 2, 20,6);
    
    QLabel *header = new QLabel(i18n("Mouse Double Click triggers:"),dc);
    gdc->addMultiCellWidget(header,0,0,0,1);
    
    for (int i = 0;i < os.nPanels;i++) {
        (dblClckAction[i]      = new QLineEdit(dc))->setFixedHeight(height);
        gdc->addWidget(dblClckAction[i],i + 1,1);
        label = new QLabel(dblClckAction[i],os.label[i],dc);
        gdc->addWidget(label,i + 1,0);
    
    }
    this->addTab(dc,i18n("&Double click"));
    gdc->activate();
    
    /////////////////////////////////////////////////////////////////
    /// Interval violation //////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////

    QWidget *iv = new QWidget(this);
    
    QGridLayout *giv = new QGridLayout(iv, os.nPanels + 2, 5, 20, 6 );
    
    header = new QLabel(i18n("Interval violations trigger:"),iv);
    giv->addMultiCellWidget(header,0,0,0,4);
    
    header = new QLabel(i18n("Panel"),iv);
    giv->addWidget(header,1,0);
    header = new QLabel(i18n("Action when\nstepping < LWM"),iv);
    giv->addWidget(header,1,1);
    header = new QLabel(i18n("Lower Water\nMark (LWM)"),iv);
    giv->addWidget(header,1,2);
    header = new QLabel(i18n("Higher Water\nMark (HWM)"),iv);
    giv->addWidget(header,1,3);
    header = new QLabel(i18n("Action when\nstepping > HWM"),iv);
    giv->addWidget(header,1,4);
    
    for (int i = 0;i < os.nPanels;i++) {
        (lowAction[i] = new QLineEdit(iv))->setFixedHeight(height);
        giv->addWidget(lowAction[i],i + 2,1);
        (lowWM[i] = new QLineEdit(iv))->setFixedHeight(height);
        giv->addWidget(lowWM[i],i + 2,2);
        (highWM[i] = new QLineEdit(iv))->setFixedHeight(height);
        giv->addWidget(highWM[i],i + 2,3);
        (highAction[i] = new QLineEdit(iv))->setFixedHeight(height);
        giv->addWidget(highAction[i],i + 2,4);
        label = new QLabel(lowAction[i],os.label[i],iv);
        giv->addWidget(label,i + 2,0);
    }

    this->addTab(iv,i18n("&Intervals"));
    giv->activate();
    
    setOKButton(i18n("OK"));
    setApplyButton(i18n("Apply"));
    setCancelButton(i18n("Cancel"));
    
    connect(this, SIGNAL(applyButtonPressed()), SLOT(doApply()));

    this->setFixedSize(600,300); 
}


// Public: Must be called to fill/set the option dialog
void OptDialog::set(OptionSet os)
{
    char help[80];
    
    redrawInterval->setValue(os.redrawInterval);
    
    if (os.alignment == A_VERT) 
    {
        alignment[0]->setChecked(TRUE);
    }
    else 
    {
        alignment[1]->setChecked(TRUE);
    }
    
    for (int i = 0;i < this->np;i++) {
        panelVis[i]->setChecked(os.panelVis[i]);
        
        dblClckAction[i]->setText((const char *)(os.dblClckAction[i]));
        
        lowAction[i] ->setText((const char *)(os.lowAction[i]));
        highAction[i]->setText((const char *)(os.highAction[i]));
        sprintf(help,"%.2f",os.lowWM[i]);
        lowWM[i]     ->setText(help);
        sprintf(help,"%.2f",os.highWM[i]);
        highWM[i]    ->setText(help);
    }
}


// Apply options by writing data into transfer structure ans
// emitting signal
void OptDialog::doApply()
{
    OptionSet os;
    
    os.nPanels = this->np;
    
    os.redrawInterval = redrawInterval->value();
    os.alignment = (alignment[0]->isChecked()) ? A_VERT : A_HORIZ;        
    
    for (int i = 0;i < this->np;i++) 
    {    
        os.panelVis[i] = panelVis[i]->isChecked();
    
        os.dblClckAction[i] = this->dblClckAction[i]->text();
        
        os.lowAction[i]  = this->lowAction[i]->text();
        os.highAction[i] = this->highAction[i]->text();
        os.lowWM[i]      = atof(this->lowWM[i]->text());
        os.highWM[i]     = atof(this->highWM[i]->text());   
    }
    
    emit applyOptions(os);
}


