/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: MinMaxTemp.h,v 1.1 1999/01/30 19:06:57 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef MINMAXTEMP_H
#define MINMAXTEMP_H

#include "Sensors.h"

class MinMaxTemp : public Sensor
{
  
private:
  QString sensorName;
  
public:
  MinMaxTemp(
    int sysc1, 
    int sysc2, 
    int sysc3,
    int sysc4,
    double grMin,
    double grMax,
    char *defaultName );
  
  ~MinMaxTemp();
  
  bool save();	
  void name( QString &name );
  bool setName( QString &name );
  bool read( SensorValue &val );
  bool write( SensorValue &val );	
  bool isTemp();		
  bool scalable();
  bool increaseGraphRange();
  bool decreaseGraphRange();
  bool displayDecimals();
  bool displayUnits();
  void units( QString &unitStr );	
  bool isAlarm();
  bool increaseOffset();
  bool decreaseOffset();
};

#endif
