/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: Item.h,v 1.26 1999/01/09 18:55:57 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef ITEM_H
#define ITEM_H

#include <qlabel.h>
#include <qframe.h>
#include <qevent.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <qlineedit.h>
#include <kbutton.h>
#include <kapp.h>
#include <kstatusbar.h>

#include "Sensors.h"
#include "VertGraph.h"
#include "UpDownButton.h"

class VertItem : public QFrame
{
  Q_OBJECT
  
private:
  QLabel       *lblValue;
  QLabel       *lblTitle;
  QLineEdit    *editTitle;
  VertGraph    *graph;
  QString      s_units;
  bool         drawDecimals;
  bool         configuring;	
  KStatusBar   *status;
  Sensor       *sensor;
  UpDownButton *scale;
  UpDownButton *range;
  UpDownButton *bButton;
  KButton      *hideButton;
  
  void forcePlot();
  
public:
  
  VertItem( 
    QWidget* parent = NULL,
    const char* name = NULL,
    KStatusBar *sb = NULL,
    Sensor *aSensor = NULL	);
  
  ~VertItem();
  
  void plot();
  void saveConfig( 
    char *min_key,
    char *max_key,
    char *min_alarm_key,
    char *max_alarm_key);
  
public slots:
  void newRange( double, double );
  void configurationRequest( );
  void titleEnterPressed();
  void increaseScale();
  void decreaseScale();
  void increaseOffset();
  void decreaseOffset();
  void increaseGraphMax();
  void decreaseGraphMax();
  void hideButtonPressed();
  
protected slots:
  void enterEvent( QEvent *e );
  void mousePressEvent( QMouseEvent *e );
  
signals:
  void hideMe();
  
protected:
  void paintEvent( QPaintEvent *e );
};



#endif // Graph_included
