#include <klibretawidget.h>
#include <klibretawidget.moc>
#include <qlabel.h>
#include <qtabdialog.h>
#include <qlayout.h>
#include <fstream.h>
#include <iostream.h>
#include <qstring.h>
#include <qpixmap.h>
#include "itemlista.h"
#include <qlistview.h>
#include <qmessagebox.h>
#define ESPACIO (const char*)"          "
#define SALTO ""

KLibretaWidget::KLibretaWidget(QWidget *parent, const char *name)
	: QWidget(parent, name)
{	

	setMouseTracking(true);
	path=kapp->kde_datadir();
	path+=(const char*)"/klibreta";

	localpath=kapp->localkdedir();
	localpath+=(const char*)"/share/apps/klibreta";

	fileoutpath=localpath+(const char*)"/file.out";
	
	
	Cuad = new QFrame( this, "Cuad" );
	Cuad->setMinimumSize( 10, 10 );
	Cuad->setMaximumSize( 32767, 32767 );
	Cuad->setFrameStyle( 49 );
	
	QString picspath=path+(const char*)"/pics/";
	
	QString picfile("new.xpm");
	boton[0]=new TobeButton(this,"b0",i18n("add contact"),
	(const char*)picspath,(const char*)picfile);
connect(boton[0],SIGNAL(pulsado()),SLOT(newContact())); 

	picfile=(const char*)("filer.xpm");
	boton[1]=new TobeButton(this,"b1",i18n("add group"),
	(const char*)picspath,(const char*)picfile);
connect(boton[1],SIGNAL(pulsado()),SLOT(notimplemented()));

	picfile=(const char*)("kde_display4.xpm");
	boton[2]=new TobeButton(this,"b2",i18n("properties"),
	(const char*)picspath,(const char*)picfile);
connect(boton[2],SIGNAL(pulsado()),SLOT(PreparaPropiedades()));

	picfile=(const char*)("not.xpm");
	boton[3]=new TobeButton(this,"b3",i18n("delete"),
	(const char*)picspath,(const char*)picfile);
connect(boton[3],SIGNAL(pulsado()),SLOT(eliminaContacto()));

	picfile=(const char*)("mail.xpm");
	boton[4]=new TobeButton(this,"b4",i18n("send mail"),
	(const char*)picspath,(const char*)picfile);
connect(boton[4],SIGNAL(pulsado()),SLOT(notimplemented()));

	picfile=(const char*)("kde_help.xpm");
	boton[5]=new TobeButton(this,"b5",i18n("help"),
	(const char*)picspath,(const char*)picfile);
connect(boton[5],SIGNAL(pulsado()),SLOT(thehelp()));

	Cuad2 = new QFrame( this, "Cuad2" );
	Cuad2->setMinimumSize( 10, 10 );
	Cuad2->setMaximumSize( 32767, 32767 );
	Cuad2->setFrameStyle( 49 );

	TNombre = new QLineEdit( this, "LineEdit_19" );
	TNombre->setGeometry( 285, 50, 245, 30 );
	TNombre->setMinimumSize( 10, 10 );
	TNombre->setMaximumSize( 32767, 32767 );
	TNombre->setText( "" );
	TNombre->setMaxLength( 32767 );
	TNombre->setEchoMode( QLineEdit::Normal );
	TNombre->setFrame( TRUE );

	
	LEscribe = new QLabel( this, "LEscribe" );
	LEscribe->setMinimumSize( 10, 10 );
	LEscribe->setMaximumSize( 32767, 32767 );
	LEscribe->setText(i18n("Write the name or select it from the list"));
 	LEscribe->setAlignment( 289 );
	LEscribe->setMargin( -1 );
	LEscribe->setAutoResize(true);

	Lista = new QListView( this, "ListView_2" );
	Lista->setGeometry( 0, 0, 400, 170 );
	Lista->setMinimumSize( 0, 0 );
	Lista->setMaximumSize( 32767, 32767 );
	Lista->setFocusPolicy( QWidget::TabFocus );
	Lista->setBackgroundMode( QWidget::PaletteBackground );
	Lista->setFontPropagation( QWidget::NoChildren );
	Lista->setPalettePropagation( QWidget::NoChildren );
	Lista->setFrameStyle( 51 );
	Lista->setLineWidth( 2 );
	Lista->setResizePolicy( QScrollView::Manual );
	Lista->setVScrollBarMode( QScrollView::Auto );
	Lista->setHScrollBarMode( QScrollView::Auto );
	Lista->setTreeStepSize( 0 );
	Lista->setMultiSelection( FALSE );
	Lista->setAllColumnsShowFocus( FALSE );
	Lista->setItemMargin( 1 );
	Lista->setRootIsDecorated( FALSE );
	Lista->addColumn(i18n("   name  "), -1 );
	Lista->setColumnWidthMode( 0, QListView::Maximum );
	Lista->setColumnAlignment( 0, 1 );
	Lista->addColumn( i18n("  e-mail  "), -1 );
	Lista->setColumnWidthMode( 1, QListView::Maximum );
	Lista->setColumnAlignment( 1, 1 );
	Lista->addColumn(i18n("  telephone  "), -1 );
	Lista->setColumnWidthMode( 2, QListView::Maximum );
	Lista->setColumnAlignment( 2, 1 );
	Lista->addColumn(i18n ("  icq number  "), -1 );
	Lista->setColumnWidthMode( 3, QListView::Maximum );
	Lista->setColumnAlignment( 3, 1 );
	Lista->addColumn( "PID", -1 );
	Lista->setColumnWidthMode( 4,QListView::Maximum);
	Lista->setColumnAlignment( 4, 1 );
	Lista->setAllColumnsShowFocus(true);
	Lista->setCurrentItem(0);
	resize( 550,330 );
	setMinimumSize( 0, 0 );
	setMaximumSize( 32767, 32767 );
	actualizaLista();
	update();
	QListViewItem pablo(Lista,"rafa","","","","","");
 	Lista->setCurrentItem(&pablo);
}

KLibretaWidget::~KLibretaWidget()
{
}

//-------------------------
// You have pressed "new contact" button
//-------------------------


void KLibretaWidget::newContact()
{
newman = new NuevoWidget();
connect( newman, SIGNAL (applyButtonPressed()), SLOT(applynew()) );
connect( newman, SIGNAL(cancelButtonPressed()), SLOT(cancelnew()) );
newman->show();
}

//------------------------------------------------
//------------------------------------------------

void KLibretaWidget::applynew()
{
QString nombre(newman->w->Combo1->text(0));
QString apodo(newman->w->Combo1->text(1));
apodo=apodo.simplifyWhiteSpace();
nombre=nombre.simplifyWhiteSpace();
QString vacio(" ");
vacio=vacio.simplifyWhiteSpace();
QString current(newman->w->Combo1->currentText());
current=current.simplifyWhiteSpace();
if ((nombre!=vacio)||(apodo!=vacio))
{if(current==vacio)
	{
	QMessageBox mensaje(this);
	mensaje.setText(i18n("I will select\na corect name."));
        mensaje.show();
	if (newman->w->Combo1->currentItem()==0)
		newman->w->Combo1->setCurrentItem(1);
	else 	newman->w->Combo1->setCurrentItem(0);
	}
	insertaper(0);
	Lista->clear();
	actualizaLista();
}
else if((nombre==vacio)||(apodo==vacio))
{
	QMessageBox mensaje(this);
	mensaje.setText(i18n("I need a name or a nickname"));
	newman->hide();
	mensaje.show();
}

	}


//------------------------------------------------
//------------------------------------------------

void KLibretaWidget::cancelnew()
{

}


//------------------------------------------------
//------------------------------------------------

void KLibretaWidget::thehelp()
{
kapp->invokeHTMLHelp("klibreta/klibreta.html", "");
}

//------------------
//let's paint the buttons....
//---------------------

void KLibretaWidget::paintEvent(QPaintEvent *p)    
{
  boton[0]->move(Cuad->x()+2,Cuad->y()+2);
  for(int i=1;i<NUMB;i++)
  boton[i]->move(boton[i-1]->x()+boton[i-1]->width(),boton[0]->y());
}

//------------------
//let's resize the widgets
//------------------

void KLibretaWidget::resizeEvent( QResizeEvent * )    
{  
  Cuad->setGeometry(2,2, width()-4, boton[0]->height()+5 ); 	     
  boton[0]->move(Cuad->x()+2,Cuad->y()+2);
  LEscribe->setGeometry(Cuad->x(),Cuad->y()+10+Cuad->height(),
		LEscribe->width(),20);	    
  TNombre->setGeometry(LEscribe->x()+LEscribe->width()+10,LEscribe->y(), 
	 Cuad->width()-LEscribe->width()-10, 20 );   

  Cuad2->setGeometry(2,TNombre->y()+TNombre->height()+10,Cuad->width(),
		height()-TNombre->y()-TNombre->height()-15);
  
 Lista->setGeometry(Cuad2->x()+10,Cuad2->y()+10,Cuad2->width()-20,
			Cuad2->height()-20); 
//	
}


// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
void KLibretaWidget::actualizaLista()
{
QFile f((const char *)fileoutpath);
if (f.open(IO_ReadWrite))
  {   
	QString email;
	QString nombre("");
	QString telf;
	QString icq;
	QString index;

	QTextStream t( &f );      
	QString s;   
        while((!t.eof()))
	 {
	  bool porsi;  	
	  s=t.readLine();
	  if(s==SALTO)
	    {	
	     s=t.readLine();	//reads PID
	     index=s;	
             unsigned int numero=s.toUInt(&porsi);
	      if (numero!=0)  
		{
		s=t.readLine();
		s=t.readLine();
		int corrpred=s.toInt();
	        if (corrpred!=-1)
		  {
		   QString col1;
		   int i;
		   for (i=0;i<=corrpred;i++)
		    s=t.readLine();		 
		  email=s;
		   for (int p=i;p<=5;p++)
		    s=t.readLine();		  				  			
		  }	
		else
		  {
		   email=("   ");
		for (int p=0;p<=5;p++)
		    s=t.readLine();	
		   }
		
		//we have read the e-mail

		s=t.readLine(); //reads mostrar
	        int mostrar=s.toInt(&porsi);
		if (mostrar==0)
		{
		  for (int i=0;i<3;i++)
		    {	
		    s=t.readLine();
		    nombre+=s+" ";
		    }
		   s=t.readLine();
		} 
		else
		    {
		   for (int i=0;i<4;i++)
		     s=t.readLine();		
		     nombre=s;
		    }	

		//we have read the name or the nickname

		for (int i=0;i<22;i++)
		     s=t.readLine();
		     icq=s;
		     telf=t.readLine();
		     	
		nombre+=ESPACIO;
		email+=ESPACIO;	
		telf+=ESPACIO;
		icq+=ESPACIO;
		 
		new QListViewItem (Lista,nombre,email,telf,icq,index);
	nombre=""; 
		}
	      else
		{
		s=t.readLine();
		int salto=s.toInt();
		f.at( f.at()+salto-1 ); 	
		}		 
	    }	

    } 

f.close(); 
}

}

// ---------------------------------------------------------------------
// ---------------------------------------------------------------------

void KLibretaWidget::verPropiedades(unsigned int index)
{
newman = new NuevoWidget();
connect( newman, SIGNAL (applyButtonPressed()), SLOT(applyprop()) );
connect( newman, SIGNAL(cancelButtonPressed()), SLOT(cancelprop()) );
currentItem=index;
newman->setCaption(i18n("Properties"));
QFile f((const char *)fileoutpath);
if (f.open(IO_ReadOnly))
  {   
	QTextStream t( &f );      
	QString s;   
        while((!t.eof()))
	 {
	  bool porsi;  	
	  s=t.readLine();
	  if(s==SALTO)
	    {	
	     s=t.readLine();	//reads the PID
             unsigned int numero=s.toUInt(&porsi);
	      if ((numero!=0)&&(numero==index))  
		{
		s=t.readLine();
		s=t.readLine();
		int correopred=s.toInt();
		newman->w->predet=correopred;
	        for (int p=0;p<=5;p++)
		  {s=t.readLine();
		   if(s!="")
			    {
			     newman->w->BAnadirClicked(s);		
			     }
		
		   }
		//we have added e-mail addresses
		newman->w->ListaMail->setCurrentItem(correopred);
		newman->w->BPredetClicked();

		s=t.readLine(); //reads mostrar
	        int mostrar=s.toInt(&porsi);
		newman->w->Combo1->setCurrentItem(mostrar);
		newman->w->TNombre1->setText(t.readLine());
		newman->w->TNombre2->setText(t.readLine());
		newman->w->TApell->setText(t.readLine());
		newman->w->TSobren->setText(t.readLine());

		newman->p->TPuesto->setText(t.readLine());
		newman->p->TDepart->setText(t.readLine());
		newman->p->TComFax->setText(t.readLine());
		newman->p->TComTelefono->setText(t.readLine());
		newman->p->TOficina->setText(t.readLine());
		newman->p->TCompania->setText(t.readLine());
		newman->p->TComWeb->setText(t.readLine());
		newman->p->TComPais->setText(t.readLine());
		newman->p->TComPCode->setText(t.readLine());
		newman->p->TComState->setText(t.readLine());
		newman->p->TComCiudad->setText(t.readLine());
		newman->p->TComDir->setText(t.readLine());
		newman->p->TComFtp->setText(t.readLine());

		newman->g->TFax->setText(t.readLine());
		newman->g->TWeb->setText(t.readLine());
 		newman->g->TPCode->setText(t.readLine());
		newman->g->TState->setText(t.readLine());
		newman->g->TCiudad->setText(t.readLine());
		newman->g->TPais->setText(t.readLine());
		newman->g->TDir->setText(t.readLine());
		newman->g->TFtp->setText(t.readLine());
		newman->g->TICQ->setText(t.readLine());
		newman->g->TTelefono->setText(t.readLine());
}

	      else
		{
		s=t.readLine();
		int salto=s.toInt();
		f.at( f.at()+salto-1 ); 	
		}		 
	    }	
    } 

f.close(); 
}
newman->w->changed=false;
newman->show();
}

//------------------------------------------------------------
//------------------------------------------------------------

void KLibretaWidget::PreparaPropiedades()
{
unsigned int index;
bool porsi;
if (Lista->currentItem()!=0){
QString Numero=Lista->currentItem()->text(4);

index=Numero.toUInt(&porsi);
printf("%s\n", (const char *)Numero);
verPropiedades(index);}
}

//------------------------------------------------------------
//------------------------------------------------------------
void KLibretaWidget::applyprop()
{
if
((newman->p->changed==true)||(newman->g->changed==true)||(newman->w->changed==true))
{	
	
QString nombre(newman->w->Combo1->text(0));
QString apodo(newman->w->Combo1->text(1));
apodo=apodo.simplifyWhiteSpace();
nombre=nombre.simplifyWhiteSpace();
QString vacio(" ");
vacio=vacio.simplifyWhiteSpace();
QString current(newman->w->Combo1->currentText());
current=current.simplifyWhiteSpace();

if ((nombre!=vacio)||(apodo!=vacio))
{if(current==vacio)
	{
	QMessageBox mensaje(this);
	mensaje.setText(i18n("I will select\na corect name."));
        mensaje.show();
	if (newman->w->Combo1->currentItem()==0)
		newman->w->Combo1->setCurrentItem(1);
	else 	newman->w->Combo1->setCurrentItem(0);
	}

	eliminaper(currentItem);
	insertaper(currentItem);
	Lista->clear();
	actualizaLista();
}
else if ((nombre==vacio)&&(apodo==vacio))
      {
	QMessageBox mensaje(this);
	mensaje.setText(i18n("I need a name or a nickname"));
	newman->hide();
	mensaje.show();
	}
}
}//function
//-------------------------------------------------------------
//-------------------------------------------------------------
void KLibretaWidget::notimplemented()
{
QMessageBox mensaje(this);
	mensaje.setText(i18n("Sorry. It will be implemented
		\nvery soon.(I hope so)")); 	
	mensaje.show();
}
//-------------------------------------------------------------
//-------------------------------------------------------------

//-------------------------------------------------------------
//-------------------------------------------------------------
void KLibretaWidget::cancelprop()
{

}
//-------------------------------------------------------------
//-------------------------------------------------------------
void KLibretaWidget::eliminaContacto()
{
unsigned int index;
bool porsi;
if (Lista->currentItem()!=0)
{
QString Numero=Lista->currentItem()->text(4);
index=Numero.toUInt(&porsi);
printf("%s\n", (const char *)Numero);
eliminaper(index);
Lista->clear();
actualizaLista();
}
}
//-------------------------------------------------------------
//-------------------------------------------------------------
void KLibretaWidget::insertaper(unsigned int intronum)
{
QFile f((const char *)fileoutpath);
if (f.open(IO_ReadWrite))
  {   
	QString ncorreo;
	ncorreo=ncorreo.setNum(newman->w->predet);
//cul es el correo predeterminado

	//si enseamos el apodo o el nombre
	int mostrar=newman->w->Combo1->currentItem();

	QString nombre1=newman->w->TNombre1->text();
	QString nombre2=newman->w->TNombre2->text();
	QString apell=newman->w->TApell->text();
	QString sobren=newman->w->TSobren->text();
	
	QString email1=newman->w->ListaMail->text(0);
	QString email2=newman->w->ListaMail->text(1);
	QString email3=newman->w->ListaMail->text(2);
	QString email4=newman->w->ListaMail->text(3);
	QString email5=newman->w->ListaMail->text(4);
	QString email6=newman->w->ListaMail->text(5);


	QString puesto=newman->p->TPuesto->text();
	QString depart=newman->p->TDepart->text();
	QString comfax=newman->p->TComFax->text();
	QString comtelef=newman->p->TComTelefono->text();
	QString oficina=newman->p->TOficina->text();
	QString compania=newman->p->TCompania->text();
	QString comweb=newman->p->TComWeb->text();
	QString compais=newman->p->TComPais->text();
	QString compcode=newman->p->TComPCode->text();
	QString comstate=newman->p->TComState->text();
	QString comciudad=newman->p->TComCiudad->text();
	QString comdir=newman->p->TComDir->text();
	QString comftp=newman->p->TComFtp->text();

	QString fax=newman->g->TFax->text();
	QString telef=newman->g->TTelefono->text();
	QString web=newman->g->TWeb->text();
 	QString pcode=newman->g->TPCode->text();
	QString state=newman->g->TState->text();
	QString ciudad=newman->g->TCiudad->text();
	QString dir=newman->g->TDir->text();
	QString ftp=newman->g->TFtp->text();
	QString icq=newman->g->TICQ->text();
	QString pais=newman->g->TPais->text();

	nombre1=nombre1.simplifyWhiteSpace();
	nombre2=nombre2.simplifyWhiteSpace();
	apell=apell.simplifyWhiteSpace();
	sobren=sobren.simplifyWhiteSpace();
	
	email1=email1.simplifyWhiteSpace();
	email2=email2.simplifyWhiteSpace();
	email3=email3.simplifyWhiteSpace();
	email4=email4.simplifyWhiteSpace();
	email5=email5.simplifyWhiteSpace();
	email6=email6.simplifyWhiteSpace();


	puesto=puesto.simplifyWhiteSpace();
	depart=depart.simplifyWhiteSpace();
	comfax=comfax.simplifyWhiteSpace();
	comtelef=comtelef.simplifyWhiteSpace();
	oficina=oficina.simplifyWhiteSpace();
	compania=compania.simplifyWhiteSpace();
	comweb=comweb.simplifyWhiteSpace();
	compais=compais.simplifyWhiteSpace();
	compcode=compcode.simplifyWhiteSpace();
	comstate=comstate.simplifyWhiteSpace();
	comciudad=comciudad.simplifyWhiteSpace();
	comdir=comdir.simplifyWhiteSpace();
	comftp=comftp.simplifyWhiteSpace();

	fax=fax.simplifyWhiteSpace();
	telef=telef.simplifyWhiteSpace();
	web=web.simplifyWhiteSpace();
 	pcode=pcode.simplifyWhiteSpace();
	state=state.simplifyWhiteSpace();
	ciudad=ciudad.simplifyWhiteSpace();
	dir=dir.simplifyWhiteSpace();
	ftp=ftp.simplifyWhiteSpace();
	icq=icq.simplifyWhiteSpace();
	pais=pais.simplifyWhiteSpace();

	int talla=0;
	talla+=nombre1.length()+nombre2.length()+apell.length();
	talla+=sobren.length();//este uno es el de ncorreo;
	talla+=4;//por cada uno de los endl

//habr que poner 6 aqu cuando le meta la preferencia;

	talla+=puesto.length()  + depart.length() + comfax.length();
	talla+=comtelef.length()+ oficina.length()+ compania.length();	
	talla+=comweb.length()  + compais.length()+ compcode.length();
	talla+=comstate.length() + comciudad.length()+comdir.length();
	talla+=comftp.length()    + 13;

	talla+=fax.length()+telef.length()+web.length()+pcode.length();
	talla+=state.length()+ciudad.length()+dir.length()+ftp.length();
	talla+=icq.length() +pais.length()      + 10;

	talla+=email1.length()+email2.length()+email3.length()+email4.length();
	talla+=email5.length()+email6.length() + 6;

	talla+=ncorreo.length()+1+1+1;//endl+mostrar+endl


	QTextStream t(&f);
	QString s;
	unsigned int menor=1;//stores the smallest PID AVALAIBLE
	
// the party begins!!!!!!!!!
//----------------------------

	while(!t.eof())
	 {
	  bool porsi;  	// stores toint
	  s=t.readLine();
	  if (s==SALTO)
	    {	
		s=t.readLine();
		unsigned int temp=s.toInt(&porsi);
		if (temp>=menor)
			menor=temp+1;
		s=t.readLine();
		int salto=s.toInt(&porsi);
		f.at( f.at()+salto -1); 	
	     }	
	 
	  }
	if (intronum!=0)menor=intronum;
	t<<SALTO<<endl;
	t<<menor<<endl;
	t<<talla<<endl;
	
	t<<ncorreo<<endl;
	t<<email1<<endl;
	t<<email2<<endl;
	t<<email3<<endl;
	t<<email4<<endl;
	t<<email5<<endl;
	t<<email6<<endl;


	t<<mostrar<<endl;

	t<<nombre1<<endl;
	t<<nombre2<<endl;
	t<<apell<<endl;
	t<<sobren<<endl;
	

	t<<puesto<<endl;
	t<<depart<<endl;
	t<<comfax<<endl;
	t<<comtelef<<endl;
	t<<oficina<<endl;
	t<<compania<<endl;
	t<<comweb<<endl;
	t<<compais<<endl;
	t<<compcode<<endl;
	t<<comstate<<endl;
	t<<comciudad<<endl;
	t<<comdir<<endl;
	t<<comftp<<endl;

	t<<fax<<endl;
	t<<web<<endl;
 	t<<pcode<<endl;
	t<<state<<endl;
	t<<ciudad<<endl;
	t<<pais<<endl;
	t<<dir<<endl;
	t<<ftp<<endl;
	t<<icq<<endl;
	t<<telef<<endl;
	

 }

f.close();
} 

//-----------------------------------------------------
//-----------------------------------------------------

void KLibretaWidget::eliminaper(unsigned int index)
{
QFile f((const char *)fileoutpath);
if (f.open(IO_ReadWrite))
  {   
	QTextStream t( &f );      
	QString s;   
        while((!t.eof()))
	 {
	  bool porsi;  	
	  s=t.readLine();
	  if(s==SALTO)
		{
                 s=t.readLine();//reads the PID
		 unsigned int num=s.toUInt(&porsi); 
		 if(num==index)
		  {
		    f.at(f.at()-s.length()-1);
		    s.fill(' ',-1); 	
		    s.replace(0,1,"0");	
		    t<<s<<endl;	 
		   }//from if(num==index);
		 else
		  {
		   s=t.readLine();//reads the PID
		   int salto=s.toUInt(&porsi); 
	           f.at(f.at()+salto-1);
		   }
		}//from if(s==salto)    
	}//from while

  }//from if open  	  
f.close();
}




