//////////////////////////////////////////////////////////////////////////////
// This software is distributed under the terms of the General Public License.
//
// Program : kless
// Author  : Norbert Drees & Ralf Haferkamp
// E-Mail  : norbert@et-inf.fho-emden.de
//           hafer@et-inf.fho-emden.de
//////////////////////////////////////////////////////////////////////////////

#ifndef INPUT_H
#define INPUT_H

#ifdef KLESSDEBUG
#include <iostream.h>
#endif

#include <qdialog.h>
#include <qbttngrp.h>
#include <qlined.h>
#include <qpushbt.h>

#include <kapp.h>
#include <klocale.h>

class InputWindow : public QDialog {

	Q_OBJECT
    
public:
	InputWindow(
		const char	*text,
		const char	*input,
		QWidget		*parent = 0,
		const char	*name = 0
	);

	QString getText();					 
	
private:
	QPushButton	*ok;
	QLineEdit	*edit;
	QString 		TEXT, INPUT;
	
private slots:
	void newFocus();
	void exit();
};

#endif
