//////////////////////////////////////////////////////////////////////////////
// This software is distributed under the terms of the General Public License.
//
// Program : kless
// Author  : Norbert Drees & Ralf Haferkamp
// E-Mail  : norbert@et-inf.fho-emden.de
//           hafer@et-inf.fho-emden.de
//////////////////////////////////////////////////////////////////////////////

#include "input.h"

InputWindow::InputWindow(	const char *text, const char *input,
									QWidget *parent, const char *name )
   : QDialog( parent , name, TRUE ), TEXT( text ), INPUT( input ) {

	setCaption( klocale->translate( "Options" ) );
	resize( 300, 130 );

	QButtonGroup *frame = new QButtonGroup( this );
	frame->setFrameStyle( 49 );
	frame->setGeometry( 10, 10, 280, 70 );

	frame->setTitle( TEXT );
	frame->setAlignment( 1 );
	frame->lower();
	
	edit = new QLineEdit( this );
	edit->setText( INPUT );
	edit->move( 20, 35 );
	edit->resize( 260, 30 );
	edit->setFocus();
	connect( edit, SIGNAL( returnPressed() ), SLOT( newFocus() ) );

	ok = new QPushButton( this );
	ok->setText( klocale->translate( "Ok" ) );
	ok->move( 10, 90 );
	ok->resize( 100, 30 );
	connect( ok, SIGNAL( clicked() ), SLOT( accept() ) );
	
	QPushButton *cancel = new QPushButton( this );
	cancel->setText( klocale->translate( "Cancel" ) );
	cancel->move( 190, 90 );
	cancel->resize( 100, 30 );
	connect( cancel, SIGNAL( clicked() ), SLOT( exit() ) );
}

QString InputWindow::getText() {

	return edit->text();
}

void InputWindow::newFocus() {

	ok->setFocus();
}

void InputWindow::exit() {

	edit->setText( "" );
	accept();
}
