#ifndef KKB_H 
#define KKB_H

#include <qintdict.h>
#include <qlist.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qpopmenu.h>
#include <qstrlist.h>
#ifdef ACCEL
#include <kglobalaccel.h>
#endif
#include <kapp.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/XKBlib.h>

#ifndef XKB_DIR
#define XKB_DIR "/usr/X11R6/lib/X11/xkb"
#endif


class KkbConfigClass: public QObject {
  Q_OBJECT
 private:
  QPixmap                        pixmap;
  QString                        layout;
  QString                       lang[4];
  QString                         descr;
 public:
  QString                   getLayout();
  QPixmap                   getPixmap();
  QString                  getLang(int);
  QString                    getDescr();
  KkbConfigClass(QPixmap, QString, QString[4], QString);
};

class KkbMappingList: public QListT<KkbConfigClass> {
 public: 
  KkbMappingList() {setAutoDelete(True);}
  ~KkbMappingList(){}
};

class KkbButton: public QLabel {
  Q_OBJECT
 protected:
  void   mousePressEvent(QMouseEvent *);
 public:
  KkbButton(QWidget*);
 signals:
  void                       showMenu();
  void                        clicked();
  void                     midclicked();
};

class KkbMain: public KApplication {
  Q_OBJECT
 protected:
  virtual bool x11EventFilter(XEvent *);
  int                            isBeep;
  int                     KkbGetState();
  KkbButton                     *button;
  //int                             state;
  int                i1, i2, i3, i4, i5; 
  //QString                       lang[4];
  void 	                 KkbGetConfig();
  QPopupMenu                      *menu;
  //  void       keyPressEvent(QKeyEvent *);
#ifdef ACCEL
  KGlobalAccel                    *keys;
#endif
  QStrList                        langs;
  void   mousePressEvent(QMouseEvent *);
  KkbMappingList            *configData;
      
 public:
  KkbMain(int, char**);
  ~KkbMain();

 public slots:
  void           KkbChangeGlobalGroup();
  void                       showMenu();
  void                 KkbChangeState();
  void                         dobeep();
  void                       doconfig();
  void                activateMenu(int);
 private:
  bool          getMappingInformation();
  bool                   setXkbLayout(); 
  char                     *getLocale();
  QString                    changekeys;
  int                            beepID; 
  
};

#endif
