#include <stdio.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>

#include <kapp.h>

#include "pppstatus.h"


PPPStatus::PPPStatus(void)
{
  ushort i;

  fd = open("/dev/isdninfo", O_RDONLY | O_NDELAY);

  if (fd < 0)
  {
    fprintf(stderr, "Can't open /dev/isdninfo");
    kapp->quit();
  }

  for (i = 0; i < ISDN_MAX_CHANNELS; i++)
  {
    ioBytes[i].ibytes = 0;
    ioBytes[i].obytes = 0;
      
  }

  Info = new PPPInfo();
  memset( Info, 0, sizeof( PPPInfo ) );
  
  for (i = 0; i < 2; i++)
  {
    Info->totalBytesIn[i]  = 0;
    Info->totalBytesOut[i] = 0;
  }
  
  gettimeofday(&TimeLast, NULL); 
  TimeNow = TimeLast;
  
  Info->timeHours = (ushort) (TimeNow.tv_sec/3600);
  Info->timeMins  = (ushort) (TimeNow.tv_sec%3600);
  
  Scanner = new QTimer(this);
  connect(Scanner, SIGNAL(timeout()), this, SLOT(slotScanRates()));
  Scanner->start(3000, true);  
}


void PPPStatus::slotScanRates(void)
{
  float      deltaKBytes, Rate;
  int        secondsPassed;
  struct tm  *LocTime;
  
  gettimeofday(&TimeNow, NULL);
  LocTime = localtime((time_t *) &TimeNow);
  
  Info->timeHours = LocTime->tm_hour;
  Info->timeMins  = LocTime->tm_min;  
  
  secondsPassed   = (TimeNow.tv_sec+TimeNow.tv_usec/1000000)-(TimeLast.tv_sec+TimeLast.tv_usec/1000000);
  
  TimeLast = TimeNow; 
  
  if (ioctl(fd, IIOCGETCPS, &ioBytes)) fprintf(stderr, "IOCTL error (IIOCGETCPS)\n");        
  else
  {
    for (ushort i = 0; i < 2; i++)
    {
      if (ioBytes[i].ibytes) 
      {
        deltaKBytes = (float)(ioBytes[i].ibytes - Info->totalBytesIn[i])/1024;

	Rate = deltaKBytes/secondsPassed;
	if (secondsPassed && (Rate < 30.0)) Info->inRate[i] = Rate; 
	else                                Info->inRate[i] = 0.0;
	
        Info->totalBytesIn[i]   = ioBytes[i].ibytes;
	
      }   
      if (ioBytes[i].obytes) 
      {
        deltaKBytes = (float)(ioBytes[i].obytes - Info->totalBytesOut[i])/1024;
	
	Rate = deltaKBytes/secondsPassed;
	if (secondsPassed && (Rate < 30.0)) Info->outRate[i] = deltaKBytes/secondsPassed; 
	else                                Info->outRate[i] = 0.0;
	     
        Info->totalBytesOut[i] = ioBytes[i].obytes;
      }
    }
  } 
  emit sigNewScan(Info);
  Scanner->start(3000, true);    
}

#include "pppstatus.moc"
