/*
 * kheise.cpp
 *
 * Copyright (c) 1998 Michael Kropfberger <mkropfbe@edu.uni-klu.ac.at>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <stdlib.h>    

#include <qapp.h>
#include <qpushbt.h>
#include <qscrbar.h>
#include <qlcdnum.h>
#include <qfont.h>
#include <qfiledlg.h>        

#include <kmsgbox.h>
#include <ktopwidget.h>
#include <kstdaccel.h>
#include <kiconloader.h>
#include <kwm.h>
#include <kapp.h>
#include "klocale.h"

#include "kheise.h"
#include "kheise.moc"

#include "heisedlg.h"


QList<MyMainWidget> MyMainWidget::windowList;          

/************************************************************************
* Constructor
*/
MyMainWidget::MyMainWidget(QWidget *, const char* name ) 
                                          : KTopLevelWidget( name )
 {  
  windowList.append(this);
  //  KConfig *kc = kapp->getConfig();
 
 
  KWM::setIcon(winId(), kapp->getIcon());
  KWM::setMiniIcon(winId(), kapp->getMiniIcon());       
  
  searchInterrupted=FALSE;

  KStdAccel accKey = KStdAccel(kapp->getConfig());

  fileMenu = new QPopupMenu; CHECK_PTR(fileMenu);
  fileMenu->insertItem( klocale->translate( "&New Window" ), this,
                        SLOT(fileMenuNewSlot()), accKey.openNew() );
  updateMenuEntryID =  fileMenu->insertItem( klocale->translate(
                         "&Monthly update" ), this,
                         SLOT(fileMenuUpdateDBSlot()) );
  fileMenu->insertSeparator();
  fileMenu->insertItem( klocale->translate( "&Quit" ), this,
                        SLOT(fileMenuQuitSlot()), accKey.quit() );

  searchMenu = new QPopupMenu; CHECK_PTR(searchMenu);
  startMenuEntryID=searchMenu->insertItem( klocale->translate("&Start"),
                        this, SIGNAL(startSearch()) );
  stopMenuEntryID=searchMenu->insertItem( klocale->translate("S&top"),
                        this, SIGNAL(stopSearch()) );

 

  menuBar = new KMenuBar( this ); CHECK_PTR( menuBar );
  
  menuBar->insertItem( klocale->translate( "&File" ), fileMenu );
  menuBar->insertItem( klocale->translate( "&Search"), searchMenu );
  menuBar->insertSeparator();
  menuBar->insertItem( klocale->translate( "&Help" ),kapp->getHelpMenu(TRUE,
                    "KHeise 0.4b/98"
              "\n\nby Michael Kropfberger"
            "\n(mkropfbe@edu.uni-klu.ac.at)" ) );

  menuBar->setItemEnabled(stopMenuEntryID,FALSE);
  setMenu(menuBar);
  menuBar->show();
  
  /* ToolBar disabled.... senseless and unstable
 KIconLoader *loader = kapp->getIconLoader();
  toolBar = new KToolBar( this ); CHECK_PTR(toolBar);

  toolBar->insertButton( loader->loadIcon( "viewzoom.xpm" ), startButtonID,
                     SIGNAL(clicked(int)),
                     this, SIGNAL(startSearch()), TRUE, 
                     klocale->translate( "starts a new search" ));

  toolBar->insertButton( loader->loadIcon( "stop.xpm" ), stopButtonID,
                     SIGNAL(clicked(int)),
                     this, SIGNAL(stopSearch()), FALSE, 
                     klocale->translate( "stops the running search" ));

 
  addToolBar(toolBar);
  toolBar->show();
  */  

  statusBar = new KStatusBar(this); CHECK_PTR(statusBar);
  statusBar->insertItem(klocale->translate("Please enter your searchpatterns!"),-1);
  setStatusBar(statusBar);
  statusBar->show();

  heiseDlg = new HeiseDlg(this);  
  setView(heiseDlg);
  setMinimumSize(heiseDlg->sizeHint());
  resize(heiseDlg->sizeHint());
  show();
  setCaption(kapp->getCaption());  

  HeiseWrapper hw_tmp;  // check if user has write-perms on DB
  if ( hw_tmp.DB_isWritable()==FALSE ) {
    fileMenu->setItemEnabled(updateMenuEntryID,FALSE);
  }

  // upward connecting from HeiseDlg
  connect(heiseDlg,SIGNAL(startSearch()),this,SIGNAL(startSearch()) );
  connect(heiseDlg,SIGNAL(stopSearch()),this,SIGNAL(stopSearch()) );
  connect(heiseDlg,SIGNAL(searchDone()),this,SIGNAL(searchDone()) );

  connect(this,SIGNAL(startSearch()),this,SLOT(startSearchSlot()) );
  connect(this,SIGNAL(stopSearch()),this,SLOT(stopSearchSlot()) );
  connect(this,SIGNAL(searchDone()),this,SLOT(searchDoneSlot()) );
};

/************************************************************************
  *  Destructor
**/
MyMainWidget::~MyMainWidget() {
  //debug("DESTRUCTING!");
  //delete toolBar;
  delete menuBar;
  delete statusBar;
}

/************************************************************************
  *  closeEvent
**/
void MyMainWidget::closeEvent ( QCloseEvent *ev) {
  //debug("MyMainWidget::closeEvent");
 windowList.remove(this);
 if (windowList.isEmpty())
     kapp->quit();
  ev->accept();
} 

/************************************************************************
  * fileMenuNewSlot
**/
void MyMainWidget::fileMenuNewSlot() {
  // debug("MyMainWidget::fileMenuNewSlot");
  new MyMainWidget();
};

/************************************************************************
  * fileMenuUpdateDBSlot
**/
void MyMainWidget::fileMenuUpdateDBSlot() {
  //debug("MyMainWidget::fileMenuUpdateDBSlot");
   QFileDialog *log=new QFileDialog;
   QString fileName = log->getOpenFileName(0,"*.CTI");
   //debug("choosen File: %s",fileName.data() );
   if (fileName.isEmpty()) return;
   else {
      menuBar->setItemEnabled(startMenuEntryID,FALSE);
      menuBar->setItemEnabled(stopMenuEntryID,FALSE);
      //toolBar->setItemEnabled(startButtonID,FALSE);
      //toolBar->setItemEnabled(stopButtonID,FALSE);
      heiseDlg->updateDBSlot(fileName);
   }
};

/************************************************************************
  * fileMenuQuitSlot
**/
void MyMainWidget::fileMenuQuitSlot() {
  //debug("MyMainWidget::fileMenuQuitSlot");
   this->close();
};

/************************************************************************
  * startSearchSlot
**/
void MyMainWidget::startSearchSlot() {
  //debug("MyMainWidget::startSearchSlot");
  menuBar->setItemEnabled(startMenuEntryID,FALSE);
  menuBar->setItemEnabled(stopMenuEntryID,TRUE);
  //toolBar->setItemEnabled(startButtonID,FALSE);
  //toolBar->setItemEnabled(stopButtonID,TRUE);
  statusBar->changeItem(klocale->translate("Please wait.... I'm searching for "
         "matching articles"),-1);
  searchInterrupted=FALSE;
  heiseDlg->startSearchSlot();
};

/************************************************************************
  * stopSearchSlot
**/
void MyMainWidget::stopSearchSlot() {
  //debug("MyMainWidget::stopSearchSlot");
  menuBar->setItemEnabled(startMenuEntryID,TRUE);
  menuBar->setItemEnabled(stopMenuEntryID,FALSE);
  //toolBar->setItemEnabled(startButtonID,TRUE);
  //toolBar->setItemEnabled(stopButtonID,FALSE);
  statusBar->changeItem(klocale->translate("Last search was interrupted..."),-1);
  searchInterrupted=TRUE;
  heiseDlg->stopSearchSlot();
};

/************************************************************************
  * searchDoneSlot
**/
void MyMainWidget::searchDoneSlot() {
  //debug("MyMainWidget::searchDoneSlot");
  menuBar->setItemEnabled(startMenuEntryID,TRUE);
  menuBar->setItemEnabled(stopMenuEntryID,FALSE);
  //toolBar->setItemEnabled(startButtonID,TRUE);
  //toolBar->setItemEnabled(stopButtonID,FALSE);
  if (!searchInterrupted)
    statusBar->changeItem(klocale->translate("Please enter new patterns for"
                 "a further search!"),-1);
  searchInterrupted=FALSE;
};


/************************************************************************
  * main
**/
int main(int argc, char **argv) {
  KApplication a( argc, argv );  
  //  MyMainWidget *mw = new MyMainWidget();
  // a.setMainWidget( mw );

  //SessionManagement
  if (a.isRestored()) {
    int n = 1;
    while (KTopLevelWidget::canBeRestored(n)) {
      MyMainWidget *mw = new MyMainWidget();
      CHECK_PTR(mw);
      mw->restore(n);
      n++;
    } 
  } else {
      MyMainWidget *mw = new MyMainWidget();
    CHECK_PTR(mw);
    
    mw->show();
  }
  return a.exec();
}
