////////////////////////////////////////////////////////////////////////
//  Originated by Logikos, Inc.  http://www.logikos.com
//
//  Class       : KGrepSearchDlg
//
//  File Name   : kgrepsearchdlg.cc
//
//  Originated  : 7-Sept-99  Keith Brown (kbrown@logikos.com)
//
//  Abstract    : See notes in kgrepsearchdlg.h .
//
//  Compiler    : egcs-1.1.2, qt 1.44, KDE 1.1.1
//
//  Revisions   :
//
////////////////////////////////////////////////////////////////////////

// Compiler includes
#include <kfiledialog.h>
#include <kmsgbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>

// Project includes
#include "kgrepsearchdlg.moc"

// Constants

// Globals

// Static attributes



////////////////////////////////////////////////////////////////////////
//
//  Function      : KGrepSearchDlg
//
//  Originated    : 7-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Constructor.  Creates tabs, edit fields, etc...
//
//  Parameters    : parent - pointer to parent QWidget
//                  name   - pointer to internal name string
//                  modal  - boolean value indicating if this dialog is
//                           modal or not
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
KGrepSearchDlg::KGrepSearchDlg(QWidget* parent, const char* name, bool modal):
  QTabDialog(parent, name, modal)
{
    // BEGIN
    setCaption(i18n("New Search"));
    setCancelButton();

    // Set up slots for the buttons
    connect(this, SIGNAL(applyButtonPressed()), SLOT(slotOK()));
    connect(this, SIGNAL(cancelButtonPressed()), SLOT(slotCancel()));
    connect(this, SIGNAL(aboutToShow()), SLOT(slotAboutToShow()));

    // Add tabs to the tab control
    createTabPattern(this);
    createTabLocation(this);

    // Set up slots from some of the widget signals
    connect(m_dirEdit, SIGNAL(textChanged(const char*)), this, SLOT(slotDirEntry(const char*)));
    connect(m_fileEdit, SIGNAL(textChanged(const char*)), this, SLOT(slotFileEntry(const char*)));
    connect(m_patEdit, SIGNAL(textChanged(const char*)), this, SLOT(slotPatternEntry(const char*)));
    connect(m_patFileEdit, SIGNAL(textChanged(const char*)), this, SLOT(slotPatternFileEntry(const char*)));

    resize(450, 325);

    return;

}   // end KGrepSearchDlg::KGrepSearchDlg


////////////////////////////////////////////////////////////////////////
//
//  Function      : ~KGrepSearchDlg
//
//  Originated    : 7-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Destructor.
//
//  Parameters    : none
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
KGrepSearchDlg::~KGrepSearchDlg()
{
    // BEGIN
    // NOTE: (From the memory-leak hunting HOWTO) "... when dealing with QWidgets
    //       and derived Qt and KDE subclasses: The destructor of a parent
    //       object destroys all child objects. This saves you from writing your
    //       own clean-up code for widgets that have been constructed with a
    //       pointer to the parent."

    return;

}   // end KGrepSearchDlg::~KGrepSearchDlg


////////////////////////////////////////////////////////////////////////
//
//  Function      : createTabPattern
//
//  Originated    : 7-Sept-99 - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Creates a tab in this tab dialog.  Here the user
//                  will enter the string or regexp they want to search
//                  for and some other options.  Uses a grid layout to
//                  position widgets on this tab.
//
//  Parameters    : parent - pointer to parent QWidget
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepSearchDlg::createTabPattern(QWidget* parent)
{
    // Local variables
    QWidget*     tab   = new QWidget(parent);
    QGroupBox*   group = new QGroupBox(i18n(" Search Options "), tab, "btngroup");
    QLabel*      label = new QLabel(i18n("String or Regexp: "), tab);
    QLabel*      labelOr = new QLabel(i18n("or"), tab);
    QLabel*      pLabel  = new QLabel(i18n("Pattern File: "), tab);
    QGridLayout* optGrid = new QGridLayout(group, 5, 1, 20, 5);
    QGridLayout* grid  = new QGridLayout(tab,  // parent is this tab
                                         5,    // rows
                                         3,    // cols
                                         20,   // border spacing
                                         5     // widget spacing
                                         );


    // BEGIN
    // Add the pattern edit field
    label->setBuddy(m_patEdit);
    label->adjustSize();
    label->resize((int)label->sizeHint().width(), (int)label->sizeHint().height() + 6);
    label->setMinimumSize(label->size());

    m_patEdit = new QLineEdit(tab, "pattern edit");
    m_patEdit->setMinimumSize(50, label->height() + 2);
    m_patEdit->setMaximumSize(800, label->height() + 2);

    labelOr->adjustSize();
    labelOr->setMinimumSize(labelOr->sizeHint());

    // Add the pattern file edit field and button
    pLabel->setBuddy(m_patFileEdit);
    pLabel->adjustSize();
    pLabel->resize((int)pLabel->sizeHint().width(), (int)pLabel->sizeHint().height() + 6);
    pLabel->setMinimumSize(pLabel->size());

    m_patFileEdit = new QLineEdit(tab, "pattern file edit");
    m_patFileEdit->setMinimumSize(50, pLabel->height() + 2);
    m_patFileEdit->setMaximumSize(800, pLabel->height() + 2);

    m_patFileBtn = new QPushButton(i18n("Browse..."), tab, "patFBrowseBtn");
    m_patFileBtn->adjustSize();
    m_patFileBtn->setMinimumSize(m_patFileBtn->sizeHint());

    // Add the search options
    m_binDataChkBox      = new QCheckBox(i18n("Don't supress binary data"), group, "bindatachk");
    m_caseSenChkBox      = new QCheckBox(i18n("Case sensitive"), group, "casesenchk");
    m_linesWOMatchChkBox = new QCheckBox(i18n("Show lines that *do not* match"), group, "notmatchchk");
    m_reqWholeWordChkBox = new QCheckBox(i18n("Require whole word to match"), group, "wholewordchk");
    m_reqWholeLineChkBox = new QCheckBox(i18n("Require whole line to match"), group, "wholelinechk");

    m_binDataChkBox->setMinimumSize(m_binDataChkBox->sizeHint());
    m_caseSenChkBox->setMinimumSize(m_caseSenChkBox->sizeHint());
    m_linesWOMatchChkBox->setMinimumSize(m_linesWOMatchChkBox->sizeHint());
    m_reqWholeWordChkBox->setMinimumSize(m_reqWholeWordChkBox->sizeHint());
    m_reqWholeLineChkBox->setMinimumSize(m_reqWholeLineChkBox->sizeHint());

    optGrid->addWidget(m_caseSenChkBox, 0, 0);
    optGrid->addWidget(m_linesWOMatchChkBox, 1, 0);
    optGrid->addWidget(m_reqWholeWordChkBox, 2, 0);
    optGrid->addWidget(m_reqWholeLineChkBox, 3, 0);
    optGrid->addWidget(m_binDataChkBox, 4, 0);
    optGrid->activate();

    grid->addWidget(label, 0, 0);
    grid->addMultiCellWidget(m_patEdit,  // widget
                             0,          // from row
                             0,          // to row
                             1,          // from col
                             2           // to col
                             );

    grid->addWidget(labelOr, 1, 1);

    grid->addWidget(pLabel, 2, 0);
    grid->addWidget(m_patFileEdit, 2, 1);
    grid->addWidget(m_patFileBtn, 2, 2);

    grid->addMultiCellWidget(group,     // widget
                             3,         // from row
                             3,         // to row
                             0,         // from col
                             2          // to col
                             );

    grid->setRowStretch(4, 1);
    grid->setColStretch(1, 1);
    grid->activate();

    // Connect up the pattern file browse button.
    connect(m_patFileBtn, SIGNAL(clicked()), this, SLOT(slotPatternFileBrowse()));

    addTab(tab, i18n(" &Pattern "));

    return;

}   // end KGrepSearchDlg::createTabPattern


////////////////////////////////////////////////////////////////////////
//
//  Function      : createTabLocation
//
//  Originated    : 7-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Creates the tab in this tab dialog where the user
//                  will enter the location to search and some other
//                  options.
//
//  Parameters    : parent - pointer to parent QWidget
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepSearchDlg::createTabLocation(QWidget* parent)
{
    // Local variables
    QWidget*     tab     = new QWidget(parent);
    QLabel*      dLabel  = new QLabel(i18n("Directory(s): "), tab);
    QLabel*      fLabel  = new QLabel(i18n("File(s): "), tab);
    QLabel*      labelOr = new QLabel(i18n("or"), tab);
    QGridLayout* grid    = new QGridLayout(tab, // parent is this tab
                                           5,   // rows
                                           3,   // cols
                                           20,  // border spacing
                                           5    // widget spacing
                                           );


    // BEGIN
    fLabel->setBuddy(m_fileEdit);
    fLabel->adjustSize();
    fLabel->resize((int)fLabel->sizeHint().width(),fLabel->sizeHint().height() + 6);
    fLabel->setMinimumSize(fLabel->size());

    m_fileEdit = new QLineEdit(tab, "file edit");
    m_fileEdit->setText("*.cc *.h");
    m_fileEdit->setMinimumSize(50, fLabel->height()+2);
    m_fileEdit->setMaximumSize(800, fLabel->height()+2);

    m_fileBtn = new QPushButton(i18n("Browse..."), tab, "fileBrowseBtn");
    m_fileBtn->adjustSize();
    m_fileBtn->setMinimumSize(m_fileBtn->sizeHint());

    labelOr->adjustSize();
    labelOr->setMinimumSize(labelOr->sizeHint());

    dLabel->setBuddy(m_fileEdit);
    dLabel->adjustSize();
    dLabel->resize((int)dLabel->sizeHint().width(),dLabel->sizeHint().height() + 6);
    dLabel->setMinimumSize(dLabel->size());

    m_dirEdit = new QLineEdit(tab, "directory edit");
    m_dirEdit->setText("");
    m_dirEdit->setMinimumSize(50, dLabel->height()+2);
    m_dirEdit->setMaximumSize(800, dLabel->height()+2);
    m_dirEdit->setEnabled(false);

    m_dirBtn = new QPushButton(i18n("Browse..."), tab, "dirBrowseBtn");
    m_dirBtn->adjustSize();
    m_dirBtn->setMinimumSize(m_dirBtn->sizeHint());
    m_dirBtn->setEnabled(false);

    m_recurseDirChkBox = new QCheckBox(i18n("Recurse Sub-directory(s)"),  // text
                                       tab,                               // parent
                                       "recursive"                        // internal name
                                       );
    m_recurseDirChkBox->adjustSize();
    m_recurseDirChkBox->setMinimumSize(m_recurseDirChkBox->sizeHint());
    m_recurseDirChkBox->setEnabled(false);

    // Lay out the widgets in the grid container
    grid->addWidget(fLabel, 0, 0);
    grid->addWidget(m_fileEdit, 0, 1);
    grid->addWidget(m_fileBtn, 0, 2);

    grid->addWidget(labelOr, 1, 1);

    grid->addWidget(dLabel, 2, 0);
    grid->addWidget(m_dirEdit, 2, 1);
    grid->addWidget(m_dirBtn, 2, 2);

    grid->addWidget(m_recurseDirChkBox, 3, 1);

    grid->setRowStretch(4, 1);
    grid->setColStretch(1, 1);
    grid->activate();

    // Connect up the buttons
    connect(m_dirBtn, SIGNAL(clicked()), this, SLOT(slotDirBrowse()));
    connect(m_fileBtn, SIGNAL(clicked()), this, SLOT(slotFileBrowse()));

    addTab(tab, i18n(" &Location "));

    return;

}   // end KGrepSearchDlg::createTabLocation


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotAboutToShow
//
//  Originated    : 7-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Slot for the QTabDialog's aboutToShow() signal.
//                  The purpose of this function is to set the focus to
//                  the pattern edit field when the dialog pops up.
//
//  Parameters    : none
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepSearchDlg::slotAboutToShow()
{
    // BEGIN
    m_patEdit->setFocus();

    return;

}   // end KGrepSearchDlg::slotAboutToShow


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotDirBrowse
//
//  Originated    : 17-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Slot for the QButton's clicked signal.  Opens a
//                  directory browse dialog.
//
//  Parameters    : none
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepSearchDlg::slotDirBrowse()
{
    // Local variables
    QString rStr;


    // BEGIN
    rStr = KDirDialog::getDirectory("/", this, "dir browse");

    if (rStr.length() != 0)
    {
        m_dirEdit->setText(rStr);
    }   // end if

    return;

}   // end KGrepSearchDlg::slotDirBrowse


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotDirEntry
//
//  Originated    : 17-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Slot for the QLineEdit's textChanged signal.  Sets
//                  up mutual exclusion between file and directory entry.
//
//  Parameters    : text - The text that is contained in the edit field
//                         after the user's modifications.
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepSearchDlg::slotDirEntry(const char* text)
{
    // BEGIN
    if (strlen(text) == 0)
    {
        // No directory specified
        m_fileEdit->setEnabled(true);
        m_fileBtn->setEnabled(true);
    }   // end if
    else
    {
        // They are entering a directory
        m_fileEdit->setEnabled(false);
        m_fileBtn->setEnabled(false);
    }   // end else

    return;

}   // end KGrepSearchDlg::slotDirEntry


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotFileBrowse
//
//  Originated    : 20-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Slot for the QButton's clicked signal.  Opens a
//                  file browse dialog.
//
//  Parameters    : none
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepSearchDlg::slotFileBrowse()
{
    // Local variables
    QString rStr;


    // BEGIN
    rStr = KFileDialog::getOpenFileName("/", 0, this, "file browse");

    if (rStr.length() != 0)
    {
        QString cur = m_fileEdit->text();

        // Append newly selected file to current file(s)
        cur = cur + " " + rStr;

        m_fileEdit->setText(cur);
    }   // end if

    return;

}   // end KGrepSearchDlg::slotFileBrowse


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotFileEntry
//
//  Originated    : 17-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Slot for the QLineEdit's textChanged signal.  Sets
//                  up mutual exclusion between file and directory entry.
//
//  Parameters    : text - The text that is contained in the edit field
//                         after the user's modifications.
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepSearchDlg::slotFileEntry(const char* text)
{
    // BEGIN
    if (strlen(text) == 0)
    {
        // No file specified
        m_dirEdit->setEnabled(true);
        m_dirBtn->setEnabled(true);
        m_recurseDirChkBox->setEnabled(true);
    }   // end if
    else
    {
        // They are entering a file
        m_dirEdit->setEnabled(false);
        m_dirBtn->setEnabled(false);
        m_recurseDirChkBox->setEnabled(false);
    }   // end else

    return;

}   // end KGrepSearchDlg::slotFileEntry


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotPatternEntry
//
//  Originated    : 17-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Slot for the QLineEdit's textChanged signal.  Sets
//                  up mutual exclusion between pattern and pattern
//                  file entry.
//
//  Parameters    : text - The text that is contained in the edit field
//                         after the user's modifications.
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepSearchDlg::slotPatternEntry(const char* text)
{
    // BEGIN
    if (strlen(text) == 0)
    {
        // No pattern
        m_patFileEdit->setEnabled(true);
        m_patFileBtn->setEnabled(true);
    }   // end if
    else
    {
        // They are entering a pattern
        m_patFileEdit->setEnabled(false);
        m_patFileBtn->setEnabled(false);
    }   // end else

    return;

}   // end KGrepSearchDlg::slotPatternEntry


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotPatternFileBrowse
//
//  Originated    : 17-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Slot for the QButton's clicked signal.  Opens a
//                  file browse dialog.
//
//  Parameters    : none
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepSearchDlg::slotPatternFileBrowse()
{
    // Local variables
    QString rStr;


    // BEGIN
    rStr = KFileDialog::getOpenFileName("/", 0, this, "pattern file browse");

    if (rStr.length() != 0)
    {
        m_patFileEdit->setText(rStr);
    }   // end if

    return;

}   // end KGrepSearchDlg::slotPatternFileBrowse


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotPatternFileEntry
//
//  Originated    : 17-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Slot for the QLineEdit's textChanged signal.  Sets
//                  up mutual exclusion between pattern and pattern
//                  file entry.
//
//  Parameters    : text - The text that is contained in the edit field
//                         after the user's modifications.
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepSearchDlg::slotPatternFileEntry(const char* text)
{
    // BEGIN
    if (strlen(text) == 0)
    {
        // No pattern file
        m_patEdit->setEnabled(true);
    }   // end if
    else
    {
        // They are entering a pattern file
        m_patEdit->setEnabled(false);
    }   // end else

    return;

}   // end KGrepSearchDlg::slotPatternFileEntry


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotCancel
//
//  Originated    : 7-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : The function handles the event generated when the
//                  user selects the "Cancel" button on the dialog.
//                  Since this is a modeless window, just hide it.
//
//  Parameters    : none
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepSearchDlg::slotCancel()
{
    // BEGIN
    hide();

    return;

}   // end KGrepSearchDlg::slotCancel


////////////////////////////////////////////////////////////////////////
//
//  Function      : slotOK
//
//  Originated    : 7-Sept-99  - Keith Brown (kbrown@logikos.com)
//
//  Abstract      : Handles the event generated when the user clicks the
//                  "OK" button.  We make sure all the necessary fields
//                  are filled out then build the arg string and signal
//                  that we're ready to rock.
//
//  Parameters    : none
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
void KGrepSearchDlg::slotOK()
{
    // BEGIN
    m_argStr  = " --line-number ";                       // we always want line numbers
    m_argStr += " --with-filename ";                     // we always want file names

    if (!m_caseSenChkBox->isChecked())
    {
        // Not case sensitive
        m_argStr += " --ignore-case ";
    }   // end if

    if (m_linesWOMatchChkBox->isChecked())
    {
        // Invert matching, select lines that don't match
        m_argStr += " --revert-match ";
    }   // end if

    if (m_reqWholeWordChkBox->isChecked())
    {
        // Require whole word to match
        m_argStr += " --word-regexp ";
    }   // end if

    if (m_reqWholeLineChkBox->isChecked())
    {
        // Require whole line to match
        m_argStr += " --line-regexp ";
    }   // end if

    if (m_binDataChkBox->isChecked())
    {
        // Don't supress binary data
        m_argStr += " --text ";
    }   // end if

    if (strlen(m_patEdit->text()) == 0)
    {
        if (strlen(m_patFileEdit->text()) == 0)
        {
            KMsgBox msg(0,                     // no parent
                        i18n("Need Pattern"),  // caption (Window title)
                        i18n("Yo yo yo.  How you 'spect me\nto search without a pattern?"),
                        KMsgBox::INFORMATION,  // msg box type
                        i18n("OK")             // button
                        );
            msg.show();

            return;
        }   // end if
        else
        {
            m_argStr += " --file=";
            m_argStr += m_patFileEdit->text();
            m_argStr += " ";
        }   // end else
    }   // end if
    else
    {
        m_argStr += " --regexp=";
        m_argStr += m_patEdit->text();
        m_argStr += " ";
    }   // end else

    if (strlen(m_fileEdit->text()) == 0)
    {
        if (strlen(m_dirEdit->text()) == 0)
        {
            KMsgBox msg(0,                      // no parent
                        i18n("Need Location"),  // caption (Window title)
                        i18n("Come on Einstein. You know I need\nto know where to look for your\nprecious little pattern at."),
                        KMsgBox::INFORMATION,   // msg box type
                        i18n("OK")              // button
                        );
            msg.show();

            return;
        }   // end if
        else
        {
            if (m_recurseDirChkBox->isChecked())
            {
                m_argStr += " --recursive ";
                m_argStr += m_dirEdit->text();
                m_argStr += " ";
            }   // end if
            else
            {
                QString dir = m_dirEdit->text();
                int index = dir.findRev('/');

                if (index == (int)(dir.length() - 1))
                {
                    dir.truncate(index);
                }   // end if

                m_argStr += " ";
                m_argStr += dir;
                m_argStr += "/* ";
            }   // end else
        }   // end else
    }   // end if
    else
    {
        m_argStr += " ";
        m_argStr += m_fileEdit->text();
        m_argStr += " ";
    }   // end else

    // Signal that we got an OK (and everything is good to go).
    emit okSelected(m_argStr);

    hide();

    return;

}   // end KGrepSearchDlg::slotOK


//  end file kgrepsearchdlg.cc
