/**
* @short Option dialog class.
*
* KGrepOptionDlg provides all the code for the dialog where the user
* enters optional information such as their external editor, etc...
*
* @author Keith Brown <kbrown@logikos.com>
**/

////////////////////////////////////////////////////////////////////////
//
//  Originated by Logikos, Inc.  http://www.logikos.com
//
//  Class Name  : KGrepOptionDlg
//
//  File Name   : kgrepoptiondlg.h
//
//  Originated  : 20-Sept-99  -  Keith Brown (kbrown@logikos.com)
//
//  Abstract    : Search dialog.  See notes above.
//
//  Compiler    : egcs-1.1.2, qt 1.44, KDE 1.1.1
//
//  Revisions   :
//
////////////////////////////////////////////////////////////////////////
#ifndef KGREPOPTIONDLG_H
#define KGREPOPTIONDLG_H

// Compiler includes
#include <kapp.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qlist.h>
#include <qstring.h>
#include <qdialog.h>

// Project includes

// Types and constants

// Forward declarations


class Editor
{
    public:
        Editor(const char* ed=0, const char* arg=0, bool x=true) { n = ed; c = arg; isXapp = x; }
        const char* name() const                    { return n; }
        void        name(const char* e)             { n = e; }
        const char* cla()  const                    { return c; }
        void        cla(const char* arg)            { c = arg; }
        bool        xapp() const                    { return isXapp; }
        void        xapp(bool b)                    { isXapp = b; }

    private:
        QString c;                // editor's line-number command-line argument
        bool    isXapp;           // flag indicating if the editor is X based or terminal based
        QString n;                // editor name
};



class KGrepOptionDlg : public QDialog
{
    // Meta-object compiler thingy
    Q_OBJECT

    // Attributes
    protected:
        Editor        m_extEditor;             // The selected external editor w/info
        QComboBox*    m_editorCombo;           // Combo box for external editor selection
        QList<Editor> m_editorList;            // List of external editors to use
        QLineEdit*    m_lineNumSpecEdit;       // Line number arg specifier edit
        QCheckBox*    m_xAppChkBox;            // Check box indicating X or terminal app


    // Methods
    public:
        /** Constructor. */
        KGrepOptionDlg(QWidget* parent=0, const char* name=0, bool modal=true);

        /** Destructor. */
        ~KGrepOptionDlg();

        /** Returns info on the selected external editor. */
        const Editor* getEditorInfo();

    public slots:
        /** Slot for cancel button click. */
        void slotCancel();

        /** Slot to write protected member when new editor selected. */
        void slotEditorSelected(const char*);

        /** Slot to write protected member when new line number CLA is entered. */
        void slotLineNumCLAChanged(const char*);

        /** Slot for OK button click. */
        void slotOK();

        /** Slot for X app checkbox click. */
        void slotXAppChkBoxClicked();

    private:
        void doLayout(QWidget* parent);

};  // end class KGrepOptionDlg


// Inline function definitions


#endif // KGREPOPTIONDLG_H

// end file kgrepoptiondlg.h
