/***************************************************************************
               mapcalc.h  -  functions for calc. mapprojections
                             -------------------
    begin                : 26. July 1999
    copyright            : (C) 1999 by Heiner Lamprecht
    email                : heiner@kijumfo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef MAPCALC_H
#define MAPCALC_H

/**
  * Converts the longitute or latitute into the internal format
  * suitable for the Location-class. "degree" is a string in the
  * format: [g]gg.mm'ss"X where g,m,s are any digits from 0 to 9
  * and X is one of N, S, E, W.
  */
long degreeToNum(const char* degree);

/** Convert internal representation to radians. */
double numToRad(long internal);

/** Convert radians into internal data. */
long radToNum(double radial);

/** Returns the x-coordinate for the Lambert-projection */
double calc_X_Lambert(double latitude, double longitude,
                      double v1, double v2);

/** Returns the y-coordinate for the Lambert-projection */
double calc_Y_Lambert(double latitude, double longitude,
                      double v1, double v2);

/** Returns the x-coordinates for the Mercator-projection. */
double calc_X_Mercator(double latitude, double longitude);

/** Returns the y-coordinates for the Mercator-projection. */
double calc_Y_Mercator(double latitude, double longitude);

/** Calculates the geographical position of a given point in the
  * map. The position is stored in "lat" and "lon" in the internal
  * format. */
long map2LambertLat(double x, double y, double v1, double v2);

long map2LambertLon(double x, double y, double v1, double v2);

#endif