/***************************************************************************
                           KFLogview.cpp  -  description
                             -------------------
    begin                : Sun Jun  6 11:42:22 CEST 1999

    copyright            : (C) 1999 by Heiner Lamprecht
    email                : heiner@kijumfo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include <string>

#include <kbutton.h>
#include <kcombo.h>
#include <kintegerline.h>
#include <kmsgbox.h>
#include <krestrictedline.h>
#include <qcheckbox.h>
#include <qfileinfo.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qtextstream.h>

#include <kflog.h>
#include <kflogview.h>
#include <mapcalc.h>
#include <mapobject.h>
#include <tablet.h>

#define ENTRY(parent, text) new QListViewItem(parent,"",i18n(text));

void KFLogView::showMapFrame()
{
  tabView->hide();
  mapView->show();
}

void KFLogView::showTabFrame()
{
  mapView->hide();
  tabView->show();
}

QFrame* KFLogView::getMapFrame()
{
  return mapFrame;
}

QFrame* KFLogView::getMapView()
{
  return mapView;
}

QFrame* KFLogView::getTabView()
{
  return mapView;
}

void KFLogView::selectMapObject(QListViewItem* item)
{
  bool abkState    = false;
  bool elevState   = false;
  bool elevTState  = false;
  bool freqState   = false;
  bool gliderState = false;
  bool heliState   = false;
  bool lightState  = false;
  bool runwayState = false;
  bool uppState    = false;
  bool vdfState    = false;
  bool pointList   = false;

  /////////////////////////////////////////////////////////////////////
  //                                                                 //
  // die Landebahnen fehlen noch komplett !!!                        //
  //                                                                 //
  /////////////////////////////////////////////////////////////////////

  // NOTE: pointState is used so often, that we enable it here
  bool pointState  = true;

  if(item->depth() == 1) {
    string textString = item->text(1);

    typLabel->setText(item->text(1));

    if(textString == i18n("International Airport")) {
      abkState    = true;
      elevState   = true;
      freqState   = true;
      runwayState = true;
      vdfState    = true;
      type        = "int-airport";
    } else if(textString == i18n("Airport, Airfield IFR")) {
      abkState    = true;
      elevState   = true;
      freqState   = true;
      runwayState = true;
      vdfState    = true;
      type        = "airport";
    } else if(textString == i18n("Military Aerodrome")) {
      abkState    = true;
      elevState   = true;
      freqState   = true;
      runwayState = true;
      vdfState    = true;
      type        = "mil-air";
    } else if(textString == i18n("Airfield (civil/military)")) {
      abkState    = true;
      elevState   = true;
      freqState   = true;
      runwayState = true;
      vdfState    = true;
      type        = "civ-mil-air";
    } else if(textString == i18n("Airfield")) {
      abkState    = true;
      elevState   = true;
      freqState   = true;
      runwayState = true;
      vdfState    = true;
      type        = "airfield";
    } else if(textString == i18n("Airfield (closed)")) {
      type        = "airfield_closed";
    } else if(textString == i18n("Heliport")) {
      elevState   = true;
      freqState   = true;
      heliState   = true;
      type        = "heliport";
    } else if(textString == i18n("Glider site")) {
      elevState   = true;
      freqState   = true;
      gliderState = true;
      runwayState = true;
      type        = "glider";
    } else if(textString == i18n("Ultra light flying")) {
      type        = "ulf";
    } else if(textString == i18n("Hang glider site")) {
      type        = "hang-glider";
    } else if(textString == i18n("Parachute jumping site")) {
      type        = "parjump";
    } else if(textString == i18n("Free ballon site")) {
      type        = "ballon";
    } else if(textString == i18n("Qutlanding Field")) {
      elevState   = true;
      type        = "outlanding";
    } else if(textString == i18n("Aerodrome beacon light")) {
      type        = "beacon";
    } else if(textString == i18n("VOR")) {
      abkState    = true;
      freqState   = true;
      type        = "vor";
    } else if(textString == i18n("VOR / DME")) {
      abkState    = true;
      freqState   = true;
      type        = "vordme";
    } else if(textString == i18n("VOR-TACAN")) {
      abkState    = true;
      freqState   = true;
      type        = "vortac";
    } else if(textString == i18n("NDB")) {
      abkState    = true;
      freqState   = true;
      type        = "ndb";
    } else if(textString == i18n("Airspace C")) {
      elevState   = true;
      elevTState  = true;
      pointList   = true;
      pointState  = false;
      uppState    = true;
      type        = "airsp-c";
    } else if(textString == i18n("Airspace D")) {
      elevState   = true;
      elevTState  = true;
      pointList   = true;
      pointState  = false;
      uppState    = true;
      type        = "airsp-d";
    } else if(textString == i18n("Control Zone Airspace D")) {
      elevState   = true;
      elevTState  = true;
      pointList   = true;
      pointState  = false;
      uppState    = true;
      type        = "control-airsp-d";
    } else if((textString == i18n("Airspace E (1700ft)")) ||
              (textString == i18n("Airspace E (1000ft)"))) {
      elevState   = true;
      elevTState  = true;
      pointList   = true;
      pointState  = false;
      type        = "airsp-e";
    } else if(textString == i18n("Airspace F (HX)")) {
      elevState   = true;
      elevTState  = true;
      pointList   = true;
      pointState  = false;
      uppState    = true;
      type        = "airsp-f";
    } else if(textString == i18n("Restricted Area")) {
      elevState   = true;
      elevTState  = true;
      pointList   = true;
      pointState  = false;
      uppState    = true;
      type        = "restricted";
    } else if(textString == i18n("Danger Area")) {
      elevState   = true;
      elevTState  = true;
      pointList   = true;
      pointState  = false;
      uppState    = true;
      type        = "danger";
    } else if(textString == i18n("250ft low flight area")) {
      pointList   = true;
      pointState  = false;
      type        = "lowflight";
    } else if(textString == i18n("Flight information service")) {
      type        = "fis";
    } else if(textString == i18n("Isogonic lines")) {
      pointList   = true;
      pointState  = false;
      type        = "isogonic";
    } else if(textString == i18n("Obstacle")) {
      type        = "obstacle";
    } else if(textString == i18n("Obstaclegroup")) {
      type        = "obstaclegroup";
    } else if(textString == i18n("Obstacle (> 1000ft)")) {
      type        = "bigobstacle";
    } else if(textString == i18n("Obstaclegroup (> 1000ft)")) {
      type        = "bigobstaclegroup";
    } else if(textString == i18n("Bird / Nature Reserve")) {
      type        = "birdreserve";
    } else if(textString == i18n("Compulsary reporting point")) {
      type        = "compreport";
    } else if(textString == i18n("City")) {
      pointList   = true;
      type        = "city";
    } else if(textString == i18n("Village")) {
      type        = "village";
    } else if(textString == i18n("Oiltank")) {
      type        = "oiltank";
    } else if(textString == i18n("Oilfield")) {
      type        = "oilfield";
    } else if(textString == i18n("Quarry")) {
      pointList   = true;
      type        = "quarry";
    } else if(textString == i18n("Mine")) {
      type        = "mine";
    } else if(textString == i18n("Factory")) {
      type        = "Factory";
    } else if(textString == i18n("Monument")) {
      type        = "monument";
    } else if(textString == i18n("Castle")) {
      type        = "castle";
    } else if(textString == i18n("Fort")) {
      type        = "fort";
    } else if(textString == i18n("Ruin")) {
      type        = "ruin";
    } else if(textString == i18n("Monastry")) {
      type        = "monastry";
    } else if(textString == i18n("Church")) {
      type        = "church";
    } else if(textString == i18n("Lighthouse")) {
      type        = "lighthouse";
    } else if(textString == i18n("Lookout tower / TV tower")) {
      type        = "tower";
    } else if(textString == i18n("Dual Highway")) {
      pointState  = false;
      type        = "highway";
    } else if(textString == i18n("Primary Road")) {
      type        = "primroad";
    } else if(textString == i18n("Secondary Road")) {
      type        = "secroad";
    } else if(textString == i18n("Dual-Highway entry")) {
      type        = "highwayentry";
    } else if(textString == i18n("Roadbridge")) {
      type        = "roadbridge";
    } else if(textString == i18n("Road tunnel")) {
      type        = "roadtunnel";
    } else if(textString == i18n("Railway (single track)")) {
      type        = "smallail";
    } else if(textString == i18n("Railway (multiple track)")) {
      type        = "bigrail";
    } else if(textString == i18n("Station")) {
      type        = "station";
    } else if(textString == i18n("Railwaybridge")) {
      type        = "railbridge";
    } else if(textString == i18n("Railwaytunnel")) {
      type        = "railtunnel";
    } else if(textString == i18n("Aerial Railway")) {
      type        = "aeriealrail";
    } else if(textString == i18n("Shore line")) {
      pointList   = true;
      pointState  = false;
      type        = "shore";
    } else if(textString == i18n("Lake")) {
      pointList   = true;
      type        = "lake";
    } else if(textString == i18n("River")) {
      pointList   = true;
      pointState  = false;
      type        = "river";
    } else if(textString == i18n("Canal")) {
      pointList   = true;
      pointState  = false;
      type        = "canal";
    } else if(textString == i18n("Damm / Barrage")) {
      type        = "damm";
    } else if(textString == i18n("Lock")) {
      type        = "lock";
    } else if(textString == i18n("Dike")) {
      pointList   = true;
      pointState  = false;
      type        = "dike";
    } else if(textString == i18n("Spot elevation")) {
      type        = "spot";
    } else if(textString == i18n("Mountain pass")) {
      type        = "pass";
    } else if(textString == i18n("Glacier and ice caps")) {
      type        = "glacier";
    }
    // mu noch erweitert werden !!!
  } else {
    typLabel->setText("");
  }

  abkE->setEnabled(abkState);
  addB->setEnabled(runwayState);
  delB->setEnabled(runwayState);
  dirE->setEnabled(runwayState);
  elevE->setEnabled(elevState);
  elevT->setEnabled(elevTState);
  freqE->setEnabled(freqState);
  gliderT->setEnabled(gliderState);
  heliT->setEnabled(heliState);
  lightE->setEnabled(lightState);
  pointE1->setEnabled(pointState);
  pointE2->setEnabled(pointState);
  runwE->setEnabled(runwayState);
  runwtE->setEnabled(runwayState);
  uppE->setEnabled(uppState);
  vdfE->setEnabled(vdfState);

  abkE->setText("");
  dirE->setText("");
  elevE->setText("");
  freqE->setText("");
  nameE->setText("");
  pointE1->setText("");
  pointE2->setText("");
  runwE->setText("");
  uppE->setText("");

  elevT->setCurrentItem(0);
  gliderT->setCurrentItem(0);
  heliT->setCurrentItem(0);
  runwtE->setCurrentItem(0);

  vdfE->setChecked(false);
  lightE->setChecked(false);
}

void KFLogView::startInput()
{
  //
  // is a object-type selected?
  if(type == NULL) return;

  //
  // must we have one single point?
  bool onlyOne = false;
  if(pointE1->isEnabled() && !strlen(pointE1->text())
                          && !strlen(pointE2->text())) {
    onlyOne = true;
  } else {
    //
    // are all other data given?
    QString missingFields;
    bool error = false;
    // Name
    if(nameE->isEnabled() && !strlen(nameE->text())) {
      error = true;
      missingFields += "  \"";
      missingFields += i18n("Name");
      missingFields += "\"";
    }
    // Abbreviation
    if(abkE->isEnabled()  && !strlen(abkE->text())) {
      error = true;
      missingFields += "  \"";
      missingFields += i18n("Abbreviation");
      missingFields += "\"";
    }
    // Elevation
    if(elevE->isEnabled() && !strlen(elevE->text())) {
      error = true;
      missingFields += "  \"";
      missingFields += i18n("Elev.");
      missingFields += "\"";
    }
    // Frequency
    if(freqE->isEnabled() && !strlen(freqE->text())) {
      error = true;
      missingFields += "  \"";
      missingFields += i18n("Frequency");
      missingFields += "\"";
    }
    // Upper Limit
    if(uppE->isEnabled()  && !strlen(uppE->text())) {
      error = true;
      missingFields += "  \"";
      missingFields += i18n("Upper Limit");
      missingFields += "\"";
    }
    if(error) {
      QString errorMsg = i18n("The following fields are empty!\nPlease \
insert the missing data first.\n\n");
      errorMsg += missingFields;
      KMsgBox* errorBox = new KMsgBox(parent,i18n("Missing Fields"),
          errorMsg,4,i18n("OK"));
      errorBox->exec();
      return;
    }
  }

  TabletDialog* tab = new TabletDialog(parent,onlyOne);

  int length = tab->getListLength();

  if(!length) {
    delete tab;
    return;
  }

  latitude = new long[length];
  longitude = new long[length];

  tab->getPointList(latitude, longitude);
  if(onlyOne) {
    // we have only the location, so we can set this into the widget
    QString text;
    text.sprintf("%d", latitude[0]);
    pointE1->setText(text);
    text.sprintf("%d", longitude[0]);
    pointE2->setText(text);
    // If we have one of these object, return. The border is missing.
    if((type == "int-airport") || (type == "city") || (type == "lake"))
      return;
  }

  // creating a mapobject
  MapObject* mapObject = new MapObject(type, nameE->text(), length);

  QString fileName;

  KConfig *config = kapp->getConfig();

  config->setGroup("General");
  if(config->hasKey("MapFile")) {
    fileName = config->readEntry("MapFile");
  } else {
    fileName = kapp->kde_datadir();
    fileName += "/kflog/map.wld";
  }

//  QFile mapFile(fileName);
  QFile mapFile("/tmp/kflog.out");
  if(!mapFile.open(IO_ReadWrite)) {
    cout << "darfnich\n";
    KMsgBox* errorBox = new KMsgBox(parent,i18n("Error"),
        i18n("Cannot access the mapfile!"),4,i18n("OK"));
    errorBox->exec();
    return;
  }
  mapFile.at(mapFile.size());
  QTextStream mapOut(&mapFile);

  // setting the needed data of the object and appending it to the file
  if(!mapFile.exists()) {
    cout << "jibbetnich\n";
//    KMsgBox* errorBox = new KMsgBox(parent,i18n("Error"),
//        i18n("Cannot access the mapfile!"),4,i18n("OK"));
//    errorBox->exec();
//    return;
  }

  if(!mapFile.size()) {
    cout << "leer\n" << fileName << "\n ende" << endl;
    mapOut << "# KFLog-Map-File\n";
  }

  mapOut << "[NEW ENTRY]\n"
         << "TYPE=" << type << endl
         << "NAME=" << nameE->text() << endl;

  if(pointE1->isEnabled()) {
    mapObject->setAt(degreeToNum(pointE1->text()),
                     degreeToNum(pointE2->text()));
    mapOut << "AT=" << degreeToNum(pointE1->text())
           << " "   << degreeToNum(pointE2->text()) << endl;
  }
  if(abkE->isEnabled()) {
    mapObject->setAlias(abkE->text());
    mapOut << "Alias=" << abkE->text() << endl;
  }
  if(elevE->isEnabled()) {
    mapObject->setElev(elevE->text(), elevT->currentItem());
    mapOut << "ELEV=" << elevE->text() << "/"
           << elevT->currentItem() << endl;
  }
  if(uppE->isEnabled()) {
//    mapObject->setUpperLimit(uppE->text()); // <<<<<<<<<<<<<<<<<<<<<<<<
    mapOut << "ULIMIT=" << uppE->text() << endl;
  }
  if(freqE->isEnabled()) {
    mapObject->setFrequency(freqE->text(), vdfE->isChecked());
    mapOut << "FREQUENCY=" << freqE->text() << "/"
           << vdfE->isChecked() << endl;
  }
  if(lightE->isEnabled()) {
//    mapObject->setLight(lightE->isChecked()); // <<<<<<<<<<<<<<<<<<<<<<
    mapOut << "LIGHT=" << lightE->isChecked() << endl;
  }
  if(heliT->isEnabled()) {
//    mapObject->setHeliType(heliT->currentItem()); // <<<<<<<<<<<<<<<<<<
    mapOut << "HELITYPE=" << heliT->currentItem() << endl;
  }
  if(gliderT->isEnabled()) {
//    mapObject->setGliderType(gliderT->currentItem()); // <<<<<<<<<<<<<<
    mapOut << "GLIDERTYPE=" << gliderT->currentItem() << endl;
  }

  if(!onlyOne) {
    mapObject->setLocList(latitude, longitude);
    mapOut << latitude[0] << " " << longitude[0] << endl;
    long latOld = latitude[0];
    long lonOld = longitude[0];
    long latNew, lonNew;
    for(int loop = 0; loop < length; loop++) {
      latNew = latitude[loop];
      lonNew = longitude[loop];
      if(sqrt((latNew - latOld) * (latNew - latOld) +
              (lonNew - lonOld) * (lonNew - lonOld)) >= 1500) {
        mapOut << latitude[loop] << " " << longitude[loop] << endl;
        latOld = latitude[loop];
        lonOld = longitude[loop];
      }
    }
  }

  // Object is complete
  mapObjectList->addObject(mapObject);
  mapOut << "[END]\n";
  mapFile.close();

  /////////////////////////////////////////////////////////////////////
  //
  // testweise mal alles ausgeben ...
    cout << "Typ:   " << type << endl;
  if(nameE->isEnabled()) {
    cout << "Name:  " << nameE->text() << endl;
  }
  if(abkE->isEnabled()) {
    cout << "Abk:   " << abkE->text() << endl;
  }
  if(pointE1->isEnabled()) {
    cout << "Loc:   " << pointE1->text() << " / " << pointE2->text() << endl;
  }
  if(elevE->isEnabled()) {
    cout << "Hhe:  " << elevE->text();
  }
  if(elevT->isEnabled()) {
    cout << " MSN: " << elevT->currentItem();
  }
  cout << endl;
  if(uppE->isEnabled()) {
    cout << "Oben:  " << uppE->text() << endl;
  }
  if(freqE->isEnabled()) {
    cout << "Freq:  " << freqE->text() << endl;
  }
  if(vdfE->isEnabled()) {
    cout << "VDF:  " << vdfE->isChecked() << endl;
  }
  if(lightE->isEnabled()) {
    cout << "Licht: " << lightE->isChecked() << endl;
  }
  if(heliT->isEnabled()) {
    cout << "Heli:  " << heliT->currentItem() << endl;
  }
  if(gliderT->isEnabled()) {
    cout << "Segel: " << gliderT->currentItem() << endl;
  }
  //
  /////////////////////////////////////////////////////////////////////

  tab->~TabletDialog();
}

void KFLogView::setMOList(MapObjectList* newList)
{
  mapObjectList = newList;
}

KFLogView::KFLogView(QWidget* parent)
  : QWidget(parent)
{
  mapView = new QFrame(this);
  QHBoxLayout* mapViewLayout = new QHBoxLayout(this);

  // create a frame for the map
  mapFrame = new QFrame(mapView);

  ///////////////////
  // welches Relief ???
  //    mapFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  mapFrame->setFrameStyle(QFrame::Box | QFrame::Raised);
  //
  ///////////////////
  mapFrame->setLineWidth(1);
  mapFrame->setMidLineWidth(1);

  // create frames for the additional data
  QFrame* dataTopFrame = new QFrame(mapView);
  dataTopFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  dataTopFrame->setLineWidth(0);
  QFrame* dataBotFrame = new QFrame(mapView);
  dataBotFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  dataBotFrame->setLineWidth(1);

  // adding the contents of the data frames
  QLabel* label1 = new QLabel("Datum:", dataTopFrame);
  QLabel* label2 = new QLabel("Pilot:", dataTopFrame);
  QLabel* label3 = new QLabel("Flugzeug:", dataTopFrame);
  QLabel* label4 = new QLabel("Dauer:", dataTopFrame);
  QLabel* label5 = new QLabel("Strecke:", dataTopFrame);

  QFont ttbf("Courier");
  QFont bold;
  bold.setBold(true);

  QLabel* nummer1 = new QLabel(dataTopFrame);
  nummer1->setFont(ttbf);

  QLabel* nummer2 = new QLabel(dataTopFrame);
  nummer2->setFont(ttbf);

  QLabel* nummer3 = new QLabel(dataTopFrame);
  nummer3->setFont(ttbf);

  QLabel* nummer4 = new QLabel(dataTopFrame);
  nummer4->setFont(ttbf);

  QLabel* nummer5 = new QLabel(dataTopFrame);
  nummer5->setFont(ttbf);

  nummer1->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  nummer2->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  nummer3->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  nummer4->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  nummer5->setFrameStyle(QFrame::Panel | QFrame::Sunken);

  nummer1->setText("21.06.99");
  nummer2->setText("Florian Ehinger");
  nummer3->setText("D-FLEH");
  nummer4->setText("2:25:00");
  nummer5->setText("130 km");

  QGridLayout* topLayout = new QGridLayout(dataTopFrame,10,2,5,0);
  topLayout->addWidget(label1,0,0);
  topLayout->addWidget(label2,1,0);
  topLayout->addWidget(label3,2,0);
  topLayout->addWidget(label4,3,0);
  topLayout->addWidget(label5,4,0);
  topLayout->addWidget(nummer1,0,1);
  topLayout->addWidget(nummer2,1,1);
  topLayout->addWidget(nummer3,2,1);
  topLayout->addWidget(nummer4,3,1);
  topLayout->addWidget(nummer5,4,1);

  // creating the layout
  QGridLayout* mapLayout = new QGridLayout(this,3,3);
  mapLayout->addMultiCellWidget(mapFrame,0,2,0,0);

  mapLayout->addWidget(dataTopFrame,0,2);
  mapLayout->addWidget(dataBotFrame,2,2);

  mapLayout->setColStretch(0,2);
  mapLayout->setColStretch(1,0);
  mapLayout->setColStretch(2,1);
  mapLayout->addColSpacing(1,8);

  mapLayout->setRowStretch(0,2);
  mapLayout->setRowStretch(1,0);
  mapLayout->setRowStretch(2,1);
  mapLayout->addRowSpacing(1,5);

  mapLayout->activate();

  mapViewLayout->addWidget(mapView);
  mapViewLayout->activate();
        
  ///////////////////////////////////////////////////////////////////
  //
  //
  //
  ///////////////////////////////////////////////////////////////////
  tabView = new QFrame(this);
  QHBoxLayout* tabViewLayout = new QHBoxLayout(this);

  // creating the layout
  QGridLayout* tabLayout = new QGridLayout(this,27,17,5,0);
        
  // creating the widgets for the entry
  QListView* list = new QListView(tabView);
  list->setMinimumWidth(220);
  list->addColumn("",45);
  list->addColumn(i18n("Map-Object"),205);
  list->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  list->setAllColumnsShowFocus(true);
  list->setRootIsDecorated(true);
  //    QGroupBox* box1 = new QGroupBox(i18n("Object-Data:"),tabView);
  //    QGroupBox* box2 = new QGroupBox(i18n("Runway-Data:"),tabView);
  tabLayout->addMultiCellWidget(list,0,26,0,0);
  // Sollen die wirklich verwendet werden???
  //    tabLayout->addMultiCellWidget(box1,0,12,2,16);
  //    tabLayout->addMultiCellWidget(box2,14,22,2,16);
        
  typLabel = new QLabel(tabView);
  typLabel->setText("Typ des Karten-Objektes");
  typLabel->setFont(bold);
  tabLayout->addMultiCellWidget(typLabel,1,1,3,8);

  QLabel* nameL = new QLabel(tabView);
  nameL->setText(i18n("Name:"));
  nameE = new QLineEdit(tabView);
  nameE->setFont(ttbf);
  nameE->setMaximumHeight(30);
  nameE->setMinimumHeight(25);
  abkE = new KRestrictedLine(tabView);
  abkE->setValidChars("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
  abkE->setFont(ttbf);
  abkE->setMinimumWidth(50);
  abkE->setMaximumHeight(30);
  tabLayout->addWidget(nameL,3,3);
  tabLayout->addMultiCellWidget(nameE,3,3,5,13);
  tabLayout->addWidget(abkE,3,15);

  QLabel* pointL = new QLabel(tabView);
  pointL->setText(i18n("Location:"));
  pointL->setMinimumWidth(80);
  pointE1 = new KRestrictedLine(tabView);
  pointE1->setValidChars("1234567890.',NSWE");
  pointE1->setFont(ttbf);
  pointE1->setMinimumWidth(130);
  pointE1->setMaximumHeight(30);
  pointE1->setMinimumHeight(25);
  pointE2 = new KRestrictedLine(tabView);
  pointE2->setValidChars("1234567890.',NSWE");
  pointE2->setFont(ttbf);
  pointE2->setMinimumWidth(130);
  pointE2->setMinimumHeight(25);
  //////////////////////////////////////////////////////////////////////
  // Welcher Knopf ???
  //    QPushButton* pointB = new QPushButton(tabView);
  KButton* pointB = new KButton(tabView);
  pointB->setPixmap(Icon("tablet.xpm"));
  pointB->setMinimumWidth(60);
  pointB->setMinimumHeight(60);
  pointB->setMaximumHeight(60);
  tabLayout->addWidget(pointL,5,3);
  tabLayout->addMultiCellWidget(pointE1,5,5,5,7);
  tabLayout->addMultiCellWidget(pointE2,5,5,9,13);
  tabLayout->addMultiCellWidget(pointB,5,7,15,15);

  QLabel* elevL = new QLabel(tabView);
  elevL->setText(i18n("Elev."));
  elevE = new KIntegerLine(tabView);
  elevE->setFont(ttbf);
  elevE->setMinimumWidth(50);
  elevE->setMaximumHeight(30);
  elevE->setMinimumHeight(25);
  elevT = new KCombo(tabView);
  elevT->insertItem(i18n("MSL"));
  elevT->insertItem(i18n("GND"));
  elevT->setMinimumWidth(60);
  QLabel* uppL = new QLabel(tabView);
  uppL->setText(i18n("Upper Limit:"));
  uppL->setAlignment(AlignRight);
  uppE = new KIntegerLine(tabView);
  uppE->setFont(ttbf);
  uppE->setMinimumWidth(70);
  uppE->setMinimumHeight(25);
  tabLayout->addWidget(elevL,7,3);
  tabLayout->addWidget(elevE,7,5);
  tabLayout->addWidget(elevT,7,7);
  tabLayout->addMultiCellWidget(uppL,7,7,9,11);
  tabLayout->addWidget(uppE,7,13);

  QLabel* freqL = new QLabel(tabView);
  freqL->setText(i18n("Frequency:"));
  freqE = new KRestrictedLine(tabView);
  freqE->setValidChars("1234567890,.");
  freqE->setFont(ttbf);
  freqE->setMinimumWidth(80);
  freqE->setMinimumHeight(25);
  freqE->setMaximumHeight(30);
  vdfE = new QCheckBox(i18n("VDF"),tabView);
  vdfE->setMinimumWidth(50);
  QLabel* obstL = new QLabel(tabView);
  obstL->setText(i18n("Obstacle/-group lighted:"));
  obstL->setAlignment(AlignRight);
  lightE = new QCheckBox(i18n("yes"),tabView);
  lightE->setMinimumWidth(50);
  tabLayout->addWidget(freqL,9,3);
  tabLayout->addWidget(freqE,9,5);
  tabLayout->addWidget(vdfE,9,7);
  tabLayout->addMultiCellWidget(obstL,9,9,9,13);
  tabLayout->addWidget(lightE,9,15);

  QLabel* heliL = new QLabel(tabView);
  heliL->setText(i18n("Heliport:"));
  heliT = new KCombo(tabView);
  heliT->insertItem(i18n("civil"));
  heliT->insertItem(i18n("military"));
  heliT->insertItem(i18n("ambulance"));
  heliT->setMinimumHeight(25);
  heliT->setMaximumHeight(30);
  QLabel* gliderL = new QLabel(tabView);
  gliderL->setText(i18n("Glidersite:"));
  gliderL->setAlignment(AlignRight);
  gliderT = new KCombo(tabView);
  gliderT->insertItem(i18n("aero tow"));
  gliderT->insertItem(i18n("winch launching"));
  tabLayout->addWidget(heliL,11,3);
  tabLayout->addMultiCellWidget(heliT,11,11,5,7);
  tabLayout->addMultiCellWidget(gliderL,11,11,9,11);
  tabLayout->addMultiCellWidget(gliderT,11,11,13,15);

  QListView* runwList = new QListView(tabView);
  runwList->setMinimumWidth(270);
  runwList->addColumn(i18n("Nr."),35);
  runwList->addColumn(i18n("Length"),80);
  runwList->addColumn(i18n("Direction"),100);
  runwList->addColumn(i18n("Surface"),80);
  runwList->addColumn(i18n("Points"),275);
  runwList->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  runwList->setAllColumnsShowFocus(true);
  runwList->setRootIsDecorated(false);
  tabLayout->addMultiCellWidget(runwList,17,17,3,15);

  QLabel* runwL = new QLabel(tabView);
  runwL->setText(i18n("Length:"));
  runwL->setMinimumWidth(100);
  runwE = new KIntegerLine(tabView);
  runwE->setFont(ttbf);
  runwE->setMinimumHeight(25);
  runwE->setMaximumHeight(30);
  QLabel* dirL = new QLabel(tabView);
  dirL->setText(i18n("Direction:"));
  dirL->setMinimumWidth(70);
  dirE = new KIntegerLine(tabView);
  dirE->setFont(ttbf);
  dirE->setMinimumWidth(50);
  dirE->setMaximumHeight(30);
  QLabel* runwtL = new QLabel(tabView);
  runwtL->setText(i18n("Surface:"));
  runwtL->setMinimumWidth(60);
  runwtE = new QComboBox(tabView);
  runwtE->insertItem(i18n("concrete"));
  runwtE->insertItem(i18n("asphalt"));
  runwtE->insertItem(i18n("grass"));
  tabLayout->addWidget(runwL,19,3);
  tabLayout->addWidget(runwE,19,5);
  tabLayout->addWidget(dirL,19,7);
  tabLayout->addWidget(dirE,19,9);
  tabLayout->addWidget(runwtL,19,11);
  tabLayout->addMultiCellWidget(runwtE,19,19,13,15);

  addB = new QPushButton(tabView);
  addB->setText(i18n("add runway"));
  addB->setMinimumHeight(30);
  addB->setMaximumHeight(30);
  delB = new QPushButton(tabView);
  delB->setText(i18n("delete runway"));
  tabLayout->addMultiCellWidget(addB,21,21,5,7);
  tabLayout->addMultiCellWidget(delB,21,21,9,11);

  /////////////////////////////////////////////////////////////////////
  //
  // setting the layout-parameter:
  tabLayout->setColStretch(0,4);
  tabLayout->setColStretch(5,2);
  tabLayout->setColStretch(9,2);
  tabLayout->setColStretch(15,1);
  tabLayout->addColSpacing(1,20);
  tabLayout->addColSpacing(2,10);
  tabLayout->addColSpacing(4,5);
  tabLayout->addColSpacing(6,10);
  tabLayout->addColSpacing(8,10);
  tabLayout->addColSpacing(10,10);
  tabLayout->addColSpacing(12,10);
  tabLayout->addColSpacing(14,10);
  tabLayout->addColSpacing(16,10);

  tabLayout->setRowStretch(3,1);
  tabLayout->setRowStretch(5,1);
  tabLayout->setRowStretch(7,1);
  tabLayout->setRowStretch(9,1);
  tabLayout->setRowStretch(11,1);

  tabLayout->setRowStretch(17,1);
  tabLayout->addRowSpacing(0,20);
  tabLayout->addRowSpacing(1,30);
  tabLayout->addRowSpacing(2,5);
  tabLayout->addRowSpacing(4,5);
  tabLayout->addRowSpacing(6,5);
  tabLayout->addRowSpacing(8,5);
  tabLayout->addRowSpacing(10,5);
  tabLayout->addRowSpacing(12,10);
  tabLayout->addRowSpacing(13,20);
  tabLayout->addRowSpacing(14,5);
  tabLayout->addRowSpacing(15,20);
  tabLayout->addRowSpacing(16,5);
  tabLayout->addRowSpacing(18,5);
  tabLayout->addRowSpacing(20,5);
  tabLayout->addRowSpacing(22,10);
        
  tabLayout->activate();

  tabViewLayout->addWidget(tabView);
  tabViewLayout->activate();
        
  ///////////////////////////////////////////////////////////////////////
  //
  // adding the entries for map-object-list
  QListViewItem* topo = new QListViewItem(list);
  topo->setPixmap(0,Icon("mini/folder.xpm"));
  topo->setText(1,i18n("Topography"));
  ENTRY(topo,"Glaciers and ice caps");
  ENTRY(topo,"Mountain pass");
  ENTRY(topo,"Spot elevation");
  ENTRY(topo,"Dike");

  QListViewItem* waters = new QListViewItem(list);
  waters->setPixmap(0,Icon("mini/folder.xpm"));
  waters->setText(1,i18n("Hydrography"));
  ENTRY(waters,"Lock");
  ENTRY(waters,"Damm / Barrage");
  ENTRY(waters,"Canal");
  ENTRY(waters,"River");
  ENTRY(waters,"Lake");
  ENTRY(waters,"Shore line");

  QListViewItem* roads = new QListViewItem(list);
  roads->setPixmap(0,Icon("mini/folder.xpm"));
  roads->setText(1,i18n("Roads, Railways"));
  ENTRY(roads,"Aerial Railway");
  ENTRY(roads,"Railwaytunnel");
  ENTRY(roads,"Railwaybridge");
  ENTRY(roads,"Station");
  ENTRY(roads,"Railway (multipletrack)");
  ENTRY(roads,"Railway (single track)");
  ENTRY(roads,"Road tunnel");
  ENTRY(roads,"Roadbridge");
  ENTRY(roads,"Dual-Highway entry");
  ENTRY(roads,"Secondary Road");
  ENTRY(roads,"Primary Road");
  ENTRY(roads,"Dual Highway");

  QListViewItem* landscape = new QListViewItem(list);
  landscape->setPixmap(0,Icon("mini/folder.xpm"));
  landscape->setText(1,i18n("Landmarks"));
  ENTRY(landscape,"Lookout tower / TV tower");
  ENTRY(landscape,"Lighthouse");
  ENTRY(landscape,"Church");
  ENTRY(landscape,"Monastery");
  ENTRY(landscape,"Ruin");
  ENTRY(landscape,"Fort");
  ENTRY(landscape,"Castle");
  ENTRY(landscape,"Monument");
  ENTRY(landscape,"Factory");
  ENTRY(landscape,"Mine");
  ENTRY(landscape,"Quarry");
  ENTRY(landscape,"Oilfield");
  ENTRY(landscape,"Oiltank");

  QListViewItem* town = new QListViewItem(list);
  town->setPixmap(0,Icon("mini/folder.xpm"));
  town->setText(1,i18n("Built-up areas"));
  ENTRY(town,"Village");
  ENTRY(town,"City");

  QListViewItem* misc = new QListViewItem(list);
  misc->setPixmap(0,Icon("mini/folder.xpm"));
  misc->setText(1,i18n("Miscellaneous"));
  ENTRY(misc,"Compulsary reporting point");
  ENTRY(misc,"Bird / Nature Reserve");
  ENTRY(misc,"Obstaclegroup (> 1000ft)");
  ENTRY(misc,"Obstacle (> 1000ft)");
  ENTRY(misc,"Obstaclegroup");
  ENTRY(misc,"Obstacle");
  ENTRY(misc,"Isogonic lines");
  ENTRY(misc,"Flight information service");

  QListViewItem* airspace = new QListViewItem(list);
  airspace->setPixmap(0,Icon("mini/folder.xpm"));
  airspace->setText(1,i18n("Airspace Structure"));
  ENTRY(airspace,"250ft low flight area");
  ENTRY(airspace,"Danger Area");
  ENTRY(airspace,"Restricted Area");
  ENTRY(airspace,"Airspace F (HX)");
  ENTRY(airspace,"Airspace E (1000ft)");
  ENTRY(airspace,"Airspace E (1700ft)");
  ENTRY(airspace,"Control Zone Airspace D");
  ENTRY(airspace,"Airspace D");
  ENTRY(airspace,"Airspace C");

  QListViewItem* navig = new QListViewItem(list);
  navig->setPixmap(0,Icon("mini/folder.xpm"));
  navig->setText(1,i18n("Radio Navigation Facilities"));
  ENTRY(navig,"NDB");
  ENTRY(navig,"VOR-TACAN");
  ENTRY(navig,"VOR / DME");
  ENTRY(navig,"VOR");

  QListViewItem* airports = new QListViewItem(list);
  airports->setPixmap(0,Icon("mini/folder.xpm"));
  airports->setText(1,i18n("Aerodromes"));
  ENTRY(airports,"Aerodrome beacon light");
  ENTRY(airports,"Auenlandefeld");
  ENTRY(airports,"Free ballon site");
  ENTRY(airports,"Parachute jumping site");
  ENTRY(airports,"Hang glider site");
  ENTRY(airports,"Ultra light flying");
  ENTRY(airports,"Glider site");
  ENTRY(airports,"Heliport");
  ENTRY(airports,"Airfield closed");
  ENTRY(airports,"Airfield");
  ENTRY(airports,"Airfield (civil/military)");
  ENTRY(airports,"Military Aerodrome");
  ENTRY(airports,"Airport, Airfield IFR");
  ENTRY(airports,"International Airport");

  //////////////////////////////////////////////////////////////////
  // connecting some slots:
  this->connect(list, SIGNAL(doubleClicked(QListViewItem*)),
                SLOT(selectMapObject(QListViewItem*)));
  this->connect(list, SIGNAL(returnPressed(QListViewItem*)),
                SLOT(selectMapObject(QListViewItem*)));
  this->connect(list, SIGNAL(currentChanged(QListViewItem*)),
                SLOT(selectMapObject(QListViewItem*)));
  this->connect(pointB, SIGNAL(clicked()), SLOT(startInput()));

//  tabView->hide();

}

KFLogView::~KFLogView(){

}




















