/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Free V0.9.5                                              *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to virtual-dynamics@gmx.net                                    *
 *                                                                       *
 *************************************************************************/

#include "global.h"
#include "info.h"
#include "kdconfigwidget.h"
#include "kdfree_dock.h"

#include <kprocess.h>
#include <kwm.h>

KDFreeDock::~KDFreeDock(){
}

KDFreeDock::KDFreeDock(QWidget *parent, const char *name, KDConfig *cfg):QWidget(parent,name){
	config=cfg;

	timer=new QTimer(this);
	timer->start(config->update_freq*1000,false);

	menu=new QPopupMenu;
	CHECK_PTR(menu);
	menu->insertItem(klocale->translate("&Start KDFree"),this, SLOT(slot_menu_start_kdfree()),0);
	menu->insertItem(klocale->translate("&Configure"),this, SLOT(slot_menu_config()),0);
	menu->insertItem(klocale->translate("&About"),this, SLOT(slot_menu_about()),0);
	menu->insertSeparator();
	menu->insertItem(klocale->translate("&Quit KDFreeDock"),this, SLOT(slot_close()),0);

	connect(timer,SIGNAL(timeout()),SLOT(slot_updateWidget()));

	resize(500,370);
	setMinimumSize(size());

	for (int i=0;i<4;i++) dd[i]=new diskData(config->dock_mp[i],config);
	slot_updateWidget();	
}

void KDFreeDock::slot_close(){
	config->save();
	kapp->quit();
}

void KDFreeDock::slot_updateWidget(){
	for (int i=0;i<4;i++) {
		delete(dd[i]);
		dd[i]=new diskData(config->dock_mp[i],config);
	}
	repaint();
}

void KDFreeDock::paintEvent(QPaintEvent *){
	QPainter p;
	QBrush bblue;
	QBrush bred;
	QBrush bgray;

	bred.setColor(config->color_disk_free);
	bred.setStyle(SolidPattern);
	bblue.setStyle(SolidPattern);
	bblue.setColor(config->color_disk_full);
	bgray.setStyle(SolidPattern);
	bgray.setColor(config->color_disk_umounted);

	p.begin(this);
	p.setPen(black);

	p.fillRect(2, 5, 19,13,bred);
	p.drawRect(2, 5,19,4);
	p.drawRect(2, 8,19,4);
	p.drawRect(2,11,19,4);
	p.drawRect(2,14,19,4);

	for (int i=0;i<4;i++){
		if (dd[i]->ismounted){
			int s=(int)(17*dd[i]->disk_used/dd[i]->disk_capacity);
			p.fillRect(3, i*3+6, s, 2,bblue);
		}else p.fillRect(3, i*3+6, 17, 2,bgray);

	}

	p.end();
}

void KDFreeDock::mouseReleaseEvent(QMouseEvent *e){

	if (e->button()==LeftButton){
		slot_updateWidget();
	}else{
		menu->popup(QCursor::pos());		
	}

	repaint();
}

void KDFreeDock::slot_menu_about(){
	Info	*info=new Info();
	info->show();
}

void KDFreeDock::slot_menu_start_kdfree(){
	KProcess	proc_kdfree;
	proc_kdfree.setExecutable(DEFAULT_KDFREE_PROC);
	proc_kdfree.start(KProcess::DontCare,KProcess::NoCommunication);
}

void KDFreeDock::slot_menu_config(){
	KDConfigWidget	*configWidget;

	configWidget=new KDConfigWidget(0,"ConfigWidget",config);
	configWidget->show();

	connect(configWidget,SIGNAL(newConfig()),SLOT(slot_updateWidget()));
}

int main(int argc,char *argv[]){
 	KApplication 	*thisapp=new KApplication(argc,argv,"kdfree");
	KDConfig	*config;
	KDFreeDock	*main;
	int		retstat;

	config=new KDConfig();
	config->path=argv[1];
 
	main=new KDFreeDock(NULL,NULL,config); 

	thisapp->setTopWidget(main);
	thisapp->setMainWidget(main);
	KWM::setDockWindow(main->winId());

	main->show();
	retstat=thisapp->exec();
	config->save();
	delete(config);

	return retstat;
}
