#!/bin/bash

len=$(expr length $0)
len=$(expr $len - 10 )
dir=$(expr substr $0 1 $len )
dir=$(echo "$dir.")

cd $dir

ficha=$(expr substr $0 1 1)
if ( expr "$ficha" = "/" )
then
	kvt -e ./release.sh
	exit 0
fi

cd ..

clear

if !(test -f ./makefile.sub) #makefile.sub should only be found in ./source
then
	kdialog --msgbox "\"release.sh\" is stored in a wrong directory" \
		|| xmessage "\"release.sh\" is stored in a wrong directory" \
		|| dialog --msgbox "\"release.sh\" is stored in a wrong directory"

	exit 1
fi

kdialog --msgbox "Preparing your program for release (Press OK)" \
	|| xmessage "Preparing your program for release (Press OK)" \
	|| dialog --msgbox "Preparing your program for release (Press OK)"

clear

echo "CLEANING..."
make clean

echo "TRANSLATING TO C++ CODE"
make -s VK_files || ( kdialog --msgbox "Couldn't translate:\nSee terminal output for details." \
	|| xmessage "Couldn't translate:\nSee terminal output for details." \
	|| dialog --msgbox "Couldn't translate:\nSee terminal output for details."
	echo -e "\t\t\t[ PRESS ENTER TO EXIT ]"
	read
	exit 1 ) || exit 1

echo "PREPARING THE PROJECT..."
make -s data || ( kdialog --msgbox "Couldn't prepare:\nSee terminal output for details." \
		|| xmessage "Couldn't prepare:\nSee terminal output for details." \
		|| dialog --msgbox "Couldn't prepare:\nSee terminal output for details."
	exit 1 ) || exit 1


echo "STILL PREPARING THE PROJECT..."
make -s update || ( kdialog --msgbox "Couldn't prepare:\nSee terminal output for details." \
		|| xmessage "Couldn't prepare:\nSee terminal output for details." \
		|| dialog --msgbox "Couldn't prepare:\nSee terminal output for details."
	exit 1 ) || exit 1

cd ..

./configure  #without debugging flags (default)

echo "TEST-COMPILING THE PROJECT..."
make -s all || ( kdialog --msgbox "Couldn't compile:\nSee terminal output for details." \
		|| xmessage "Couldn't compile:\nSee terminal output for details." \
		|| dialog --msgbox "Couldn't compile:\nSee terminal output for details."
	exit 1 ) || exit 1


make clean
make distclean
aclocal
autoheader
autoconf
automake

lsmN=$(ls *.lsm)
prjN=$(expr substr $lsmN 1 $( expr $(expr length $lsmN) - 4 ) )

prjP=$(pwd)
tStr=""
i=$(expr length $prjP)

while !( expr "$tStr" = "/" )
do
	i=$( expr $i - 1 )
	tStr=$( expr substr $prjP $i 1 )
done

ii=$( expr $i + 1 )
prjP=$( expr substr $prjP $ii $( expr $(expr length $prjP) - $i )  )

cd ..
tar -c ./$prjP > $HOME/$prjN.tar
gzip $HOME/$prjN.tar -f

cp ./$prjP/$lsmN $HOME

msg="The following files have been generated:\n"
msg="$msg\n$HOME/$prjN.tar.gz\n$HOME/$lsmN\n"
msg="$msg\nUpload both files at ftp://upload.kde.org/kde/Incoming"
msg="$msg\nand please tell the VisKProg team about your new version at\n<de_cp@linuxstart.com>."

kdialog --msgbox "$msg" || xmessage "$msg" || dialog --msgbox "$msg"

exit 0
