/*
	newcatalog.cpp - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <kapp.h>
#include <kfiledialog.h>
#include <qstring.h>
#include <kmsgbox.h>

#include "newcatalog.h"

NewCatalog::NewCatalog(QWidget *parent, const char *name, const char *def_root_dir)
   :QDialog(parent,name,TRUE)
{
   int width1, width2, maxwidth;

   setCaption(i18n("New catalog"));

   lb_catalog_name= new QLabel(i18n("Catalog name:"), this, "lb_catalog_name");
   width1 = lb_catalog_name->fontMetrics().width(lb_catalog_name->text());

   lb_root_dir= new QLabel(i18n("Root directory:"), this, "lb_root_dir");
   width2 = lb_root_dir->fontMetrics().width(lb_root_dir->text());

   if (width1 < width2) maxwidth = width2; else maxwidth = width1;
   maxwidth += 15;
   lb_catalog_name->setGeometry(10, 10, maxwidth, 30);
   lb_root_dir    ->setGeometry(10, 40, maxwidth, 30);

   sle_catalog_name= new QLineEdit(this, "sle_catalog_name");
   sle_catalog_name->setGeometry(maxwidth+10, 10, 180, 24);

   sle_root_dir= new QLineEdit(this, "sle_root_dir");
   sle_root_dir->setText(def_root_dir);
   sle_root_dir->setGeometry(maxwidth+10, 40, 180, 24);
   
   pb_root_dir= new QPushButton("...",this);
   pb_root_dir->setGeometry(sle_root_dir->x()+sle_root_dir->width()+5, 40, 30, 24);
      
   setMinimumSize(maxwidth+230, 120);
   setMaximumSize(maxwidth+230, 120);

   pb_ok= new QPushButton(i18n("Ok"),this);
   pb_ok->setDefault(true);
   width1 = pb_ok->fontMetrics().width(pb_ok->text());

   pb_cancel= new QPushButton(i18n("Cancel"),this);
   width2 = pb_cancel->fontMetrics().width(pb_cancel->text());

   if (width1 < width2) maxwidth = width2; else maxwidth = width1;
   maxwidth += 20;
 
   pb_ok    ->setGeometry(width()/2-20-maxwidth, 80, maxwidth, 30);
   pb_cancel->setGeometry(width()/2+20,          80, maxwidth, 30);

   sle_catalog_name->setFocus();
   
   connect(pb_ok,SIGNAL(clicked()),SLOT(slotOk()));
   connect(pb_cancel,SIGNAL(clicked()),SLOT(reject()));
   connect(pb_root_dir,SIGNAL(clicked()),SLOT(slotGetRootDir()));
};

NewCatalog::~NewCatalog()
{
   delete sle_catalog_name;
   delete lb_catalog_name;
   delete sle_root_dir;
   delete lb_root_dir;
   delete pb_root_dir;
   delete pb_ok;
   delete pb_cancel;
};

void NewCatalog::slotOk()
{
	QString str=sle_catalog_name->text();
	if ((str.find('/') > -1) || (str.find('|') > -1))
	{
		KMsgBox::message(this,i18n("Message"),i18n("Invalid character in the name!"),KMsgBox::STOP);
	}
	else
	{
		if (str.length() == 0)
		{
			KMsgBox::message(this,i18n("Message"),i18n("No name specified!"),KMsgBox::STOP);
		}
		else
		{
	   	accept();
	 	}
	}
};

void NewCatalog::slotGetRootDir()
{
   QString ret;
   
   ret=KFileDialog::getDirectory(sle_root_dir->text(),this,"getdir");
   if (!ret.isEmpty())
   {
      sle_root_dir->setText(ret);
   };
};




