/***************************************************************************
                          klisttextodevice.cpp  -  description
                             -------------------                                         

    version              : 1.0                                 
    begin                : Fri Feb 26 1999                                           
    copyright            : (C) 1999 by Uwe Bhme                         
    email                : uwe@hof.baynet.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "klisttextodevice.h"

#include <string.h>

KListTextODevice::KListTextODevice(QWidget *parent, const char *name ) :
    QListBox(parent,name)
{
    setFlags( IO_Sequential );
}

KListTextODevice::~KListTextODevice()
{
}

bool KListTextODevice::open( int m )
{
    if ( isOpen() )
    {
	warning( "KListTextODevice::open: already open" );
	return FALSE;
    }
    setMode( m );
    if ( m != IO_WriteOnly )
    {
	warning( "KListTextODevice::open: can only open for writing" );
	return FALSE;
    }
    setState( IO_Open );
    setStatus( 0 );
    return TRUE;
}

void KListTextODevice::close()
{
    flush();
}

void KListTextODevice::flush()
{
    insertItem( hangover.data() );
}

int KListTextODevice::readBlock( char *p, uint s )
{
    return 0;
}

int KListTextODevice::writeBlock( const char *p, uint s )
{
    char * buffer = new char[ s + 1 ];
    memcpy( buffer, p, s );
    buffer[ s ] = 0;
    hangover += buffer;
    delete buffer;
    out();
    return s - hangover.length();
}

uint KListTextODevice::size() const
{
    return 0;
}

int KListTextODevice::getch()
{
    return 0;
}

int KListTextODevice::putch( int c )
{
    hangover += char( c );
    out();
    return c;
}

int KListTextODevice::ungetch( int )
{
    return -1;
}

/*
void KListTextODevice::out()
{
    if( !hangover.find( '\n' ) == -1 )
        return;
    char *work = new char[ hangover.length() + 1 ];
    strcpy( work, hangover.data() );
    char *start = work;
    for( char *end = strchr( start, '\n' ); end; end = strchr( start, '\n' ) )
    {
        *end = 0;
        insertItem( start );
        start = end + 1;
    }
    hangover = start;
    delete work;
}
*/

void KListTextODevice::out()
{
    for( int pos = hangover.find( '\n' ); pos != -1; pos = hangover.find( '\n' ) )
    {
        insertItem( hangover.left( pos ) );
        hangover.remove( 0, pos + 1 );
    }
}
