/***************************************************************************
                          kdddlldoc.h  -  description                              
                             -------------------                                         

    version              : 1.0                                  
    begin                : Thu Feb 25 05:55:16 CET 1999
                                           
    copyright            : (C) 1999 by Uwe Bhme                         
    email                : uwe@hof.baynet.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KDDDLLDOC_H 
#define KDDDLLDOC_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qobject.h>
#include <qfile.h>
#include <kfiledialog.h>
/** 
  * This class provides base functionality for your application document
  * such as file creation, saving and closing by serialization of a QFile
  * Object.
  */
class KDDDLLDoc : public QObject
{
  Q_OBJECT

 public:
  /** Constructor for the fileclass of the application */
  KDDDLLDoc(QObject*, const char *filename=0L);
  /** Destructor for the fileclass of the application */
  ~KDDDLLDoc();
  /** returns the value of the modified flag*/
  bool isModified() {return bModified;};
  /** deletes the current document contents */
  void deleteContents();
  /** saves the document to the current name of file.
    */
  void saveFile();
  /** saves the document asking for a filename.
    */
  void saveFileAs();

  /** saves the document as binary asking for a filename 
    */
  void saveBinaryFile();

  /** opens a preview of a binary saved dialog asking for a filename 
    */
  void previewBinaryFile();

  /** opens the file after a file is selected */
  void openFile( const char *file = 0 );

public slots:
  void slotSetModified( bool m );

signals:
   void wantOpenedFile( const char * );
   void wantSavedFile( const char * );
   void wantSavedBinary( const char * );
   void wantPreviewBinary( const char * );

 private:
  /** modified flag: true, if actual view is modified */
  bool bModified;
};

#endif // KDDDLLDOC_H


