#include <stdlib.h>
#include <stdio.h>

#include "EditorSettingsDlg.h"
#include "../moc/EditorSettingsDlg.moc"
#include "../moc/EditorSettingsData.moc"

#define MAX_TABSIZE 25



EditorSettingsDlg::EditorSettingsDlg(const EditorSettings& es, 
									 QWidget* parent, const char* name)
	: EditorSettingsData( parent, name ),
	  Settings(es)
{
	setCaption( "KColorEditor Settings" );

		// set widgets properties:
	btOk->setDefault(true);

	autoindent->setChecked(Settings.autoIndent());
	tabsVisible->setChecked(Settings.tabsVisible());
	tabsAsSpaces->setChecked(Settings.tabsAsSpaces());
	useColors->setChecked(Settings.useColors());
	overwriteSel->setChecked(Settings.overwriteSelection());
	autoClipboarding->setChecked(Settings.autoClipboarding());

	char str[8];
	sprintf(str, "%d", Settings.tabSize()); 
	tabWidth->setText(str);
}



EditorSettingsDlg::~EditorSettingsDlg()
{
}



const EditorSettings& EditorSettingsDlg::settings()
{
	Settings.setAutoIndent(autoindent->isChecked());
	Settings.setTabsVisible(tabsVisible->isChecked());
	Settings.setTabsAsSpaces(tabsAsSpaces->isChecked());
	Settings.setUseColors(useColors->isChecked());
	Settings.setOverwriteSelection(overwriteSel->isChecked());
	Settings.setAutoClipboarding(autoClipboarding->isChecked());

	int tabSize = atoi(tabWidth->text());
	if(tabSize < 0)
		tabSize = 0;
	if(tabSize > MAX_TABSIZE)
		tabSize = MAX_TABSIZE;
	Settings.setTabSize(tabSize);

	return Settings;
}


 
void EditorSettingsDlg::applyClicked()
{
	emit applied();
}
