/***************************************************************************
 *
 * main.cpp - KDE Printer Control panel
 *
 *  Copyright (C) 1998 Neil Hart (nhart@magma.ca)
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Id: main.cpp,v 1.11 1998/05/06 10:09:15 nhart Exp $
 *                                                                   
 **************************************************************************/


#include "kprintadmin.h"
#include "kprinterrs.h"
#include "kgsinfo.h"

#include <kapp.h>
#include <kcontrol.h>

#include <ctype.h>
#include <iostream.h>

#include "kprintappl.h"

static char* RCSinfo = "$Id: main.cpp,v 1.11 1998/05/06 10:09:15 nhart Exp $";

KPrinterApplication::KPrinterApplication(int& argc, char** argv, const char* name)
	: KControlApplication(argc, argv, name)
{
	if ( !kpc.init() )
	{
		debug("can't read printcap file\n");
		exit(1);
	}
	if (kgi.init() != RETURN_OK)
	{
		debug("can't read ghostscript.info file\n");
		exit(1);
	}
	determineDeviceAvailability();

	if (runGUI())
	{
		if (!pages || pages->contains("kprintadmin"))
			addPage(admin = new KPrinterAdmin(this,dialog,"kprintadmin",FALSE),
				klocale->translate("&Printers"), "printer.html");

		if (admin)
			dialog->show();
		else
			fprintf(stderr, "usage: kcmprinter [-init]\n");
	}
	// printf("terminating\n");
}

void KPrinterApplication::init()
{
}

void KPrinterApplication::apply()
{
}

void KPrinterApplication::help()
{
	KApplication::getKApplication()->invokeHTMLHelp("","");
}

int KPrinterApplication::numberOfPrinters()
{
	return kpc.numberOfPrinters();
}

int KPrinterApplication::addNewLocalPrinter(const QString& name,
	const QString& model, const QString& spooldir, const QString& filter,
	const QString& device, const QString& note)
{
	return kpc.addNewLocalPrinter(name, model, spooldir, filter, device, note);
}

int KPrinterApplication::addNewRemotePrinter(const QString& name,
	const QString& spooldir, const QString& host, const QString& remqueue,
	const QString& note)
{
	return kpc.addNewRemotePrinter(name, spooldir, host, remqueue, note);
}

bool KPrinterApplication::removePrinter(int printerNumber, bool removeDirs)
{
	return kpc.removePrinter(printerNumber, removeDirs);
}

bool KPrinterApplication::getPrinterLocation(int printerNumber, bool* isLocal)
{
	return kpc.getPrinterLocation(printerNumber, isLocal);
}

bool KPrinterApplication::getPrinterName(int printerNumber, QString* name)
{
	return kpc.getPrinterName(printerNumber, name);
}

bool KPrinterApplication::getPrinterModel(int printerNumber, QString* model)
{
	return kpc.getPrinterModel(printerNumber, model);
}

bool KPrinterApplication::getPrinterFilter(int printerNumber, QString* filter)
{
	return kpc.getPrinterFilter(printerNumber, filter);
}

bool KPrinterApplication::getPrinterSpooldir(int printerNumber,
	QString* spooldir)
{
	return kpc.getPrinterSpooldir(printerNumber, spooldir);
}

bool KPrinterApplication::getPrinterDevice(int printerNumber, QString* device)
{
	return kpc.getPrinterDevice(printerNumber, device);
}

bool KPrinterApplication::getPrinterHost(int printerNumber, QString* host)
{
	return kpc.getPrinterHost(printerNumber, host);
}

bool KPrinterApplication::getPrinterQueue(int printerNumber, QString* remqueue)
{
	return kpc.getPrinterQueue(printerNumber, remqueue);
}

bool KPrinterApplication::getPrinterNote(int printerNumber, QString* note)
{
	return kpc.getPrinterNote(printerNumber, note);
}

bool KPrinterApplication::getPrinterDescription(int printerNumber,QString* desc)
{
	return kpc.getPrinterDescription(printerNumber, desc);
}

bool KPrinterApplication::changePrinterName(int printerNumber,
	const char* name)
{
	return kpc.changePrinterName( printerNumber, name );
}

bool KPrinterApplication::changePrinterModel(int printerNumber,
	const char* model)
{
	return kpc.changePrinterModel( printerNumber, model );
}

bool KPrinterApplication::changePrinterFilter(int printerNumber,
	const char* filter)
{
	return kpc.changePrinterFilter( printerNumber, filter );
}

bool KPrinterApplication::changePrinterSpooldir(int printerNumber,
	const char* spooldir, bool removeDirs)
{
	return kpc.changePrinterSpooldir( printerNumber, spooldir, removeDirs );
}

bool KPrinterApplication::changePrinterDevice(int printerNumber,
	const char* device)
{
	return kpc.changePrinterDevice( printerNumber, device );
}

bool KPrinterApplication::changePrinterHost(int printerNumber,
	const char* host)
{
	return kpc.changePrinterHost( printerNumber, host );
}

bool KPrinterApplication::changePrinterQueue(int printerNumber,
	const char* remqueue)
{
	return kpc.changePrinterQueue( printerNumber, remqueue );
}

bool KPrinterApplication::changePrinterNote(int printerNumber,
	const char* note)
{
	return kpc.changePrinterNote( printerNumber, note );
}

int KPrinterApplication::numberOfPrinterTypes()
{
	return kgi.numberOfPrinterTypes();
}

bool KPrinterApplication::getPrinterGsType(int index, QString** pType)
{
	return kgi.getGsPrinterType(index, pType);
}

bool KPrinterApplication::getPrinterGsFilter(int index, QString** pFilter)
{
	return kgi.getGsPrinterFilter(index, pFilter);
}

bool KPrinterApplication::getTypeFromFilter(const QString* filter,
	QString** pType)
{
	return kgi.getTypeFromFilter(filter, pType);
}

bool KPrinterApplication::getIndexFromFilter(const QString* filter,
	int* pIndex)
{
	return kgi.getIndexFromFilter(filter, pIndex);
}

bool KPrinterApplication::defaultPrinterName(QString* qs)
{
	return kpc.defaultPrinterName(qs);
}

// Find which devices are available by attempting to open them
void KPrinterApplication::determineDeviceAvailability()
{
	FILE* fp;
	fp = fopen("/dev/lp0", "w");
	if (fp == NULL)
		deviceAvailable[0] = false;
	else
	{
		deviceAvailable[0] = true;
		fclose(fp);
	}
	fp = fopen("/dev/lp1", "w");
	if (fp == NULL)
		deviceAvailable[1] = false;
	else
	{
		deviceAvailable[1] = true;
		fclose(fp);
	}
	fp = fopen("/dev/lp2", "w");
	if (fp == NULL)
		deviceAvailable[2] = false;
	else
	{
		deviceAvailable[2] = true;
		fclose(fp);
	}
}

// Signal which devices are available. Return true if at least one is, false
//  if none have been detected.
bool KPrinterApplication::getDeviceAvailability(bool* lp0Available, 
	bool* lp1Available, bool* lp2Available)
{
	*lp0Available = deviceAvailable[0];
	*lp1Available = deviceAvailable[1];
	*lp2Available = deviceAvailable[2];
	if ( deviceAvailable[0] || deviceAvailable[1] || deviceAvailable[2] )
		return true;
	else
		return false;
}

int main(int argc, char **argv)
{
	KPrinterApplication app(argc, argv, "kcmprinter");
	app.setTitle(klocale->translate("KDE Printer Control Panel"));

	if (app.runGUI())	
		return app.exec();
	else
	{
		app.init();
		return 0;
	}
}
