/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Mon Jan 17 2000
    copyright            : (C) 2000 by Jonathan Singer
    email                : jsinger@leeta.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software and can be used or redistributed        *
 *   subject to the included license.                                      *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kchmod.h"

static const char *description =
	I18N_NOOP("Graphical tool to set file permissions");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
  { "+file", I18N_NOOP("File or directory to be opened"), 0},
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

  KAboutData aboutData( "kchmod", I18N_NOOP("Kchmod"),
    VERSION, description, KAboutData::License_BSD,
    "(c) 2000, Jonathan Singer");
  aboutData.addAuthor("Jonathan Singer",0, "jsinger@leeta.net");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication a;
  Kchmod *kchmod=0;

  if (a.isRestored())
      RESTORE(Kchmod)
  else {
      // no session management: just create one window
      kchmod = new Kchmod();
  }

  kchmod->show();
  kchmod->readArgs();

/*  KTMainWindow *mainWindow = new KTMainWindow();
  Kchmod *kchmod = new Kchmod();
  mainWindow->setView(kchmod);
  mainWindow->setFixedSize(360, 270);
  kchmod->show(); */

  return a.exec();
}
