#ifndef KBOOTSELCONFIG_H
#define KBOOTSELCONFIG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qtooltip.h>

#include <klined.h>
#include <kcontrol.h>
#include <kfiledialog.h>
#include <ksimpleconfig.h>

/**
 * This class contains the widget that is displayed in the KControlApplication.
 *
 * @short The configuration widget of KBootSelector
 * @author Stefan van den Oord <s.m.vandenoord@student.utwente.nl>
 * @version 0.3
 */
class KBootSelConfig : public KConfigWidget
{
	Q_OBJECT

	public:
		/**
		 * The constructor.
		 * @param globalConfig Indicates whether the global configuration file or the user's
		 *                     configuration file must be used.
		 */
		KBootSelConfig ( QWidget *parent, const char *name=0, bool globalConfig = false );

		/** The textbox containing the Lilo location */
		KLined *txt_liloloc;
		/** The textbox containing the boot map file location */
		KLined *txt_bootmaploc;
		/** The checkbox indicating whether the Lilo hack may be used */
		QCheckBox *chk_hack;

	public slots:
		virtual void loadSettings();
		virtual void applySettings();
		virtual void defaultSettings();

	private:
		QString configFileName;

		QVBoxLayout *layout;
		QHBoxLayout *lay_liloloc, *lay_bootmaploc;

		QLabel *lab_liloloc, *lab_bootmaploc;
		QPushButton *btn_lilobrowse, *btn_bootmapbrowse;

	private slots:
		void browseLilo();
		void browseBootmap();
};

#endif // KBOOTSELCONFIG_H
