#ifndef KAPM_H
#define KAPM_H

#include <kapp.h>
#include <qwidget.h>
#include <kwm.h>
#include <kiconloader.h>
#include <qpopupmenu.h>
#include <errno.h>
#include <time.h>
#include <qtooltip.h>
#include <qmessagebox.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include "apm.h"


class Kapm : public QWidget {
  Q_OBJECT 
public:
  /** construtor */
  Kapm(QWidget*parent=0,const char* name=0); 
  /** destructor */
  ~Kapm();

private:
	QTimer *ChargeTimer;
	QPopupMenu *menu;
	apm_info i;
	void mousePressEvent(QMouseEvent *e);
	void changeState( bool suspend );
	void checkApm();
	void errorMsg(char *message);
	void updateStruct();
	void drawIcon(char index);
	void timerEvent ( QTimerEvent *e );
	QString* statusString();
private slots:
	void slotSuspend();
	void slotStandby();
	void slotAPMStatus();
	void slotAbout();
	void slotPowerOff();
	void slotQuit();
	void chargeAnim();
	
};
#endif



























