//
// K Answering Machine
//
//
// Author: Sven Schmidt
//

#include "mainwindow.H"

#include <kapp.h>
#include <kwm.h>


int main( int argc, char **argv ) {

    KApplication  app( argc, argv );
    
    MainWindow  w;
      
    if ( app.isRestored() ) {

      if ( KTopLevelWidget::canBeRestored(1) )
      	w.restore(1);

    }
    
    app.setMainWidget( &w );
    
    DockedWindow  dock;
    
    w.connect( &w, SIGNAL( newCountChanged( int ) ),
	       &dock, SLOT( updateMessageCount( int ) ) );
    w.connect( &dock, SIGNAL( quitSelected() ),
	       &w, SLOT( quitPressed() ) );
    w.connect( &dock, SIGNAL( showSelected() ),
	       &w, SLOT( showMainWindow() ) );
    w.checkInbox();    // to get an update on the new message count
    
    KWM::setDockWindow( dock.winId() );
    
    w.show();
    dock.show();


    return app.exec();

}


