#include "kabapi.h"
#include "widget.h"
#include <qpushbt.h>
#include <qframe.h>
#include <debug.h>

KabAPI::KabAPI(QWidget* parent)
  : QDialog(parent, 0, true),
    widget(0)
{
  ID(bool GUARD=true);
  LG(GUARD, "KabAPI constructor: called.\n");
  // ########################################################
  /* NOTE: the AddressWidget-object is NOT created here, the
   *       pointer to it is initially set to zero.
   */
  // ----- create subwidgets:
  buttonOK=new QPushButton(this);
  CHECK(buttonOK!=0);
  buttonOK->setText(i18n("OK"));
  buttonCancel=new QPushButton(this);
  CHECK(buttonCancel!=0);
  buttonCancel->setText(i18n("Cancel"));
  frameLine=new QFrame(this);
  CHECK(frameLine!=0);
  frameLine->setFrameStyle(QFrame::HLine | QFrame::Raised);
  // ----- create connections:
  connect(buttonOK, SIGNAL(clicked()), SLOT(accept()));
  connect(buttonCancel, SIGNAL(clicked()), SLOT(reject()));
  LG(GUARD, "KabAPI constructor: done.\n");
  // ########################################################  
}

void KabAPI::initializeGeometry()
{
  REQUIRE(widget!=0);
  ID(bool GUARD=true);
  LG(GUARD, "KabAPI::initializeGeometry: called.\n");
  // ########################################################
  const int Grid=3;
  const int ButtonWidth=QMAX
    (buttonOK->sizeHint().width(),
     buttonCancel->sizeHint().width());
  const int ButtonHeight=buttonOK->sizeHint().height();
  int cx=widget->width();
  int cy=0;
  // ----- the addresswidget:
  widget->move(0, cy);
  cy+=widget->height()+Grid;
  // ----- the horizontal line:
  frameLine->setGeometry
    (Grid, cy, cx-2*Grid, Grid);
  cy+=2*Grid;
  // ----- the buttons:
  buttonOK->setGeometry
    (Grid, cy, ButtonWidth, ButtonHeight);
  buttonCancel->setGeometry
    (cx-Grid-ButtonWidth, cy, ButtonWidth, ButtonHeight);
  cy+=Grid+ButtonHeight;
  // ----- 
  setFixedSize(cx, cy);
  LG(GUARD, "KabAPI::initializeGeometry: done.\n");
  // ########################################################  
}
  
KabAPI::ErrorCode KabAPI::init(bool readonly)
{
  // ########################################################  
  widget=new AddressWidget(this, 0, readonly);
  if(widget!=0)
    {
      connect(widget, SIGNAL(sizeChanged()),
	      SLOT(initializeGeometry()));
      initializeGeometry();
      return NoError;
    } else {
      return InternError;
    }
  // return NotImplemented;
  // ########################################################  
}

KabAPI::ErrorCode KabAPI::getEntry
(AddressBook::Entry& entry_)
{
  REQUIRE(widget!=0);
  // ########################################################  
  AddressBook::Entry entry;
  // -----
  if(widget->currentEntry(entry))
    {
      entry_=entry;
      return NoError;
    } else {
      return NoEntry;
    } 
  // ########################################################  
}

#include "kabapi.moc"
