// Widget for chosing a filename...
#include "InputFileCtl.moc"
#include <kapp.h>
#include <kfiledialog.h>

InputFileCtl::InputFileCtl(char const * const prompt=0, char const * const initial=0, bool wDir=false, char const * const sel=0, QWidget *parent=0, const char *name=0):QWidget(parent, name)
{
	DirDlg=wDir;
	filename=new InputCtl(prompt,initial,this);
	if(sel==0)
		select=new QPushButton(i18n("&Select"),this);
	else
		select=new QPushButton(sel,this);
	select->resize(select->sizeHint().width(),select->height());
	filename->setGeometry(0,0,width()-select->width()-5,filename->height());
	select->move(filename->width()+5,0);
	connect(select,SIGNAL(clicked()),SLOT(selectPressed()));
}
void InputFileCtl::resize(int w, int h)
{
	QWidget::resize(w,h);
	filename->resize(w-select->width()-5,filename->height());
	select->move(filename->x()+filename->width()+5,0);
}
void InputFileCtl::setGeometry(int x, int y, int w, int h)
{
	move(x,y);
	resize(w,h);
}
InputFileCtl::~InputFileCtl()
{
	delete filename;
	delete select;
}
void InputFileCtl::setText(char const * const txt)
{
	filename->setText(txt);
}
char const * const InputFileCtl::text()
{
	return filename->text();
}
void InputFileCtl::selectPressed()
{
	QString n;
	KFileDialog *fDlg=new KFileDialog(".","*",this,i18n("Select file"),false,false);
	if(DirDlg) {
		n=fDlg->getDirectory(".",this);
		if(qstrlen(n) && n[strlen(n)-1]=='/')
			n[strlen(n)-1]=0;
	} else
		n=fDlg->getOpenFileName();
	if(n)
		filename->setText(n);
	delete fDlg;
}
void InputFileCtl::setEnabled(bool enable)
{
	filename->setEnabled(enable);
	select->setEnabled(enable);
}
