//
// Mike Henderson, October 1998
//
// A simple server, add it to your startkde, or your autostart
//
//

#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>

#include "klaunchserver.h"


static int socketFd = -1;
static int acceptFd = -1;

static int createSocket();
static int closeSocket(void);
static int acceptConnection(void);
static int handleRequest(void);
static void closeConnection(void);

int main(int argc, char **argv)
{
	int rv = 0;

	if (!createSocket())
	{
		printf("can't create socket\n");
		return -1;
	}
	while (1)
	{
		if (!acceptConnection())
		{
			printf("can't accept connection\n");
			rv = -2;
			break;
		}
		if (!handleRequest())
		{
			rv = -3;
			break;
		}
		closeConnection();
	}
	closeSocket();
	
	return rv;
}

static int createSocket()
{
	int rv = 0, len;
	struct sockaddr_un sa;

	(void)unlink(socketName);

	socketFd = socket(AF_UNIX, SOCK_STREAM, 0);
	if (socketFd < 0)
	{
		return rv;
	}
	memset(&sa, 0, sizeof(sa));
	sa.sun_family      = AF_UNIX;
	strcpy(sa.sun_path, socketName);
	len = sizeof(sa.sun_family) + strlen(socketName);
	if (bind(socketFd, (struct sockaddr *)&sa, len)
		< 0)
	{
		return rv;
	}
	if (listen(socketFd, 5) < 0)
	{
		return rv;
	}
	rv = 1;
	return rv;
}

static int closeSocket(void)
{
	(void)close(socketFd);
	(void)unlink(socketName);
}

static int acceptConnection(void)
{
	int rv = 1;
	struct sockaddr_un sa;
	int saSize;

	acceptFd = accept(socketFd, &sa, &saSize);
	if (acceptFd < 0)
	{
		rv = 0;
	}
	return rv;
}

static int handleRequest(void)
{
	int rv = 0;
	char request[2048];

	if (read(acceptFd, request, 2047) < 0)
	{
		return;
	}
#ifdef DEBUG
	printf("accept: %s\n", request);
#endif

	(void)system(request);

	rv = 1;
	return rv;
}

static void closeConnection(void)
{
	(void)close(acceptFd);
}

