#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>

#include "klaunchserver.h"

static char clientSocketName[36];
static int socketFd = -1;

static int createSocket();
static int closeSocket(void);
static int sendRequest(int argc, char **argv);

int main(int argc, char **argv)
{
	int rv = 0;

	if (!createSocket())
	{
		printf("can't create socket\n");
		return -1;
	}
	if (!sendRequest(argc, argv))
	{
		printf("can't send request\n");
		return -1;
	}

	closeSocket();
	
	return rv;
}

static int createSocket()
{
	int rv = 0;
	struct sockaddr_un sa;
	int len;

	socketFd = socket(AF_UNIX, SOCK_STREAM, 0);
	if (socketFd < 0)
	{
		return rv;
	}
	memset(&sa, 0, sizeof(sa));
	sa.sun_family = AF_UNIX;
	sprintf(clientSocketName, "/tmp/klaunch.%05d", getpid()); 
	strcpy(sa.sun_path, clientSocketName);
 	len = sizeof(sa.sun_family) + strlen(sa.sun_path);
 	unlink(sa.sun_path);

	if (bind(socketFd, (struct sockaddr *) &sa, len) < 0)
	{
		return rv;
	}
	memset(&sa, 0, sizeof(sa));
	sa.sun_family = AF_UNIX;
	strcpy(sa.sun_path, socketName);
	len = sizeof(sa.sun_family) + strlen(sa.sun_path);
	if (connect(socketFd, (struct sockaddr *)&sa, len)
		< 0)
	{
		return rv;
	}

	rv = 1;
	return rv;
}

static int closeSocket(void)
{
	(void)close(socketFd);
	(void)unlink(clientSocketName);
}



static int sendRequest(int argc, char **argv)
{
	int rv = 0;
	char request[2048];
	int i;

	*request = '\0';
	for (i = 1; i < argc; i++)
	{
		strcat(request, argv[i]);
		strcat(request, " ");
	}
#ifdef DEBUG
	printf("sending: %s\n", request);
#endif
	if (write(socketFd, request, strlen(request)+1) < 0)
	{
		return;
	}

	rv = 1;
	return rv;
}

