/*
                          casp.h  -  description
                             -------------------
    begin                : Mon Nov 29 20:04:41 MET 1999
    copyright            : (C) 1999 by Andreas Heil
    email                : Andreas@Heil.net
*/

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

#ifndef CASP_H
#define CASP_H

// includes for KDE
#include <kapp.h>
#include <klined.h>
#include <kmsgbox.h>
#include <ktabctl.h>
#include <ktmainwindow.h>

// includes for Qt
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qspinbox.h>

// "standard"-includes
#include <stdlib.h>
#include <time.h>

// application specific includes
#include "resource.h"

class Casp : public KTMainWindow {
  Q_OBJECT 
public: 
  Casp(QWidget*parent=0,const char* name=0);
  ~Casp();
private:
  void initMenuBar();
  void initView();
	void optionsAutosave();
  void readOptions();
  void saveOptions();
	bool autoSave;
  KConfig* config;
	KLined* pwdField;
	KTabCtl* mainView;
	QCheckBox* lower;
	QCheckBox* number;
	QCheckBox* upper;
	QCheckBox* dollar;
	QCheckBox* specials;
	KLined* specialsField;
	QLabel* lenLabel;
	QLabel* typeLabel;
	QPopupMenu* fileMenu;
	QPopupMenu* optionsMenu;
	QPushButton* goButton;
	QSpinBox* lenBox;
	QWidget* singleTab;
private slots:
  void commandCallback(int id_);
  void slotGenPwd();
};
#endif


























