#include <kconfig.h>
#include <kapp.h>
#include "dlgfind.h"
#include <qclipboard.h>
	
bool fertich = false;

dlgFind::dlgFind(QWidget *parent, const char *name ) : QDialog(parent,name,true)
{
	setGeometry(450,100,10,10);
	setMinimumSize(450,120);
	setCaption(i18n("Search files "));
	init();
}

void dlgFind::dirKeyPressed()
{
	QString s;
	KConfig *config;
	config = kapp->getConfig();
	config->setGroup("find Recents");
	
	for(int i=1;(i<c1->count()) && (i<30);i++)
	{
		s.sprintf("FindIn%d",i);
		config->writeEntry(s,c1->text(i));
	}
	if(c1->hasFocus()) c2->setFocus();
	else c1->setFocus();
	
	for(int i=1;(i<c2->count()) && (i<30);i++)
	{
		s.sprintf("FindWhat%d",i);
		config->writeEntry(s,c2->text(i));
	}
	return;
}

void dlgFind::apply()
{	
	dirKeyPressed();
	
  results->setGeometry(10,120,430,260);

	kapp->processEvents();
	KShellProcess proc("bash");
	
	proc.clearArguments();
	proc <<"find";
	proc << c1->currentText();
	proc << "-name";
	proc << c2->currentText();
	proc << ">/tmp/ausgabe";

	QApplication::connect(&proc, SIGNAL(processExited(KProcess*)),this,SLOT(slotExamine()));
	proc.start(KProcess::Block,KProcess::All);
		
		while(!fertich)
			kapp->processEvents();
	
	results->loadFile("/tmp/ausgabe",2);
	
	resize(450,400);
  results->show();
  QDir temp;
  temp.remove("/tmp/ausgabe",true);
}

void dlgFind::neu()
{
	resize(450,120);
	results->hide();
	c1->setEditText("");
	c2->setEditText("");
	return;
}

void dlgFind::panelize()
{
	accept();
}

void dlgFind::neuElement(KProcess *p,char *buffer,int bufflen)
{
	kapp->processEvents();
	return;
}

void dlgFind::init()
{	

	l1 = new QLabel(i18n("Search in :  "),this);
  l1->setAlignment( AlignRight );
  l1->setGeometry(10,50,20,20);
	l1->setMinimumSize(100, 10);
	
	l2 = new QLabel(i18n("Search for :  "),this);
  l2->setAlignment( AlignRight );
  l2->setGeometry(10,80,20,20);
	l2->setMinimumSize(100, 10);
	
	c1 = new QComboBox(true,this);
  c1->setGeometry(110,50,320,20);
	c1->setFocus();
	connect(c1,SIGNAL(activated(const char *)),this,SLOT(dirKeyPressed()));
	connect(c1,SIGNAL(highlighted(const char *)),this,SLOT(dirKeyPressed()));
	
	c2 = new QComboBox(true,this);
  c2->setGeometry(110,80,320,20);
	connect(c2,SIGNAL(activated(const char *)),this,SLOT(dirKeyPressed()));
	connect(c2,SIGNAL(highlighted(const char *)),this,SLOT(dirKeyPressed()));
	
	QString b;
	for(int i=0;i<=2;i++)
	{
		b.sprintf("bt%d",i);
		btLeiste[i] = new QPushButton("",this,b);
		btLeiste[i]->setStyle(WindowsStyle);
	}
	btLeiste[0]->setText(i18n("&Find"));
	btLeiste[1]->setText(i18n("&New"));
	btLeiste[2]->setText(i18n("&Quit"));
	
	btLeiste[0]->setGeometry(20,10,130,20);
	btLeiste[1]->setGeometry(160,10,130,20);
	btLeiste[2]->setGeometry(300,10,130,20);

	connect(btLeiste[0],SIGNAL(clicked()),this,SLOT(apply()));
	connect(btLeiste[1],SIGNAL(clicked()),this,SLOT(neu()));
	connect(btLeiste[2],SIGNAL(clicked()),this,SLOT(panelize()));
	
//**************************************************************+
// Konfigs laden !!!
//**************************************************************"		
	
	QString s;
	KConfig *config;
	config = kapp->getConfig();
	
	config->setGroup("find Recents");
	
	c1->clear();
	
	for(int i=1;i<30;i++)
	{
    s.sprintf("FindIn%d",i);
    s = config->readEntry(s,"");
    if(s == "") break;
    c1->insertItem(s);
	}
	c1->setEditText("");
	
	c2->clear();
	for(int i=1;i<30;i++)
	{
    s.sprintf("FindWhat%d",i);
    s = config->readEntry(s,"");
    if(s == "") break;
    c2->insertItem(s);
	}
	c2->setEditText("");
//***************************************************************	
	results = new KEdit(kapp,this,"show");
	results->hide();
}

dlgFind::~dlgFind()
{
}

void dlgFind::slotExamine()
{
	kapp->processEvents();
	fertich = true;
}








