#include "dlgdel.h"

dlgDel::dlgDel(
						listView *S,
						listView *D,
					   const char *SP,
					   const char *DP,
						QWidget *parent,
						const char *name) : QDialog(parent,name,true){
	Source = S;		
	Dest 	 = D;
	SourcePath = SP;
	DestPath = DP;
	
	abbruch = false;
	
	initDialog();
	init();
	startTimer(100);
}

void dlgDel::init()
{
		if(Source->itemsSelected() == 0)
		{
				delDir(SourcePath+*Source->lastItemClicked->text[0]);
		}
		else
		{
			listItem *li = Source->Liste->next;
			while(li != 0)
			{
				if(li->selected)
					delDir(SourcePath+ *li->text[0]);
				li = li->next;
				if(abbruch == true) break;
			}
		}
}

void	dlgDel::timerEvent(QTimerEvent *t)
{
  QString labText;
	killTimers();
	int counter = 0;
	ProgressBar->setValueRange(0,stack.count());
	
	while(!stack.isEmpty())
		{
			kapp->processEvents();
			
			QDir deldir(stack.getLast());
			if (deldir.exists())
				{
					deldir.rmdir(stack.getLast());
				}
			 else
				{
					deldir.remove(stack.getLast(),true);
				}
			dellabel->setText(i18n("Delete  ")+QString(stack.getLast()));
			stack.removeLast();
			counter ++;
			ProgressBar->setValue(counter);
			if(abbruch == true) break;
		}
		
	Source->readDir(SourcePath);			// und ListView refreshen
	close();	
	
}

void dlgDel::delDir(QString ldir)
{
	QDir neu;
	QFile delfile;
	neu.setPath(ldir);

	if(!neu.exists())   //fr den Fall, das es nur ein File ist
		{
			stack.append(ldir);
			return;
		}
	else stack.append(ldir);  // ansonsten Hauptdirectory einbauen !!
	
	if ( !neu.isReadable() )
	{	
	 debug("Permission denied");
	 return;
	}
		
	neu.setSorting(QDir::Name | QDir::DirsFirst | QDir::IgnoreCase);
	neu.setFilter(QDir::Files | QDir::Dirs | QDir::Hidden);

   const QFileInfoList * files = neu.entryInfoList();
   if ( files )
    {
      QFileInfoListIterator it( *files );
      QFileInfo * f;
      while( (f=it.current()) != 0 )
      {
         ++it;
         if ( f->fileName() == "." || f->fileName() == ".." )
         {
         }
         else
         {
          if ( f->isDir())
            {
	            QString fg = ldir+"/"+f->fileName();
  	          stack.append(fg);
    	        delDir(fg);
            }
         else
            {
            	delfile.setName(ldir + "/" + f->fileName());
            	stack.append(delfile.name());
            }
         }
			}
		}
}

void  dlgDel::initDialog(){
	ProgressBar = new myProgress(0,99,0,myProgress::Horizontal,this,"Balken1");
	ProgressBar->setGeometry(10,60,400,20);
	ProgressBar->setBarColor(darkBlue);
	
	dellabel = new QLabel(this,"Delete");
	dellabel->setGeometry(10,20,400,20);
	
	cancelBtn = new QPushButton(i18n("Cancel"),this);
	cancelBtn->setGeometry(160,90,100,30);
  connect(cancelBtn,SIGNAL(clicked()),SLOT(cancelPressed()));
  	
  this->resize(420,130);
  this->setMinimumSize(100,10);
}

void dlgDel::cancelPressed()
{
   abbruch = true;
   close();
}

dlgDel::~dlgDel()
{
	delete ProgressBar;
	delete cancelBtn;
	delete dellabel;
}

