// This file is part of kseti,
// a utility to manage SETI@home calculations on Un*x boxes..
//
// Copyright (C) 1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.


#ifndef KSETIVIEW_H
#define KSETIVIEW_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qwidget.h>


class KsetiDoc;
class QLabel;
class QProgressBar;



/** The KsetiView class provides the view widget for the KsetiApp instance.
 *
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow.
 * As KsetiView is part of the docuement-view model, it needs a reference to the document object
 * connected with it by the KsetiApp class to manipulate and display the document structure provided
 * by the KsetiDoc class.
 * 	
 * @author Jochen Kpper
 * @version 1999/08/24
 */
class KsetiView : public QWidget
{
    Q_OBJECT

public:

    /** Constructor for the main view */
    KsetiView( QWidget *parent=0, const char *name=0 );
  
    /** Destructor for the main view */
    ~KsetiView();

    /**
     * @return A pointer to the document connected to the view instance.
     *
     * Mind that this method requires a KsetiApp instance as a parent widget to get to the window document
     * pointer by calling the KsetiApp::getDocument() method.
     *
     * @see KsetiApp#getDocument
     */
    KsetiDoc *getDocument() const;
	
    /** contains the implementation for printing functionality */
    void print( QPrinter *m_pPrinter );
	
		
protected:
  
    /**
     * Repaint the view.
     */
    virtual void paintEvent( QPaintEvent *event );

  
protected:

    QLabel *cpu, *date, *email, *overall, *user;
    
    QProgressBar *pbar;
};



#endif // KSETIVIEW_H



//* Local Variables:
//* mode: C++
//* c-file-style: "Stroustrup"
//* End:
