// This file is part of kseti,
// a utility to manage SETI@home calculations on Un*x boxes..
//
// Copyright (C) 1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.



#include <iostream>

#include <qlayout.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qprogressbar.h>
#include <qdatetime.h>

#include "ksetiview.h"
#include "ksetidoc.h"
#include "kseti.h"



KsetiView::KsetiView( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    setBackgroundMode( PaletteBase );
    QGridLayout *layout = new QGridLayout( this, 6, 2, 5, 10 );

    QLabel *userLabel = new QLabel( i18n( "User:" ), this );
    userLabel->setBackgroundMode( PaletteBase );
    userLabel->setFixedHeight( userLabel->sizeHint().height() );
    userLabel->setMinimumWidth( userLabel->sizeHint().width() );
    layout->addWidget( userLabel, 0, 0 );
    user = new QLabel( "", this );
    user->setBackgroundMode( PaletteBase );
    layout->addWidget( user, 0, 1 );

    QLabel *emailLabel = new QLabel( i18n( "Email:" ), this );
    emailLabel->setBackgroundMode( PaletteBase );
    emailLabel->setFixedHeight( emailLabel->sizeHint().height() );
    emailLabel->setMinimumWidth( emailLabel->sizeHint().width() );
    layout->addWidget( emailLabel, 1, 0 );
    email = new QLabel( "", this );
    email->setBackgroundMode( PaletteBase );
    layout->addWidget( email, 1, 1 );

    pbar = new QProgressBar( 1000, this );
    pbar->setBackgroundMode( PaletteBackground );
    pbar->setMinimumHeight( 15 );
    pbar->setFrameStyle( QFrame::Box | QFrame::Plain );
    layout->addMultiCellWidget( pbar, 2, 2, 0, 1 );

    QLabel *cpuLabel = new QLabel( i18n( "Calculation time:" ), this );
    cpuLabel->setBackgroundMode( PaletteBase );
    cpuLabel->setFixedHeight( cpuLabel->sizeHint().height() );
    cpuLabel->setMinimumWidth( cpuLabel->sizeHint().width() );
    layout->addWidget( cpuLabel, 3, 0 );
    cpu = new QLabel( "", this );
    cpu->setBackgroundMode( PaletteBase );
    layout->addWidget( cpu, 3, 1 );

    QLabel *overallLabel = new QLabel( i18n( "Overall calculation time (est.):" ), this );
    overallLabel->setBackgroundMode( PaletteBase );
    overallLabel->setFixedHeight( overallLabel->sizeHint().height() );
    overallLabel->setMinimumWidth( overallLabel->sizeHint().width() );
    layout->addWidget( overallLabel, 4, 0 );
    overall = new QLabel( "", this );
    overall->setBackgroundMode( PaletteBase );
    layout->addWidget( overall, 4, 1 );

    QLabel *dateLabel = new QLabel( i18n( "Acquisition date:" ), this );
    dateLabel->setBackgroundMode( PaletteBase );
    dateLabel->setFixedHeight( dateLabel->sizeHint().height() );
    dateLabel->setMinimumWidth( dateLabel->sizeHint().width() );
    layout->addWidget( dateLabel, 5, 0 );
    date = new QLabel( "", this );
    date->setBackgroundMode( PaletteBase );
    date->setMinimumWidth( 100 );
    layout->addWidget( date, 5, 1 );

    layout->activate();
}


KsetiView::~KsetiView()
{
}


KsetiDoc* KsetiView::getDocument() const
{
    KsetiApp* theApp = static_cast< KsetiApp* >( parentWidget() );
    return theApp->getDocument();
}


void KsetiView::print(QPrinter* m_pPrinter)
{
    QPainter printpainter;
    printpainter.begin(m_pPrinter);
    printpainter.end();
}


void KsetiView::paintEvent( QPaintEvent *event )
{
    cpu->setText( getDocument()->cpu() );
    date->setText( getDocument()->date() );
    email->setText( getDocument()->email() );
    overall->setText( getDocument()->overall() );
    pbar->setProgress( static_cast< int >( getDocument()->progress() * 1000.0 + 0.5 ) );
    user->setText( getDocument()->user() );
}



//* Local Variables:
//* mode: C++
//* c-file-style: "Stroustrup"
//* End:
