#include <kapp.h>
#include <ktmainwindow.h>
#include "AstroMenu.h"
#include "AstroWidget.h"
#include "AstroColor.h"
#include <kpixmap.h>
#include <qkeycode.h>
#include <kprocess.h>
#include <kstatusbar.h>
#include <ktoolbar.h>

class AstroWindow : public KTMainWindow
{
public:

  AstroWindow() : KTMainWindow() {};
  // void paintEvent(QPaintEvent *);
};

char kdepath[80];
AstroMenu *am;
AstroWidget *central;
AstroWindow *asw;
AstroColorList *Acl;
KStatusBar *Ksb;
KToolBar *Ktb;
KApplication* Ka;
KIconLoader* Kil;

extern char *ChartTitle[Progress+1], *TypeTitle[Progressed_Natal+1];

extern "C"
{
#ifndef ASTROLOG
#include "astrolog.h"
#endif
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

struct icons icons[] =
{
  { "folder_open.xpm", NULL, 0 },
  { "info.xpm",        NULL, 1 },
  { "now.xpm",         NULL, 2 },
  { "inverse.xpm",     NULL, 3 },
  { "bwcolor.xpm",     NULL, 4 },
  { "2-3wheels.xpm",   NULL, 5 },
  { "animation.xpm",   NULL, 6 },
  { "direction.xpm",   NULL, 7 }
};

void KBegin()
  {
    QString s;
    if(gi.fiskde)
    {
      asw = new AstroWindow;
      CHECK_PTR(asw);
      Acl = new AstroColorList;
      CHECK_PTR(Acl);
      s.sprintf("%s %s", szAppNameCore, szVersionCore);
      emit asw->setCaption(s.data());
      Ksb = asw->statusBar();
      Ktb = asw->toolBar();
      Ksb->setBorderWidth(2);
      Kil = new KIconLoader;
      CHECK_PTR(Kil);
      am = new AstroMenu(asw);
      CHECK_PTR(am);
      asw->setMenu(am);
      central = new AstroWidget(asw, "AstroWidget");
      CHECK_PTR(central);
      asw->setView(central, FALSE);
      //QApp->setMainWidget(asw);
      asw->resize(gs.xWin+20, gs.yWin+45+Ksb->height()+Ktb->height());
      // Select the glyph for Lilith, Pluto, Uranus
      // Lilith
      szObjectFont[17] = (gs.nGlyphs % 10 == 2) ? 'e' : 'i';
      // Pluto
      szObjectFont[10] = ((gs.nGlyphs / 10) % 10 == 2) ? 'l' : 'Z';
    // Uranus
      szObjectFont[8]  = ((gs.nGlyphs / 100) % 10 == 2) ? 'm' : 'X';
      central->setPaint(' ');
      asw->show();
    }
  }
  void KInteract()
  {
    if(gi.fiskde)
      qApp->exec();
  }

  void KEnd()
  {
    Terminate(0);
  }

  void SetMenuName(int menu, char *name)
  {
    int i;
    switch(menu)
    {
       case  1 ... 12 : i = 0; break;
       case 13 ... 24 : i = SHIFT; break;
       case 25 ... 36 : i = CTRL; break;
       case 37 ... 48 : i = ALT; break;
       default        : PrintError(tr("Illegal macro number.")); exit(1);
    }
    am->changeItem(name, i + Key_F1 - ((menu /12) * 12) + menu - 1);
  }

  inline char *getlocale(char *c)
  {
    return (char *)i18n(c);
  }
  // Data tables transferred from data.c
  char *szSignName[cSign+1], *szSignAbbrev[cSign+1], *szSignEnglish[cSign+1], 
  *szHouseTradition[cSign+1], *szObjName[objMax], *szSystem[cSystem],
  *szAspectName[cAspect+1], *szAspectAbbrev[cAspect+1],
  *szAspectGlyph[cAspect+1], *szAspectConfig[cAspConfig+1], *szElem[4],
  *szMode[3], *szMonth[cSign+1], *szDay[cWeek], *szDir[4], *szSuffix[cSign+1],
  *szCnstlMeaning[cCnstl+1];

  char *notime, *compochart, *shouse, *sidereal, *tropical, *heliocentric;
  char *geocentric, *julianday, *dshouse, *fireearth, *airwater, *carfixmut;
  char *yangyin, *angsuccad, *learnshare; 
};

// This function fills an array of char pointers with the null terminated 
// list of pointers

void fill(char *t[], char *c, ...)
{
  char **ptr = &c, **tptr = t;
  while(*ptr)
      *tptr++ =  *ptr++;
}

// Fills the ai array with internationaized datas

void fillai(char *c, ...)
{
  char **ptr = &c;
  AI* a = ai;
  while(*ptr)
  {
    a->name = *ptr++;
    a++;
  }
}

// Initialization of all the data tables

void initvals()
{
  notime = tr("No time or space.");
  compochart = tr("Composite chart.");
  shouse = tr("%s houses.");
  sidereal = tr("Sidereal");
  tropical = tr("Tropical");
  heliocentric = tr("Heliocentric");
  geocentric = tr("Geocentric");
  julianday =  tr("Julian Day = %11.4f");
  dshouse = tr("%2d%s house: ");
  fireearth = tr("Fire: %d, Earth: %d,");
  airwater = tr("Air : %d, Water: %d");
  carfixmut = tr("Car: %d, Fix: %d, Mut: %d");
  yangyin = tr( "Yang: %d, Yin: %d");
  angsuccad = tr("Ang: %d, Suc: %d, Cad: %d");
  learnshare = tr("Learn: %d, Share: %d");
  fill(szSignName, "",
  tr("Aries"), tr("Taurus"), tr("Gemini"), tr("Cancer"), tr("Leo"),
  tr("Virgo"), tr("Libra"), tr("Scorpio"), tr("Sagittarius"), tr("Capricorn"),
   tr("Aquarius"), tr("Pisces"), NULL);

  fill(szSignAbbrev, "", tr("Ar"),  tr("Ta"), tr("Ge"),  tr("Cn"),  tr("Le"),
  tr("Vi"), tr("Li"),  tr("Sc"),  tr("Sg"),  tr("Cp"),  tr("Aq"),  tr("Pi"),
  NULL);

  fill(szSignEnglish, "", tr("Ram"), tr("Bull"), tr("Twins"), tr("Crab"),
  tr("Lion"), tr("Virgin"), tr("Scales"), tr("Scorpion"), tr("Archer"),
  tr("Sea Goat"), tr("Water Bearer"), tr("Fishes"), NULL);

  fill(szHouseTradition, "", tr("Personality"), tr("Money"),
  tr("Communication"), tr("Home"), tr("Children"), tr("Servants"),
  tr("Marriage"), tr("Death"), tr("Long Journeys Over Water"), tr("Career"),
  tr("Friends"), tr("Troubles"), NULL);

  fill(szObjName, tr("Earth"), tr("Sun"), tr("Moon"), tr("Mercury"),
  tr("Venus"), tr("Mars"), tr("Jupiter"), tr("Saturn"), tr("Uranus"),
  tr("Neptune"), tr("Pluto"), tr("Chiron"), tr("Ceres"), tr("Pallas"),
  tr("Juno"), tr("Vesta"), tr("Node"), tr("Lilith"), tr("Fortune"), 
  tr("Vertex"), tr("East Point"), tr("Ascendant"), tr("2nd Cusp"),
  tr("3rd Cusp"), tr("Nadir"), tr("5th Cusp"), tr("6th Cusp"),
  tr("Descendant"), tr("8th Cusp"), tr("9th Cusp"), tr("Midheaven"),
  tr("11th Cusp"), tr("12th Cusp"), tr("Cupido"), tr("Hades"), tr("Zeus"),
  tr("Kronos"), tr("Apollon"), tr("Admetos"), tr("Vulkanus"), tr("Poseidon"),
  tr("Achernar"), tr("Polaris"), tr("Zeta Retic."), tr("Pleiades"),
  tr("Aldebaran"), tr("Capella"), tr("Rigel"), tr("Bellatrix"), tr("Alnath"),
  tr("Orion"), tr("Betelgeuse"), tr("Menkalinan"), tr("Murzim"), tr("Canopus"),
  tr("Alhena"), tr("Sirius"), tr("Adara"), tr("Wezen"), tr("Castor"),
  tr("Procyon"), tr("Pollux"), tr("Suhail"), tr("Avior"), tr("Miaplacidus"),
  tr("Alphard"), tr("Regulus"), tr("Dubhe"), tr("Acrux"), tr("Gacrux"),
  tr("Becrux"), tr("Alioth"), tr("Spica"), tr("Alkaid"), tr("Agena"),
  tr("Arcturus"), tr("Rigel Kent."), tr("Antares"), tr("Shaula"), tr("Sargas"),
  tr("Kaus Austr."), tr("Vega"), tr("Altair"), tr("Peacock"), tr("Deneb"),
  tr("Alnair"), tr("Fomalhaut"), tr("Andromeda"), NULL);

  fill(szSystem, tr("Placidus"), tr("Koch"), tr("Equal"), tr("Campanus"),
  tr("Meridian"), tr("Regiomontanus"), tr("Porphyry"), tr("Morinus"),
  tr("Topocentric"), tr("Alcabitius"), tr("Equal (MC)"), tr("Neo-Porphyry"),
  tr("Whole"), tr("Vedic"), tr("Null"), NULL);

  fill(szAspectName, "", tr("Conjunct"), tr("Opposite"), tr("Square"),
  tr("Trine"), tr("Sextile"), tr("Inconjunct"), tr("Semisextile"),
  tr("Semisquare"), tr("Sesquiquadrate"), tr("Quintile"), tr("Biquintile"),
  tr("Semiquintile"), tr("Septile"), tr("Novile"), tr("Binovile"),
  tr("Biseptile"), tr("Triseptile"), tr("Quatronovile"), NULL); 

  fill(szAspectAbbrev, "", tr("Con"), tr("Opp"), tr("Squ"), tr("Tri"),
  tr("Sex"), tr("Inc"), tr("SSx"), tr("SSq"), tr("Ses"), tr("Qui"), tr("BQn"),
  tr("SQn"), tr("Sep"), tr("Nov"), tr("BNv"), tr("BSp"), tr("TSp"), tr("QNv"),
  NULL);

  fill(szAspectGlyph, tr("Circle with extending line"), 
  tr("Two circles joined by line"), tr("Quadrilateral"), tr("Triangle"),
  tr("Six pointed asterisk"), tr("'K' rotated right"), tr("'K' rotated left"),
  tr("Acute angle"), tr("Square with extending lines"), tr("Letter 'Q'"),
  tr("'+' over '-'"), tr("'-' over '+'"), tr("Number '7'"), tr("Number '9'"),
  tr("'9' under Roman 'II'"), tr("'7' under Roman 'II'"),
  tr("'7' under Roman 'III'"), tr("'9' under Roman 'IV'"), NULL);

  fill(szAspectConfig, "", tr("Stellium"), tr("Grand Trine"), tr("T-Square"),
  tr("Yod"), tr("Grand Cross"), tr("Cradle"), NULL);

  fill(szElem, tr("Fire"), tr("Earth"), tr("Air"), tr("Water"), NULL);

  fill(szMode, tr("Cardinal"), tr("Fixed"), tr("Mutuable"), NULL);

  fill(szMonth, "", tr("January"), tr("February"), tr("March"), tr("April"),
  tr("May"), tr("June"), tr("July"), tr("August"), tr("September"),
  tr("October"), tr("November"), tr("December"), NULL);

  fill(szDay, tr("Sunday"), tr("Monday"), tr("Tuesday"), tr("Wednesday"),
  tr("Thursday"), tr("Friday"), tr("Saturday"), NULL);

  fill(szDir, tr("North"), tr("East"), tr("South"), tr("West"), NULL);

  fill(szSuffix, "", tr("st"), tr("nd"), tr("rd"), tr("th"), tr("th"),
  tr("th"), tr("th"), tr("th"), tr("th"), tr("th"), tr("th"), tr("th"), NULL);

  fill(szCnstlMeaning, "",
  tr("Chained Maiden"), tr("Air Pump"), tr("Bird of Paradise"), tr("Water Bearer"),
  tr("Eagle"), tr("Altar"), tr("Ram"), tr("Charioteer"),
  tr("Herdsman"), tr("Chisel"), tr("Giraffe"), tr("Crab"),
  tr("Hunting Dogs"), tr("Great Dog"), tr("Little Dog"), tr("Sea Goat"),
  tr("Keel"), tr("Queen"), tr("Centaur"), tr("King"),
  tr("Sea Monster"), tr("Chameleon"), tr("Drawing Compass"), tr("Dove"),
  tr(" Berenice's Hair"), tr("Southern Crown"), tr("Northern Crown"), tr("Crow"),
  tr("Cup"), tr("Southern Cross"), tr("Swan"), tr("Dolphin"),
  tr("Dolphinfish"), tr("Dragon"), tr("Little Horse"), tr("River"),
  tr("Furnace"), tr("Twins"), tr("Crane"), tr("Strongman"),
  tr("Clock"), tr("Sea Serpent"), tr("Water Snake"), tr("Indian"),
  tr("Lizard"), tr("Lion"), tr("Little Lion"), tr("Hare"),
  tr("Scales"), tr("Wolf"), tr("Lynx"), tr("Lyre"),
  tr("Table Mountain"), tr("Microscope"), tr("Unicorn"), tr("Fly"),
  tr("Level"), tr("Octant"), tr("Serpent Bearer"), tr("Hunter"),
  tr("Peacock"), tr("Winged Horse"), tr("Hero"), tr("Phoenix"),
  tr("Painter"), tr("Fishes"), tr("Southern Fish"), tr("Stern"),
  tr("Compass"), tr("Net"), tr("Arrow"), tr("Archer"),
  tr("Scorpion"), tr("Sculptor"), tr("Shield"), tr(" Head/Tail of the Snake"),
  tr("Sextant"), tr("Bull"), tr("Telescope"), tr("Triangle"),
  tr("Southern Triangle"), tr("Toucan"), tr("Great Bear"), tr("Little Bear"),
  tr("Sail"), tr("Virgin"), tr("Flying Fish"), tr("Fox"), NULL);

  fillai(
  tr("Fortune"),
  tr("Spirit"),
  tr("Victory"),
  tr("Valor & Bravery"),
  tr("Mind & Administrators"),
  tr("Property & Goods"),
  tr("Siblings"),
  tr("Death of Siblings"),
  tr("Death of Parents"),
  tr("Grandparents"),
  tr("Real Estate"),
  tr("Children & Life"),
  tr("Expected Birth"),
  tr("Disease & Defects (1)"),
  tr("Disease & Defects (2)"),
  tr("Captivity"),
  tr("Servants"),
  tr("Partners"),
  tr("Death"),
  tr("Sickness & Murder"),
  tr("Danger, Violence & Debt"),
  tr("Journeys"),
  tr("Travel by Water"),
  tr("Faith, Trust & Belief"),
  tr("Deep Reflection"),
  tr("Understanding & Wisdom"),
  tr("Fame & Recognition"),
  tr("Rulers & Disassociation"),
  tr("Father, Fate & Karma"), /* Combust */
  tr("Sudden Advancement"),
  tr("Celebrity of Rank"),
  tr("Surgery & Accident"),
  tr("Merchants & Their Work"),
  tr("Merchandise (Exchange)"), /* Moon */
  tr("Mother"),
  tr("Glory & Constancy"),
  tr("Honorable Acquaintances"),
  tr("Success"),
  tr("Worldliness"),
  tr("Acquaintances"),
  tr("Violence"),
  tr("Liberty of Person"),
  tr("Praise & Acceptance"),
  tr("Enmity"),
  tr("Bad Luck"),
  tr("Debilitated Bodies"),
  tr("Boldness & Violence"),
  tr("Trickery & Deceit"),
  tr("Necessities"),
  tr("Realization of Needs"),
  tr("Retribution"),
  tr("Children (Male)"),
  tr("Children (Female)"),
  tr("Play & Variety"), /* Change */
  tr("Stability"),
  tr("Speculation"),
  tr("Art"),
  tr("Sexual Attraction"),
  tr("Sex Drive & Stimulation"),
  tr("Passion"),
  tr("Emotion & Affection"),
  tr("Most Perilous Year"),
  tr("Peril"),
  tr("Occultism"),
  tr("Commerce"),
  tr("Marriage Contracts"),
  tr("Travel by Land"),
  tr("Travel by Air"),
  tr("Destiny"),
  tr("Vocation & Status"),
  tr("Honor, Nobility (Day)"),
  tr("Honor, Nobility (Night)"),
  tr("Organization"),
  tr("Divorce"),
  tr("Ostracism & Loss"),
  tr("Friends"),
  tr("Tragedy & Brethren"),
  tr("Race (Consciousness)"),
  tr("Bondage & Slavery"),
  tr("Imprisonment & Sorrow"),
  tr("Perversion"),
  tr("Self-Undoing"),
  tr("Treachery & Entrapment"),
  tr("Bereavement"),
  tr("Suicide (Yang)"),
  tr("Suicide (Yin)"),
  tr("Depression"),
  tr("Assassination (Yang)"),
  tr("Assassination (Yin)"),
  tr("Cancer (Disease)"),
  tr("Catastrophe"),
  tr("Foolhardiness"),
  tr("Release & Luck"),
  tr("Benevolence & Assurance"),
  tr("Hope & Sensitivity"),
  tr("Aptness & Aloofness"),
  tr("Charm & Personality"),
  tr("Faith & Good Manners"),
  tr("Temperament"),
  tr("Security & Treasure"),
  tr("Originality"),
  tr("Eccentricity, Astrology"),
  tr("Divination"),
  tr("Intrusion"),
  tr("Negotiation"),
  tr("Discord & Controversy"),
  tr("Coincidence"),
  tr("Unpreparedness"),
  tr("Popularity"),
  tr("Misunderstanding"),
  tr("Sentiment & Marriage"),
  tr("Loneliness"),
  tr("Success in Investment"),
  tr("Frugality & Labor"),
  tr("Wastefulness"),
  tr("Vanity"),
  tr("Corruptness"),
  tr("Initiative"),
  tr("Memory"),
  tr("Love, Beauty & Peace"),
  tr("Disinterest & Boredom"),
  tr("Accomplishment"),
  tr("Influence"),
  tr("Increase & Impression"),
  tr("Caution"),
  tr("Timidity"),
  tr("Entertainment"),
  tr("Bequest"),
  tr("Genius"),
  tr("Revelation"),
  tr("Delusion"),
  tr("Misinterpretation"),
  tr("Intellectuality"),
  tr("Earth"),
  tr("Water"),
  tr("Air & Wind"),
  tr("Fire"),
  tr("Clouds"),
  tr("Rains"),
  tr("Cold"),
  tr("Wheat"),
  tr("Barley & Meats"),
  tr("Rice & Millet"),
  tr("Corn"),
  tr("Lentils, Iron, Pungents"),
  tr("Beans & Onions"),
  tr("Chick Peas"),
  tr("Sesame & Grapes"),
  tr("Sugar & Legumes"),
  tr("Honey"),
  tr("Oils"),
  tr("Nuts & Flax"),
  tr("Olives"),
  tr("Apricots & Peaches"),
  tr("Melons"),
  tr("Salt"),
  tr("Sweets"),
  tr("Astrigents & Purgatives"),
  tr("Silk & Cotton"),
  tr("Purgatives (Bitter)"),
  tr("Purgatives (Acid)"),
  tr("Secrets"),
  tr("Information True/False"),
  tr("Injury to Business"),
  tr("Freedmen & Servants"),
  tr("Employers"),
  tr("Marriage"),
  tr("Time for Action/Success"),
  tr("Time Occupied in Action"),
  tr("Dismissal & Resignation"),
  tr("Life/Death of Absentee"),
  tr("Lost Animal (Light)"),
  tr("Lost Animal (Dark)"),
  tr("Lawsuit"),
  tr("Decapitation"),
  tr("Torture"),
  tr("Lost Objects"), NULL);
  fill(ChartTitle, tr("Standard List"), tr("House Wheel"), 
       tr("Aspect Midpoint Grid"), tr("Aspect List"), tr("Midpoint List"),
       tr("Local Horizon"), tr("Solar System Orbit"), tr("Gauquelin Sectors"), 
       tr("Calendar"), tr("Influence"), tr("Astro-Graph"), tr("Ephemeris"), 
       tr("Arabic Parts"), tr("Rising and Setting"), tr("Transits..."), 
       tr("Progressions..."), NULL);
  fill(TypeTitle, tr("No RelationShip/Comparison Chart"),
       tr("Synastry Chart"),tr("Composite Chart"),
       tr("Time/Space Midpoint Chart"), tr("Date Difference Chart"),
       tr("Biorhythm Chart"), tr("Transit and Natal"),
       tr("Progressed and Natal"), NULL);
  icons[0].tip = tr("Open a file");
  icons[1].tip = tr("Set Chart Info...");
  icons[2].tip = tr("Now");
  icons[3].tip = tr("Reverse Background");
  icons[4].tip = tr("Monochrome");
  icons[5].tip = tr("Single or dual display");
  icons[6].tip = tr("Animation");
  icons[7].tip = tr("Reverse Direction");
} 

int main(int argc, char **argv )
{
  QString s = Ka->kde_datadir(), s1 = getenv("HOME");
  KProcess kp;   
  int i;
  KApplication astroapp(argc, argv);
  for(i = 0; i < 48; i++)
  {
    szMacro[i] = NULL;
    szMacroName[i] = NULL;
  }
  Ka = &astroapp;
  s +=  KASTPATH;
  setenv("ASTR", s.data(), 1);
  s1 += KASTDATADIR;
  if((i = open(s1.data(), 0)) != -1)
    close(i);
  else
  {
    mkdir(s1.data(), S_IRUSR + S_IWUSR + S_IXUSR);
    kp << "cp";
    s += "/astrolog.dat";
    kp << s.data();
    kp << s1.data();
    kp.start(KProcess::Block);
  }   
  setenv("ASTROLOG", s1.data(), 1);
  initvals();
  kmain(argc, argv);
}






