/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@wilhelmshaven-online.de                            *
 *                                                                       *
 *************************************************************************/

#include <qdir.h>
#include <qgrpbox.h>
#include <qimage.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qradiobt.h>

#include <ksimpleconfig.h>
#include <klocale.h>
#include <kwm.h>

#include "kthemegfxconfig.h"
#include "jpeg.h"

KThemeGfxConfig::~KThemeGfxConfig (){
}

KThemeGfxConfig::KThemeGfxConfig (QWidget * parent, const char *name, Theme *t):KConfigWidget (parent, name){
	QImageIO::defineIOHandler("JFIF","^\377\330\377\340",0, read_jpeg_jfif, NULL);
	theme=t;
	path_pic=kapp->kde_wallpaperdir();

	desktopgroup=new QGroupBox(klocale->translate("Desktop"),this);
	desktopgroup->resize(200,90);	

	desktop = new QListBox(desktopgroup, "listBox" );
	desktop->setGeometry(20,20,160,60);	
	desktop->clear();
	desktop->setAutoUpdate( FALSE );

	if (KWM::isKWMInitialized()){
		desktops=KWM::numberOfDesktops();
		for (int i = 0; i < desktops; i++ ) desktop->insertItem( KWM::getDesktopName(i+1) );
		desktop->setCurrentItem(KWM::currentDesktop() - 1);
    	}else{
		desktops=0;
		desktop->insertItem("Default");
		desktop->setCurrentItem(0);
	}
	desktop->setAutoUpdate( TRUE );    
	
	wallpapergroup=new QGroupBox(klocale->translate("Wallpaper"),this);
	wallpapergroup->resize(200,90);

	wallpaperbuttongroup = new QButtonGroup( this );
	wallpaperbuttongroup->hide();
	wallpaperbuttongroup->setExclusive( true );

	wprb1 = new QRadioButton( klocale->translate("Ti&led"), wallpapergroup );
	wprb1->move(20,20);
	wprb1->adjustSize();
	wallpaperbuttongroup->insert( wprb1, 1);
    		
	wprb2 = new QRadioButton( klocale->translate("&Centred"),wallpapergroup);
	wprb2->move(20,40);
	wprb2->adjustSize();
	wallpaperbuttongroup->insert( wprb2,2);
	
	wprb3 = new QRadioButton( klocale->translate("&Scaled"),wallpapergroup);
	wprb3->move(20,60);
	wprb3->adjustSize();
	wallpaperbuttongroup->insert( wprb3,3);		

	QDir d(path_pic);
	d.setFilter(QDir::Files);
	d.setSorting(QDir::Name);

	gfx_listbox = new QListBox( this, "listBox" );
	gfx_listbox->resize(200,200);
	gfx_listbox->clear();
	gfx_listbox->insertItem(klocale->translate("Keine Grafik"));
	gfx_listbox->setAutoUpdate(FALSE);
	for ( unsigned int i=0; i<d.count(); i++ ) gfx_listbox->insertItem(d[i]);
	gfx_listbox->setAutoUpdate(TRUE);

	for (int i=0;i<10;i++){
		theme->setWallpaper(gfx_listbox->text(0),i);
		theme->setWallpaperArg(i,0,true);
		theme->setWallpaperArg(i,1,false);
		theme->setWallpaperArg(i,2,false);
	}

	preview = new QLabel(this);
	preview->setText(klocale->translate("Couldnt load pic!"));
	preview->resize(200,200);	
	preview->setAlignment( AlignCenter );

	getCS=new QPushButton(this);
	getCS->setText(klocale->translate("Get current configuration"));

	connect( gfx_listbox, SIGNAL(highlighted(int)),SLOT(loadImage(int)));
	connect( desktop, SIGNAL(highlighted(int)),SLOT(setDesktop()));
	connect( wprb1, SIGNAL(clicked()),SLOT(buttonSelect()));
	connect( wprb2, SIGNAL(clicked()),SLOT(buttonSelect()));
	connect( wprb3, SIGNAL(clicked()),SLOT(buttonSelect()));
	connect( getCS, SIGNAL(clicked()),SLOT(slot_getCS()));
	connect( theme, SIGNAL(themeLoaded()), SLOT(themeChanged()));

	resize(450,430);
	setMinimumSize(size());

	setDesktop();
}

void KThemeGfxConfig::loadSettings(){
}

void KThemeGfxConfig::resizeEvent(QResizeEvent *){
	gfx_listbox->setGeometry(20,20,width()-250,height()-80);
	getCS->setGeometry(20,height()-50,width()-250,30);
	preview->move(width()-220,20);
	desktopgroup->move(width()-220,240);	
	wallpapergroup->move(width()-220,340);	
}

void KThemeGfxConfig::writeSettings(){
	char group[80];
	KConfigBase *config;

	config=new KSimpleConfig( KApplication::localconfigdir() + "/kdisplayrc" );
	
	for (int i=0;i<desktops;i++){
		sprintf( group, "Desktop%d",i+1);
		config->setGroup(group);
	
		QString tmp=theme->getWallpaper(i);
		if (tmp==gfx_listbox->text(0)) {
			config->writeEntry("UseWallpaper", false);
		}else{
			config->writeEntry("UseWallpaper", true);
		}

		config->writeEntry("Wallpaper", tmp);
		config->writeEntry("WallpaperMode", "Tiled" );

		if (theme->getWallpaperArg(i,0)) config->writeEntry( "WallpaperMode", "Tiled" );
		if (theme->getWallpaperArg(i,1)) config->writeEntry( "WallpaperMode", "Centred" );
		if (theme->getWallpaperArg(i,2)) config->writeEntry( "WallpaperMode", "Scaled" );
	}
	config->sync();
}

void KThemeGfxConfig::buttonSelect(){
	int d=desktop->currentItem();
	theme->setWallpaperArg(d,0,wprb1->isChecked());
	theme->setWallpaperArg(d,1,wprb2->isChecked());
	theme->setWallpaperArg(d,2,wprb3->isChecked());
}

void KThemeGfxConfig::setDesktop(){
	int d=desktop->currentItem();
	wprb1->setChecked(theme->getWallpaperArg(d,0));
	wprb2->setChecked(theme->getWallpaperArg(d,1));
	wprb3->setChecked(theme->getWallpaperArg(d,2));

	for (unsigned int i=0;i<gfx_listbox->count();i++) 
		if (gfx_listbox->text(i)==theme->getWallpaper(d)) 
			gfx_listbox->setCurrentItem(i);
	debug(theme->getWallpaper(d));
}

void KThemeGfxConfig::applySettings(){
	QApplication::setOverrideCursor( waitCursor );
	writeSettings();
	QApplication::restoreOverrideCursor();
}

void KThemeGfxConfig::loadImage(int index){
		QApplication::setOverrideCursor( waitCursor );
		QString tmp=gfx_listbox->text(index);
		theme->setWallpaper(tmp,desktop->currentItem());
		QImageIO io(path_pic+"/"+tmp,0);
		if (io.read()) {
			QPixmap tmp,tmp2;
			tmp=io.image();
			tmp2.resize(preview->width(),preview->height());

			float sx = (float)preview->width() / tmp.width();
			float sy = (float)preview->height() / tmp.height();
			
			QWMatrix matrix;
			matrix.scale( sx, sy );
			bitBlt( &tmp2, 0, 0, &tmp.xForm( matrix ) ); 

			preview->setAlignment( AlignCenter );
		 	preview->setPixmap(tmp2);
			preview->repaint();
		}else 
			if (index!=0){
				preview->setText(klocale->translate("Couldnt load Picture!"));
			}else preview->setText(klocale->translate("No Picture available!"));
		QApplication::restoreOverrideCursor();
}

void KThemeGfxConfig::slot_getCS(){
	char group[80];
	KConfigBase *config;

	config=new KSimpleConfig( KApplication::localconfigdir() + "/kdisplayrc" );
	for (int i=0;i<desktops;i++){
		
		sprintf( group, "Desktop%d",i+1);
		config->setGroup(group);
	
		QString s=config->readEntry("WallpaperMode");
		if (!s.isNull()){
			if (s=="Tiled") 	theme->setWallpaperArg(i,0,true); else theme->setWallpaperArg(i,0,false);
			if (s=="Centred")	theme->setWallpaperArg(i,1,true); else theme->setWallpaperArg(i,1,false);
			if (s=="Scaled") 	theme->setWallpaperArg(i,2,true); else theme->setWallpaperArg(i,2,false);
		}else theme->setWallpaperArg(i,0,true);
	
		theme->setWallpaper(config->readEntry("Wallpaper"),i);
	}
	setDesktop();
}

void KThemeGfxConfig::themeChanged(){
	setDesktop();
}
