/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@ebs-net.com                                        *
 *                                                                       *
 *************************************************************************/

#include <qlabel.h>
#include <klocale.h>

#include "kthemeinfo.h"
#include "version.h"

static bool GUI;

KThemeInfo::~KThemeInfo (){
	if (GUI){
	}
}

KThemeInfo::KThemeInfo(QWidget * parent, const char *name, bool init):QWidget (parent, name){
	if (init)
		GUI = FALSE;
	else
		GUI = TRUE;
	
	if (GUI){
		label=new QLabel(this);
		label->setText(	"KThemeManger "KTHEMEVERSION"\n"
				"Written by Christian Poulter\n"
				"cpoulter@wilhelmshaven-online.de\n"
				"Copyright 1998 by Christian Poulter\n\n"
				"Wallpapers, Sounds & Colorschemes createded by Kenny Lim\n"
				"kenny@predawnia.org\n\n\n"
				"KThemeManager comes with ABSOLUTELY NO WARRANTY; for details\n"
				"have a look at the COPYING-File. This is free software,\n"
				"and you are welcome to redistribute it under certain\n"
				"conditions; have a look at the COPYING-File for details.\n");
		label->setAlignment( AlignCenter );
	}
}

void KThemeInfo::resizeEvent(QResizeEvent *){
	label->setGeometry(20,20,width()-40,height()-40);
}

