#ifndef __GUI__
#define __GUI__

#include <stdlib.h>
#include <qdialog.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qmlined.h>
#include <qlined.h>
#include <qmenubar.h>
#include <qpopmenu.h>

#include "turtle.hpp"
#include "animcur.hpp"

class KTurtleGUI : public QWidget
{
		Q_OBJECT;

		KAnimCursor *cur;
		QMenuBar *menu;
		KTurtle *turtle;
		char *axiom, **rules;
		int dirs;
		int level, levels[16];

	public:
		KTurtleGUI(QWidget *);
		~KTurtleGUI();

	protected:
		void resizeEvent(QResizeEvent *);

	private slots:
		void menuNew();
		void menuLoad();
		void menuSave();
		void menuEdit();
		void menuPrint();
		void menuBitmap();
		void menuNext();
		void menuLast();
		void menuSetLevel(int);
		void menuLevel();
		void menuHelp();
		void menuAbout();

	private:
		void clear();
};

class KTurtleSetup : public QDialog
{
		Q_OBJECT;

		QMultiLineEdit *rules;
		QLineEdit *axiom;
		QLineEdit *dirs;

	public:
		KTurtleSetup(QWidget *);

		const char *getAxiom() { return axiom->text(); }
		int getDirs() { return atoi(dirs->text()); }
		int getRuleCount() { return rules->numLines(); }
		const char *getRule(int l)
			{ return (l >= rules->numLines()) ? (const char *)0: rules->textLine(l); }
		void setAxiom(const char *a) { axiom->setText(a); }
		void setRules(const char *r) { rules->setText(r); }
		void setDirs(int d) { char s[32]; sprintf(s, "%d", d); dirs->setText(s); }

	private slots:
		void okPressed();
};

#endif
