/*============================================================================*/
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> ITT_IAR.C <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*============================================================================*/
#include 	 	"com_iar.h"


void SimTrans( int st ) ;
short EulerHamRot( int st, double hp_mat[ 3 ][ 3 ], double dc_mat[ 3 ][ 3 ] ) ;
void EulerGenMat( double rot_mat[ 3 ][ 3 ], double phi, double the, double chi ) ;
short TransMomentOrient( short tm_method, short tm_frame, double tm_ori[ 3 ], double par_mat[ 3 ][ 3 ], double tm_prj[ 3 ] ) ;







/*HAMILTONIAN ROTATION AND CALCULATION OF PARAMETERS*/
void SimTrans( int st )
   {

/*FOR ROTATED HAMILTONIAN, DON'T OVERWRITE PRINCIPAL AXIS VALUES - USED FOR LEAST-SQUARES ANALYSIS*/
   Hp_mat[ st ][ 0 ][ 0 ] = Rc[ st ][ B ] ;
   Hp_mat[ st ][ 1 ][ 1 ] = Rc[ st ][ C ] ;
   Hp_mat[ st ][ 2 ][ 2 ] = Rc[ st ][ A ] ;


/*CALCULATE NEW HAMILTONIAN PARAMETERS SUBJECT TO ANY TRANSFORMATION OF EULER ANGLES PHI, THETA OR CHI*/
   EulerHamRot( st, Hp_mat[ st ], HamRot_mat[ st ] ) ;


/*REASSIGN HAMILTONIAN PARAMETERS*/
   Rc[ st ][ B ] = Hp_mat[ st ][ 0 ][ 0 ] ;
   Rc[ st ][ C ] = Hp_mat[ st ][ 1 ][ 1 ] ;
   Rc[ st ][ A ] = Hp_mat[ st ][ 2 ][ 2 ] ;


/*<XY & YX> PRODUCT TENSOR ELEMENTS NON-ZERO -> IMAGINARY ELEMENTS*/
   if( fabs( Hp_mat[ st ][ 0 ][ 1 ] ) > 1.0e-6 )
      {

   /*ERROR ANALYSIS -> LOG NON-ZERO OFF-DIAGONAL TENSOR ELEMENTS*/
      if( Err == 1 )
         fprintf( Log_fp, "%s STATE XY & YX TENSOR ELEMENTS NON-ZERO !\n", St_str[ st ] ) ;

   /*SET STAT AND DEFINE HAMILTONIAN PERTURBATION PARAMETER*/
      Tp_stat[ st ][ PXPY ] = 1 ;
      Rc[ st ][ PXPY ] = Hp_mat[ st ][ 0 ][ 1 ] ;

   /*SET IMAGINARY ELEMENT STATUS TO ACTIVE*/
      Im_stat = 1 ;
      }


/*<XZ & ZX> PRODUCT TENSOR ELEMENTS NON-ZERO -> REAL ELEMENTS*/
   if( fabs( Hp_mat[ st ][ 0 ][ 2 ] ) > 1.0e-6 )
      {

   /*ERROR ANALYSIS -> LOG NON-ZERO OFF-DIAGONAL TENSOR ELEMENTS*/
      if( Err == 1 )
         fprintf( Log_fp, "%s STATE XZ & ZX TENSOR ELEMENTS NON-ZERO !\n", St_str[ st ] ) ;

   /*SET STAT AND DEFINE HAMILTONIAN PERTURBATION PARAMETER*/
      Tp_stat[ st ][ PXPZ ] = 1 ;
      Rc[ st ][ PXPZ ] = Hp_mat[ st ][ 0 ][ 2 ] ;
      }


/*<YZ & ZY> PRODUCT TENSOR ELEMENTS NON-ZERO -> IMAGINARY ELEMENTS*/
   if( fabs( Hp_mat[ st ][ 1 ][ 2 ] ) > 1.0e-6 )
      {

   /*ERROR ANALYSIS -> LOG NON-ZERO OFF-DIAGONAL TENSOR ELEMENTS*/
      if( Err == 1 )
         fprintf( Log_fp, "%s STATE YZ & ZY TENSOR ELEMENTS NON-ZERO !\n", St_str[ st ] ) ;

   /*SET STAT AND DEFINE HAMILTONIAN PERTURBATION PARAMETER*/
      Tp_stat[ st ][ PYPZ ] = 1 ;
      Rc[ st ][ PYPZ ] = Hp_mat[ st ][ 1 ][ 2 ] ;

   /*SET IMAGINARY ELEMENT STATUS TO ACTIVE*/
      Im_stat = 1 ;
      }

   fprintf( Log_fp, "\n" ) ;
   }








/*
EULER ANGLE SIMILARITY (UNITARY) TRANSFORMATION OF HAMILTONIAN
WE WANT TO RETAIN SIGN CONVENTION OF EULER ANGLES WHERE POSITIVE ANGLES
ARE COUNTER CLOCKWISE ROTATIONS. THERFORE WE USE U = [gF].
CLOCKWISE ROTATION OF SAY UPPER STATE EIGENVECTORS (COORDINATE FRAME)
|JKK>' = SUM U * |JKK> INTO LOWER ONE IS THE SAME AS
COUNTER CLOCKWISE ROTATION OF UPPER STATE HAMILTONIAN MATRIX:
H' = [U] * H * [U]-1 WHERE U = [gF]
*/
short EulerHamRot( int st, double hp_mat[ 3 ][ 3 ], double dc_mat[ 3 ][ 3 ] )
   {
   long row, col ;
   double t_mat[ 3 ][ 3 ], tt_mat[ 3 ][ 3 ] ;


/*INITIALIZE T MATRIX AND TEMPORARY STORE ROTATIONAL CONSTANTS*/
   t_mat[ 0 ][ 0 ] = hp_mat[ 0 ][ 0 ] ;
   t_mat[ 1 ][ 1 ] = hp_mat[ 1 ][ 1 ] ;
   t_mat[ 2 ][ 2 ] = hp_mat[ 2 ][ 2 ] ;
   t_mat[ 0 ][ 1 ] = t_mat[ 1 ][ 0 ] = 0.0 ;
   t_mat[ 0 ][ 2 ] = t_mat[ 2 ][ 0 ] = 0.0 ;
   t_mat[ 1 ][ 2 ] = t_mat[ 2 ][ 1 ] = 0.0 ;


/*SUM PRODUCT ELEMENTS OF T MATRIX ROWS AND DIRECTION COSINE COLUMNS -> [BCA] * [gF]-1*/
/*NOTE [gF]-1 JUST HAS ROWS AND COLUMS SWITCHED OF [gF]*/
   for( col = 0; col < 3; col++ )
      for( row = 0; row < 3; row++ )
         tt_mat[ row ][ col ] =
            t_mat[ row ][ 0 ] * dc_mat[ col ][ 0 ] +
            t_mat[ row ][ 1 ] * dc_mat[ col ][ 1 ] +
            t_mat[ row ][ 2 ] * dc_mat[ col ][ 2 ] ;


/*SUM PRODUCT ELEMENTS OF DIRECTION COSINE ROWS AND T MATRIX COLUMNS -> [gF] * {[BCA] * [gF]-1}*/
   for( col = 0; col < 3; col++ )
      for( row = 0; row < 3; row++ )
         hp_mat[ row ][ col ] =
            dc_mat[ row ][ 0 ] * tt_mat[ 0 ][ col ] +
            dc_mat[ row ][ 1 ] * tt_mat[ 1 ][ col ] +
            dc_mat[ row ][ 2 ] * tt_mat[ 2 ][ col ] ;


/*LOG HAMILTONIAN PARAMETER MATRIX*/
   if( Phi_dc[ st ] != 0.0 || The_dc[ st ] != 0.0 || Chi_dc[ st ] != 0.0 )
      {
      fprintf( Log_fp, "----------------------------------------" ) ;
      fprintf( Log_fp, "----------------------------------------\n" ) ;
      fprintf( Log_fp, "                 %s STATE HAMILTONIAN PARAMETER MATRIX !\n", St_str[ st ] ) ;
      fprintf( Log_fp, "----------------------------------------" ) ;
      fprintf( Log_fp, "----------------------------------------\n" ) ;
      fprintf( Log_fp, "B(X)                              C(Y)                              A(Z)\n" ) ;
      for( row = 0; row < 3; row++ )
         fprintf( Log_fp, "%-34.6f%-34.6f%.6f\n", hp_mat[ row ][ 0 ], hp_mat[ row ][ 1 ], hp_mat[ row ][ 2 ] ) ;
      }


/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*
GENERATE EULER TRANSFORMATION MATRIX -> U = [gF]
AS ZARE DEFINES IT, THIS MATRIX WILL ROTATE F (SPACE FIXED FRAME)
INTO g (BODY FIXED FRAME): r_g = SUM_F [gF](PHI,THETA,CHI) * r_F
NOTE ALL ROTATIONS ARE COUNTER CLOCKWISE FOR POSITIVE EULER ANGLES
THIS IS THE SAME AS CONVENTIONS TO SPECIFY TRANSITION MOMENT ANGLES
AND AXIS ROTATION ANGLES WHERE COUNTER CLOCKWISE ROTATIONS ARE POSITIVE
*/
void EulerGenMat( double rot_mat[ 3 ][ 3 ], double phi, double the, double chi )
   {
   int row ;


/*CONVERT DEGREES TO RADIANS*/
   phi *= DEG_2_RAD ;
   the *= DEG_2_RAD ;
   chi *= DEG_2_RAD ;

/*CALCULATE DIRECTION COSINE MATRIX [gF] (=[Fg]-1) ELEMENTS - ZARE P. 81 EQ. 3.36*/
/*COLUMN 1*/
   rot_mat[ 0 ][ 0 ] = cos( the ) * cos( phi ) * cos( chi ) - sin( phi ) * sin( chi ) ;
   rot_mat[ 1 ][ 0 ] = -cos( the ) * cos( phi ) * sin( chi ) - sin( phi ) * cos( chi ) ;
   rot_mat[ 2 ][ 0 ] = sin( the ) * cos( phi ) ;

/*COLUMN 2*/
   rot_mat[ 0 ][ 1 ] = cos( the ) * sin( phi ) * cos( chi ) + cos( phi ) * sin( chi ) ;
   rot_mat[ 1 ][ 1 ] = -cos( the ) * sin( phi ) * sin( chi ) + cos( phi ) * cos( chi ) ;
   rot_mat[ 2 ][ 1 ] = sin( the ) * sin( phi ) ;

/*COLUMN 3*/
   rot_mat[ 0 ][ 2 ] = -sin( the ) * cos( chi ) ;
   rot_mat[ 1 ][ 2 ] = sin( the ) * sin( chi ) ;
   rot_mat[ 2 ][ 2 ] = cos( the ) ;
   }









/*CALCULATE AND ASSIGN MU PROJECTIONS OF TRANSITION MOMENT VECTOR*/
short TransMomentOrient( short tm_method, short tm_frame, double tm_ori[ 3 ], double par_mat[ 3 ][ 3 ], double tm_prj[ 3 ] )
   {
   double t_mat[ 3 ] ;


/*MAG/ANGLE DESCRIPTION OF TRANSITION MOMENT ACCORDING TO THETA AND CHI*/
   if( tm_method == 0 )
      {

   /*ASSIGN TM PROJECTIONS ALONG AXES - INITIALLY DEFINED AS VECTOR ALONG A AXIS OF GIVEN MAGNITUDE*/
      tm_prj[ B ] = sqrt( tm_ori[ 0 ] ) * sin( tm_ori[ THE ] * DEG_2_RAD ) * cos( tm_ori[ CHI ] * DEG_2_RAD ) ;
      tm_prj[ C ] = sqrt( tm_ori[ 0 ] ) * sin( tm_ori[ THE ] * DEG_2_RAD ) * sin( tm_ori[ CHI ] * DEG_2_RAD ) ;
      tm_prj[ A ] = sqrt( tm_ori[ 0 ] ) * cos( tm_ori[ THE ] * DEG_2_RAD ) ;
      }


/*INTENSITY PERCENTAGES ALONG EACH AXIS DESCRIPTION - ASSIGN PROJECTIONS DIRECTLY*/
   else if( tm_method == 1 )
      {

   /*CONVERT OUT OF PERCENTAGE AND SCALE WITH MAGNITUDE*/
      tm_prj[ B ] = tm_ori[ B ] / 100.0 ;
      tm_prj[ C ] = tm_ori[ C ] / 100.0 ;
      tm_prj[ A ] = tm_ori[ A ] / 100.0 ;

   /*ASSIGN TM PROJECTIONS ALONG AXES AND CONVERT TO MU CONTRIBUTIONS PRESERVING SIGN*/
      tm_prj[ B ] = (fabs( tm_prj[ B ] ) == tm_prj[ B ]) ? sqrt( tm_prj[ B ] ): -sqrt( -tm_prj[ B ] ) ;
      tm_prj[ C ] = (fabs( tm_prj[ C ] ) == tm_prj[ C ]) ? sqrt( tm_prj[ C ] ): -sqrt( -tm_prj[ C ] ) ;
      tm_prj[ A ] = (fabs( tm_prj[ A ] ) == tm_prj[ A ]) ? sqrt( tm_prj[ A ] ): -sqrt( -tm_prj[ A ] ) ;
      }



/*LOG TRANSITION MOMENT INFO*/
   fprintf( Log_fp, "              TRANSITION MOMENT ORIENTATION AND BAND TYPE CHARACTER !\n" ) ;
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n\n" ) ;
   fprintf( Log_fp, "TM ORIENTATION WITH MU PROJECTIONS:\n" ) ;
   if( !tm_method )
      fprintf( Log_fp, "MAG  = %-10f             THE  = %-10f             CHI  = %-10f\n", tm_ori[ 0 ], tm_ori[ THE ], tm_ori[ CHI ] ) ;
   else if( tm_method == 1 )
      fprintf( Log_fp, "A MAG= %-10f             B MAG= %-10f             C MAG= %-10f\n", tm_ori[ A ] / 100.0, tm_ori[ B ] / 100.0, tm_ori[ C ] / 100.0 ) ;
   fprintf( Log_fp, "A PRJ= %-10f             B PRJ= %-10f             C PRJ= %-10f\n\n", tm_prj[ A ], tm_prj[ B ], tm_prj[ C ] ) ;


/*ROTATE TRANSITION MOMENT WITH SPECIFIED FRAME ROTATION*/
   if( Phi_dc[ tm_frame ] || The_dc[ tm_frame ] || Chi_dc[ tm_frame ] )
      {

   /*ROTATE COMPONENTS OF TM WITH AXIS FRAME -> MU[B'C'A'] = [gF]*MU[BCA]*/
      t_mat[ B ] =
         par_mat[ 0 ][ 0 ] * tm_prj[ B ] +
         par_mat[ 0 ][ 1 ] * tm_prj[ C ] +
         par_mat[ 0 ][ 2 ] * tm_prj[ A ] ;

      t_mat[ C ] =
         par_mat[ 1 ][ 0 ] * tm_prj[ B ] +
         par_mat[ 1 ][ 1 ] * tm_prj[ C ] +
         par_mat[ 1 ][ 2 ] * tm_prj[ A ] ;

      t_mat[ A ] =
         par_mat[ 2 ][ 0 ] * tm_prj[ B ] +
         par_mat[ 2 ][ 1 ] * tm_prj[ C ] +
         par_mat[ 2 ][ 2 ] * tm_prj[ A ] ;


   /*ASSIGN TM PROJECTIONS ALONG AXES*/
      tm_prj[ B ] = t_mat[ B ] ;
      tm_prj[ C ] = t_mat[ C ] ;
      tm_prj[ A ] = t_mat[ A ] ;


   /*LOG TRANSITION MOMENT W/ AXIS ROTATION INFO*/
      fprintf( Log_fp, "TM W/ %s STATE AXIS ROTATION :\n", (!tm_frame) ? "GND" : "EXE" ) ;
      fprintf( Log_fp, "PHI  = %-10f             THE  = %-10f             CHI  = %-10f\n", Phi_dc[ tm_frame ], The_dc[ tm_frame ], Chi_dc[ tm_frame ] ) ;
      fprintf( Log_fp, "A PRJ= %-10f             B PRJ= %-10f             C PRJ= %-10f\n\n", tm_prj[ A ], tm_prj[ B ], tm_prj[ C ] ) ;
      }


/*ASSIGN PROJECTIONS ALONG AXES AND INTENSITY INDICATORS*/
   B_prj = tm_prj[ B ] ;
   C_prj = tm_prj[ C ] ;
   A_prj = tm_prj[ A ] ;

/*ASSIGN INTENSITY CALCULATION INDICATORS*/
   B_type = (fabs( B_prj ) > 1e-5) ? 1 : 0 ;
   C_type = (fabs( C_prj ) > 1e-5) ? 1 : 0 ;
   A_type = (fabs( A_prj ) > 1e-5) ? 1 : 0 ;


/*AMPLITUDE FLAG SET -> DETERMINE # OF AMPLITUDES TO WRITE*/
   if( Amp_stat )
      {
      if( A_type )
         Amp_no++ ;
      if( B_type )
         Amp_no++ ;
      if( C_type )
         Amp_no++ ;
      }

/*RETURN SUCCESS*/
   return( 1 ) ;
   }


