// -*- mode: C++; c-file-style: "Stroustrup" -*-
//
// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with this package.




#ifndef KROT_DIALOGGEOMTRANSFORM_H
#define KROT_DIALOGGEOMTRANSFORM_H



#include <qdialog.h>


class DataSet;
class Floated;
class KNumericSpinBox;
class KRotData;
class QListBox;
class QWidget;



/**
 * Provides a selection dialog to set the geomatric transformation parameter of 
 * 
 * @short Geometric transformation of simulations.
 * @author Jochen Kpper
 * @version 1999/01/12
 */
class DialogGeometryTransform : public QDialog
{
    Q_OBJECT

public:

    /**
     * Constructor.
     *
     * @param parent Passed to QDialog constructor.
     * @param name   Passed to QDialog constructor.
     */
    DialogGeometryTransform( KRotData *krotdata, QWidget *parent=0, const char *name=0 );

    /**
     * Refresh the list of datasets and exec the dialog.
     */
    int exec();

	
protected slots:

    /**
     * Perform transformations.
     */
    void doit();

    /**
     * Open help file of this dialog.
     */
    void help();

    /**
     * New Set selected.
     */
    void newSet( const char *name );
    
    
protected:

    /**
     * Set current to be a reference to the currently selected list item.
     */
    void getCurrentSet();

    /**
     * Refresh list of datasets.
     */
    void refresh();

    
protected:
    
    DataSet *current;
    
    QListBox* list;

    Floated *yscale;
    
    KNumericSpinBox *xshift, *yshift;

    KRotData *krotData;
};



#endif
