/*
 *    Export Class for exporting HTML Tables
 *
 *    Class for exporting HTML Tables from Worksheet data
 *    
 *
 *    (C) 1997
 *
 *    Written by Martin Hfner for the KOrigin Project
 *
 */



#include <iostream.h>
#include <string.h>
#include <stdlib.h>

#include <qmsgbox.h>

#include <kapp.h>
#include <kconfig.h>

#include "exportTeX.h"



exportTeX::exportTeX ()
{
}


exportTeX::~exportTeX ()
{
}


const char* exportTeX::getFileFilter ()
{
  static char fileFilter[255];

  k = KApplication::getKApplication ()->getConfig ();
  k->setGroup ("ExportTeX");

  strcpy (fileFilter, (const char*)k->readEntry ("Filter", "*.tex"));

  return (fileFilter);
}


void exportTeX::getOptionsSlot ()
{
  //
  // do something
  //
  QMessageBox::information (0, "Export TeX Options", 
			    "No options available yet!");
}


void exportTeX::writeTable (const char* filename, Table* T)
{
  int row, col;
  char data[100];

  QFile f (filename);
  
  if (f.exists () == TRUE) 
    {
      int result = QMessageBox::warning (0, "Warning", 
		        "Export TeX. File already exists!\n\nOverwrite it?", 
					 "Yes", "No", 0, 1);

      if (result == 1)
	{
	  //
	  // dont save it, leave the procedure
	  //
	  return;
	}
    }

  //
  // go on saving the file
  //      
  cout << "Writing file" << endl;

  f.open (IO_WriteOnly);


  /*
   *  How does a TeX table look like...
   *  
   *
   *  \begin{tabular}{cccccc}
   *
   *  Z\"uchtung & Dotiermenge & spez.\ Widerstand & Typ & Hall--Bewegl. & 
   *       n,p--Konz. \\
   *
   *  & $[ppm]$ & $[\Omega\cdot cm]$ & & $[cm^2 / V\cdot s]$ & $[cm^{-3}]$ \\
   *
   *  \end{tabular}
   *
   *
   */

  f.writeBlock ("\\begin{tabular}{", strlen ("\\begin{tabular}{"));

  for (col=0; col<T->width(); col++)
    {
      f.writeBlock ("|", 1);
      f.writeBlock ("c", 1);
    }

  f.writeBlock ("|", 1);
  f.writeBlock ("}\n\n", strlen("}\n\n"));
  f.writeBlock ("\\hline\n", strlen ("\\hline\n"));

  //
  // table column titles
  //
  for (col=0; col<T->width(); col++)
    {
      strcpy (data, T->title(col));
      if (col < T->width()-1) strcat (data, " & ");
      f.writeBlock (data, strlen (data));
    }
  
  f.writeBlock ("  \\\\\n\n", strlen ("  \\\\\n\n"));
  f.writeBlock ("\\hline\n", strlen ("\\hline\n"));

  //
  // data segment
  //
  for (row=0; row<T->height(); row++)
    {
      for (col=0; col<T->width(); col++)
	{
	  strcpy (data, T->cell (col, row));
	  if (col < T->width()-1) strcat (data, " & "); 
	  f.writeBlock (data, strlen (data));
	}
      f.writeBlock ("  \\\\\n", strlen ("  \\\\\n"));
      f.writeBlock ("\\hline\n", strlen ("\\hline\n"));
    }

  //
  // end table
  //
  f.writeBlock ("\n", strlen ("\n"));
  f.writeBlock ("\\end{tabular}", strlen ("\\end{tabular}"));

  f.close ();
}


QString exportTeX::getDescription ()
{
  return ( QString("TeX") );
}


QString exportTeX::getLatestDirectory ()
{
  return ( QString ("") );
}


void exportTeX::setLatestDirectory (const char*)
{
  //
  // save latest used directory of the file dialog
  //
}


QString exportTeX::getDefaultDirectory ()
{
  return ( QString (getenv("HOME")) );
}


void exportTeX::setDefaultDirectory (const char*)
{
  //
  // save latest used directory of the file dialog
  //
}


// ***************************************************************************
//
//               initialize the TeX export filter here
//
// ***************************************************************************



class initExportTeX
{
  public:
    initExportTeX ()
      {
	exportFilterList().append (new exportTeX ());
      }
};


static initExportTeX init;


