#include <stdlib.h>

#include <qtooltip.h>
#include <qradiobt.h>

#include "ws_insertcolumn.h"

#include "ws_insertcolumn.moc"


// **************************  new Columns Widget  ****************************

// type is an integer which descibes the type of column to be inserted
// 1 = Data
// 2 = Label

insertColumnWidget::insertColumnWidget (int type, QWidget*, const char* name)
  : QDialog (0, name, TRUE)
  {
    setFixedSize (300, 210);
    
    if (strcmp (name, "Insert") == 0) setCaption ("Insert new Columns");
    else setCaption ("Append new Columns");
    
    bg = new QButtonGroup ("Column Type", this);
    bg->setGeometry (50, 20, 200, 80);

    QRadioButton* rb = new QRadioButton ("Data Column", this);
    rb->setGeometry (80, 40, 100, 25);
    bg->insert (rb);
    if (type == 1) rb->setChecked (TRUE);

    rb = new QRadioButton ("String Column", this);
    rb->setGeometry (80, 65, 100, 25);
    bg->insert (rb);
    if (type == 2) rb->setChecked (TRUE);

    typeOfColumn = type;

    lb = new QLabel ("Number to insert:", this);
    lb->setGeometry (50, 120, 100, 25);
  
    numberOf = new QLineEdit (this);
    numberOf->setText ("1");
    numberOf->setMaxLength (10);
    numberOf->selectAll ();
    numberOf->setGeometry (170, 120, 80, 25);

    ok = new QPushButton ("Ok", this);
    ok->setGeometry (50, 165, 90, 25);
    QToolTip::add (ok, "Insert Columns");
    ok->setDefault (TRUE);

    cancel = new QPushButton ("Cancel", this);
    cancel->setGeometry (160, 165, 90, 25);
    QToolTip::add (cancel, "Go back");

    connect (ok, SIGNAL (clicked()), SLOT (accept()));
    connect (cancel, SIGNAL (clicked ()), SLOT (reject()));
    connect (bg, SIGNAL (clicked (int)), SLOT (setToButton (int)));
    connect (numberOf, SIGNAL (returnPressed ()), SLOT (accept ()));

    numberOf->setFocus ();
  }


insertColumnWidget::~insertColumnWidget ()
  {
    delete bg;
    delete ok;
    delete cancel;
    delete numberOf;
    delete lb;
  }


void insertColumnWidget::setToButton (int button)
  {
    typeOfColumn = button + 1;
  }


int insertColumnWidget::getNumberToInsert ()
  {
    return ( atoi ( numberOf->text () ) );
  }


// the type could be:
// 1 = Data
// 2 = Label

int insertColumnWidget::getTypeToInsert ()
  {
    return (typeOfColumn);
  }
