/*
 *  WORKSHEET
 *
 *  The data sheet of the korigin project!
 *
 *  Written by Martin Hfner
 *
 *  (C) 1997
 *
 */


#ifndef __WORKSHEET_H
#define __WORKSHEET_H


// ******************************************************
// these constants will be later put into a resource file
// ******************************************************

#define MAXLEN 2000
#define MAXCOLS 100
#define CELLWIDTH 100
#define CELLHEIGHT 25
#define FIRSTCELLWIDTH 50
#define FIRSTCELLHEIGHT 25
#define DEFAULTNUMCOLS 3
#define DEFAULTNUMROWS 50

#define TABLE_BG_COLOR white


//
// if 1 autocopy is enabled 
//

#define AUTOCOPY 0

//
// ******************************************************
//

#include <qwidget.h>
#include <qlined.h>
#include <qtablevw.h>
#include <qscrbar.h>
#include <qpoint.h>
#include <qpopmenu.h>
#include <qpoint.h>
#include <qevent.h>

#include <kapp.h>

#include <debug.h>

#include "column.h"
#include "table.h"
#include "ws_highlighting.h"
#include "ws_tablehead.h"
#include "ws_tablefirstcolumn.h"
#include "ws_tabledata.h"


#include "ws_columnstatistics.h"
#include "ws_columntitle.h"
#include "ws_info.h"
#include "ws_deletecolumn.h"
#include "ws_deleterow.h"
#include "ws_gotowidget.h"
#include "ws_insertcolumn.h"
#include "ws_insertrow.h"
#include "ws_normalizecolumn.h"
#include "ws_rowstatistics.h"

class TreeItem;


/**
 *  This is the main data worksheet for the korigin project. It is a very
 *  nasty code and perhaps it will be revisited the next time.
 *  @short This is the main data worksheet for the korigin project.
 *  @author Martin Hfner mh@ap-dec717c.physik.uni-karlsruhe.de
 *  @version 0.3
 */
class Worksheet : public QWidget
  {
    Q_OBJECT

    // worksheet is the chief of all TableViews, all views must get 
    // information about some private variables of Worksheet
    friend class TableFirstColumn;
    friend class TableHead;
    friend class TableData;

    // now the widgets which need control of Mr. M aka Colman
    friend class calculateWidget;
    friend class normalizeColumnWidget;
    friend class columnStatWidget;
    friend class rowStatWidget;
    friend class columnTitleWidget;

    // ************************************************************************
    //                   Now the interesting interface part
    // ************************************************************************

    public:
    
	  static QList<Worksheet>& list ();
	  static Worksheet* findWorksheet (const char*);

      static QList<QString> givenWSNames;

      /**
       * return the name of the worksheet
       */
      const char* name ();

      /**
       * reads a worksheet from disk. 
       * First a filedialog is shown. Returns 0 if file not found.
       * Otherwise returns the Worksheet opened.
       */
      static Worksheet* openWorksheetFromDisk ();

      /**
       * Reads a worksheet out of an already opened file.
       * The "[worksheet]" entry should already be read out.
       *
       */
      static Worksheet* loadFromDisk (QFile* file);

      /**
       * Find the column to the specified column name
       */
      Column findColumn (const char* name);

      /**
       * returns a pointer to the worksheets main popup for the main menu
       */
      QPopupMenu* getMenu (QPopupMenu* predefined);

      /**
       * returns a pointer to the worksheets edit popup for toplevel
       */
      QPopupMenu* getEditMenu (QPopupMenu* predefined);

      /**
       * returns a description string for the toplevel widget
       */
      const char* getDescription ();
      
      /**
       * depending on wheather worksheet is active or not two different
       * pixmaps will be returned
       */ 
      QPixmap* getSymbol ();

	  /**
	   * return a tree item for the main tree view
	   */
	  TreeItem* treeitem ();

      /**
       * if _numCols = 0 the worksheet waits for the insertColumn (ID) command
       * the _numRows can then have a indifferent value
       * @param name not really needed, this is not the worksheets name but a name used by QObject
       */
      Worksheet (int _numRows=DEFAULTNUMROWS, 
		 int _numCols=DEFAULTNUMCOLS, 
		 QWidget* parent=0, const char* name=0);
      /**
       * 
       * deletes the worksheet and also removes the nameentry
       * of the worksheet in the worksheets name list 
       * (static members). 
       */
      ~Worksheet ();

      /**
       * set cell content of a specific row, col. Not needed in the
       * moment.
       */
      void setCellContent (int row, int col, char* content); 

      /**
       * get cell content of a specific row, col. Not needed in the
       * moment.
       */
      const char* getCellContent (int row, int col); 

      /**
       * returns the IDs of the Worksheets marked columns
       * This means: the x and xerror (implicit marked columns)
       * and the marked columns.
       *
       * Returns the FIRST occurance of x and xerr until now. If there is
       * nothing selected the function will return NULL. If you have multiple
       * x in your worksheet the first occurance of x will be returned or 
       * just highlight x.
       *
       * All not found columns will return NULL.
       */
      Column* getSelected ();

      /**
       * Set the worksheet data table. The table name will be checked
       * because double occurance of same name is not allowed. The name
       * will be changed if necessary. Also repaints the worksheet.
       */
      void setTable (Table* ta);

      /**
       * return the worksheets data table
       */
      Table* getTable () { return T; }

      // *********************************************************************

      /**
       * insert Columns into the worksheet, the first function will also
       * allocate memory and set the title to a title not already given in the
       * worksheet
       *
       * insert "n" columns ot "type" 
       * 1 = Data
       * 2 = Label
       * before "position". The memory will be allocated at Mr. M by Worksheet
       */
      void insertColumn (int n, int type, int position);


    public slots:

      /**
       * save worksheet into file. file is a already opened QFile.
       * This slot does not show any widget. Therefore use saveWorksheet.
       * Important for session saving later.
       */
      void saveToDisk (QFile* file);

      /**
       * save the worksheet onto disk. This slot shows a filedialog and
       * opens the file selected. Then it calls saveToDisk. Afterwards
       * it closes the opend file.
       */
      void saveWorksheetAs ();

      /**  
       * repaints the worksheet. Perhaps needed if data changes
       */
      void repaint ();

    signals:

      /**
       * the worksheet gets a closeEvent and the user choosed to delete the
       * data from the worksheet. The Worksheet should be deleted out of the
       * list of worksheets.
       * @see #~Worksheet
       */
      void gotDeleteEvent ();

      /**
       * mouseclick into the worksheet emits this signal because this action
       * changes the active worksheet displayed by toplevel.
       */
      void activeWSChanged (Worksheet*);

      /**
       * emitted when the tree item of the worksheet changes,
       * i.e. when the description or the icon changes.
       */
      void treeItemChanged ();

      /**
       *  Plots have to react with repaint on this signal. Not yet emitted.
       */
      void dataChanged ();

      /**
       * It could happen, that the description of a table in the toplevel
       * widget should change. Not yet emitted.
       */
      void updateDescription ();

    protected:
      void resizeEvent (QResizeEvent*);
      void paintEvent (QPaintEvent*);
      void mousePressEvent (QMouseEvent* e);
      void mouseMoveEvent (QMouseEvent* e);


    private slots:
      /**
       * using the clipboard
       */
      void cut ();
      void copy ();
      void paste (); 
      void selectAll ();

      /**
       * open widgets
       */
      void showColumnPopup (QPoint p);
      void showRowPopup (QPoint p);
      void showWorksheetInfoWidget ();
      void showInsertColumnWidget (int type=insertColumnWidget::Data);
      void showAppendColumnWidget ();
      void showInsertRowWidget ();
      void showDeleteColumn ();
      void showDeleteRow ();
      void showChColName ();
      void showGotoRowWidget ();
      void showGotoColumnWidget ();
      void showColStatWidget ();
      void showRowStatWidget ();
      void showClearWorksheet ();
      void showNormalizeColumn ();
      void showCalculateWidget ();

      /**
       *  sort data in worksheet in different order
       */
      void sortWorksheetByData();

      /**
       * the tableviews emit signals if mouseclick inside to change
       * the active WS in the mainwindow
       */
      void changeActiveWS ();

      /**
       * interaction of calculate Widget and worksheet (the current column)
       */
      void writeFormulaData (fiData* fd);     
      fiData* readFormulaData ();

      void showInsertLabel ();
      void showInsertData ();

      // delete all highlighting in the tables
      void hideHighlighted ();

      /**
       * Page moving key accelerators
       */
      void PgUp ();
      void PgDown ();
      
      // here I mean the columns
      char* getNewColumnTitle ();
      bool isColumnNameGiven (char*);

      void copyToClipboard ();
      void copyFromClipboard ();

      void slotExportTable (int i);

      /**
       * the column usage list will be deleted and rebuild with default values
       */
      void resetColumnUsage ();

      /**
       * the setAsPop was clicked on row "number"
       */
      void setAsPopSelected (int number);


    private:
      /**
       * set the name of the worksheet->called by constructor
       * if name==0 a name like "data-1" will be given. If name!=0
       * the name given in "name" (perhaps with -1...) will be given.
       * This function appends a new entry at the end of the givenWSNames list.
       */
      void setName (const char* name=0);

      /**
       * This function only changes the name of the current Worksheet.
       * So there is no default value.
       */
      void changeName (const char* name);

      /**
       * do not call this, it is called by setName and changeName
       */
      QString findName (const char* name);

      // build the export menu
      QPopupMenu* buildExportMenu ();

      // the three widgets which build the table with their interactionEven
      TableHead* Thead;
      TableFirstColumn* TfiCol;
      TableData* Tdata;

      Table* T;

      // some popups
      QPopupMenu* dataColPop;
      QPopupMenu* labelColPop;
      QPopupMenu* rowPop;
      QPopupMenu* mainPop;
	  QPopupMenu* insertPop;
	//QPopupMenu* menu;
	//QPopupMenu* editmenu;

	  // the tree item for the main tree view
	  TreeItem* the_treeitem;

      /**
       * this is public because the setColumnValues-Widget has to read and
       * write it.
       * of course, with labels this makes no sense, but it is too much work
       * to make a difference. It is not worth the work
       */
      fiData** formulaData;
      
      // the worksheet uses each column for a special purpose
      QList<QString> usage;						

      // the highlightning managing class
      Highlighted* high;

      // I define the current column and row
      int curCol;
      int curRow;

      // each worksheet provides an notes string for the user to enter anything
      // he wants to remember what he has calculated
      QString notes;

      // define some Widgets which can be reached through the popups
      insertColumnWidget* insColW;
      insertRowWidget* insRowW;
      columnTitleWidget* chColName;
      WS_info* ws_info;
      gotoWidget* gotoW;
      deleteRowWidget* deleteRowW;
      deleteColumnWidget* deleteColW;
      columnStatWidget* colStatW;
      rowStatWidget* rowStatW;
      normalizeColumnWidget* normColW;
      calculateWidget* calcW;
  };


extern Worksheet* activeWS;


#endif     // __WORKSHEET_H







