#ifndef _PG_OPTIONS_H_
#define _PG_OPTIONS_H_


#include <qdialog.h>
#include <qlistbox.h>
#include <kcolorbtn.h>


class PaperFormat : public QListBoxText
{
public:
  PaperFormat (const char* name, double width, double height);
  void getFormat (double& width, double& height);
private:
  double the_width, the_height;
};


class Page;
class PaperFormatList;


class PageOptionsDialog : public QDialog
{
  Q_OBJECT
public:
  PageOptionsDialog (Page* page=0, QWidget* parent=0, const char* name=0,
					 bool modal=true, WFlags f=0);
  ~PageOptionsDialog ();

private slots:
  void paperFormat (int);
  void help ();
  void OK ();
  void apply ();

private:
  Page* whatPage;
  PaperFormatList* formatList;
  QLineEdit* pageWidth;
  QLineEdit* pageHeight;
  KColorButton* pageColor;
  QPushButton* ok;
  QPushButton* cancel;
  QPushButton* helpb;
};


#endif
