/* Emacs, this is -*- C++ -*- */

// Memo zum Erzeugen einer .po file
// xgettext -C -ktranslate kpen.h

#ifndef _KPEN_H_
#define _KPEN_H_


#include <qobject.h>
#include <qwidget.h>
#include <qlist.h>
#include <qdialog.h>
#include <qcolor.h>
#include <qpen.h>
#include <qpushbt.h>
#include <qlistbox.h>
#include <qcombo.h>
// I may not include qslider.h here, for no apparent reason?!
// Inclusion of qslider.h causes clients of kpen.h the compiler
// to crash when trying to include qslider.h in the clients .cc
// file.
//#include <qslider.h>
class QSlider;

class KColorButton;


/** KDE (Q)Pen Selector Dialog.


	Features style selection, color selection, width selection,
	pen preview, least recent pen history.

	When the user clicks okay, the then selected pen is appended
	to the least recent pen list. The least recent pen list will
	not duplicate pens in the list. Up to eight pens are remembered.


	Simplest use:

	QPen pen = KPenDialog::selectPen();


	See class KPenButton for a button for pen selection.

	@short QPen selection dialog.
	@author Patrick Schemitz
	@version build 980206
*/

class KPenDialog : public QDialog
{
  Q_OBJECT

public:

  /** Construct a KPenDialog.

	  The parameters parent and name resemble a standard QDialog. The
	  third parameter, title, defines the caption of the dialog.

	  The KPenDialog by default offers a black pen, width zero, no
	  line. If this is inapprotriate, use setPen() to preselect a
	  different pen.

	  To show and execute the dialog, just call the (inherited)
	  function exec().
  */
  KPenDialog (QWidget* parent = 0, const char* name = 0,
			  const char* title = "Select Pen");

  /** Shut down a KPenDialog.

	  Just an ordinary destructor.
  */
  ~KPenDialog ();

  /** Get current pen.

	  @return the current pen
  */
  QPen pen ();

  /** Preselect a pen.

	  This defines the specified pen to be the default pen.
  */
  void setPen (const QPen& pen);

  /** Let the user select a pen and return it.

	  This is probably what youre looking for. It displays the
	  dialog and returns the selected pen. Preselected pen is the
	  least recent pen. If you want a special pen to be preselected,
	  just pass it as an argument.

	  When the user clicks okay, the then selected pen is appended
	  to the least recent pen list.
  */
  static QPen selectPen ();

  /** Let the user manipulate/select a pen and return it.

	  This is probably what youre looking for. It displays the
	  dialog and returns the selected pen. Preselected pen is the
	  pen passed as the argument. If the user cancels the dialog,
	  the predefined pen is returned. If you want an "empty" pen
	  (i.e. a Qt default pen), omit the parameter.

	  When the user clicks okay, the then selected pen is appended
	  to the least recent pen list.

	  @param predef the pen to use as default
  */
  static QPen selectPen (const QPen& predef);

  /** Produce an return a QPixmap demonstrating the specified pen.

	  The pixmap is meant to show the user what kind of lines the
	  selected pen will draw.

	  @param width the proposed width of the pixmap
	  @param height the proposed height of the pixmap
	  @param pen the pen to use for the pixmap
  */
  static QPixmap penImage (int width, int height, const QPen& pen);

signals:

  /** Emitted when the OK button is pressed. */
  void pressedOK ();

  /** Emitted when the Cancel button is pressed. */
  void pressedCancel ();

  /** Emitted when the Help button is pressed. */
  void pressedHelp ();

private slots:

  void penChanged ();
  void clickedOK ();
  void clickedCancel ();
  void clickedHelp ();
  void clickedRecent (int);

private:

  char* penstring (const QPen&);
  void evaluateControls();
  void actualizeControls();

  static QList<QPen> the_recent;

  QList<QPixmap> pixlist;
  PenStyle the_style;
  QColor the_color;
  int the_width;

  QPushButton* ok;
  QPushButton* help;
  QPushButton* cancel;

  QLabel* example_w;
  QComboBox* recent_w;
  QComboBox* style_w;
  QSlider*   width_w;
  KColorButton* color_w;

};



/** KDE (Q)Pen Selector Button.


	This is a convenience class for the KDE Pen Selector Dialog,
	class KPenDialog. It shows a push button displaying the preselected
	pen. When clicked, executes the KPenDialog to let the user modify
	the pen.


	Simplest use:

	QPushButton* pen = new KPenButton(my_pen,this,"button_pen");

	//...

	my_pen = pen->pen();


	@short QPen selection button.
	@author Patrick Schemitz
	@version build 980206
*/

class KPenButton : public QPushButton
{
  Q_OBJECT

public:

  /** Construct a Button which triggers a KPenDialog.

	  The default pen is a solid line, black, 1pt.

	  If you want to offer a preselected pen, use the other variant of
	  the constructor, or use setPen().

	  @param parent just like in QPushButton
	  @param name just like in QPushButton
  */
  KPenButton (QWidget* parent, const char* name = 0);

  /** Construct a Button which triggers a KPenDialog.

	  Use the specified pen as a preselection.

	  @param deflt preselected pen
	  @param parent just like in QPushButton
	  @param name just like in QPushButton
  */
  KPenButton (const QPen& deflt, QWidget* parent, const char* name = 0);

  /** Destructor. */
  ~KPenButton ();

  /** Preselect a pen.

	  This selects the specified pen as the current pen. The
	  button is updated, the newly set pen shown. A changed()
	  signal is emitted.
  */
  void setPen (const QPen& p);

  /** Returns the currently selected pen. */
  QPen pen ();

signals:

  /** Emitted when the pen is changed (via setPen() or dialog). */
  void changed (const QPen&);
 
protected slots:

  /** Connected to the QPushButtons signal.

	  This function actually invokes the KPenDialog.
  */
  void slotClicked ();
 
protected:

  /** Re-implemented draw function for the buttons content.

	  This function draws the penImage() of the current pen into
	  the painter and thus into the button.
  */
  void drawButtonLabel (QPainter* p);

private:

  QPen the_pen;

};


/** KDE (Q)Pen Selector Widget


	This widget is a (partial, if you choose so) pen dialog. It has
	been written for use within other dialogs, so you wont need to
	manually create style/width/color control. Note that this widget
	is *not* connected to the recent pen list.

	@short QPen selection widget (configuratible).
	@author Patrick Schemitz
	@version build 980210
*/

class KPenWidget : public QWidget
{
  Q_OBJECT

public:

  /** Flags to configure the widget. Combine (add them up) these
	  flags to add controls to the widget.

	  Style, width, and color controls build the first line of the
	  widget, the example control builds the second line. Note that
	  the example field is as wide as the sum of the other controls.


	  KPen_style adds the style combo box (solid, dotted, etc.)

	  KPen_width adds the width slider bar.

	  KPen_color adds the color selection button.

	  KPen_example adds a preview field below the other controls.
  */
  enum KPenFlags {
	KPen_style = 1,
	KPen_width = 2,
	KPen_color = 4,
	KPen_example = 8
  };

  /** Construct a pen widget with the controls specified by the
	  flags. The other two parameters are just as for any QWidget.
	  See KPenFlags on how to make up the flags.

	  @param flags a combination of KPen_style, KPen_width, etc
	  @param parent as in QWidget
	  @param name as in QWidget
  */
  KPenWidget (int flags, QWidget* parent, const char* name);

  /** Destructor. */
  ~KPenWidget ();

  /** Preselect a pen.

	  This selects the specified pen as the current pen. The
	  button is updated, the newly set pen shown. A changed()
	  signal is emitted.
  */
  void setPen (const QPen& pen);

  /** Returns the currently selected pen. */
  QPen pen ();

signals:

  /** Emitted when the pen is changed (via setPen() or a control). */
  void penChanged (const QPen&);

private slots:

  void penChanged ();

private:

  void actualize ();
  void evaluate ();

  int      t_width;
  int      the_width;
  PenStyle the_style;
  QColor   the_color;

  QLabel* example_w;
  QSlider* width_w;
  QComboBox* style_w;
  KColorButton* color_w;

};

#endif
