#ifndef _CENTRE_H_
#define _CENTRE_H_


#include <qwidget.h>
#include <qpopmenu.h>
#include <qkeycode.h>
#include <qfiledlg.h>
#include <qpixmap.h>

#include <kmenubar.h>
#include <ktoolbar.h>
#include <ktreelist.h>
#include <kstatusbar.h>
#include <ktopwidget.h>

#include "worksheet.h"
#include "plot.h"
#include "page.h"



/** Korigin Top-Level Widget, the main window.
	This is the "control centre" of Korigin. It holds the main menu,
	the tool bar, the status line, and the main tree view with the
	worksheet/page/plot list.

	@see Tree
*/

class KCentre : public KTopLevelWidget
{

  Q_OBJECT

public:

  KCentre (QWidget* parent=0, const char* name=0);
  ~KCentre ();

  /** Does the user like Windows(tm)? If s/he does, give em what
	  they want: lots of annoying message boxes giving irrelevant
	  warnings/confirmations and force then to click OK buttons.
	  At least, this one *is* off-switchable :-)
  */
  static bool IlikeWindows;

  /*
	Session Management Section
	--------------------------
  */

private slots:

  void loadSession ();
  void saveSession ();
  void saveSessionAs ();
  void clearSession ();

private:

  QString sessionName;

  /*
	Page Section
	------------
  */

private slots:

  void openPage ();
  void savePage ();
  void createPage ();
  void printPage ();
  void removePage (Page*);
  void removePageObject (PageObject*);
  void changeActivePage (Page*);
  void pageDefaults ();

private:

  void propagate_page (Page* new_page);
  void unpropagate_page (Page* new_page);
  void printPage (Page*);
  QPopupMenu* buildInitialPageMenu (QPopupMenu* predefined = 0);

  /*
	Plot Section
	------------
  */

private slots:

  void initialPlot (int);
  void initialPlotDefault ();
  void changeActivePlot (Plot* thePlot);

private:

  QPopupMenu* buildNewPlotMenu (QPopupMenu* predefined = 0);
  QPopupMenu* buildInitialPlotMenu (QPopupMenu* predefined = 0);

  /*
	Fitter Section
	--------------
  */

private slots:

  void executeFitter (int id);

  /*
	Worksheet Section
	-----------------
  */

private slots:

  void createWorksheet ();
  void removeWorksheet (Worksheet* worksheet);
  void openWorksheet ();
  void saveWorksheet ();
  void changeActiveWorksheet (Worksheet*);


private:

  void propagate_worksheet (Worksheet* new_worksheet);
  void unpropagate_worksheet (Worksheet* new_worksheet);
  QPopupMenu* buildWorksheetMenu (QPopupMenu* predefined = 0);
  QList<Worksheet> worksheetList;

  /*
        Window Popup
        ------------
   */

private slots:
  void slotResultWindow ();

private:
  int resultID;

  /*
	Misc. Section
	-------------
  */

private slots:

  void unimplemented ();
  void oblivion ();
  void toolbarClicked (int);
  void importTable (int i);

private:

  QPopupMenu* buildEditMenu (QPopupMenu* predefined = 0);
  QString getSaveName (const char* extension);
  QString getLoadName (const char* extension);

  /*
	Tree Section
	------------
  */

private slots:

  /// Slot for tree selection.
  void slotTreeSelect (int id);
  /// Slot for tree expand/collapse trigger.
  void slotTreeToggleFold (int id);
  /// Slot to collapse/fold a page in the tree.
  void slotTreeFold (int id);
  /// Slot to expand/unfold a page in the tree.
  void slotTreeUnfold (int id);
  /// Slot to insert a child plot item to the tree.
  void treeInsertChild (TreeItem* parent, TreeItem* child);

private:

  int findTreeObject (QObject*);

  /*
	Help Section
	------------
  */

private slots:

  /// Slot for Help menu.
  void slotShowHelper ();
  /// Slot for Help Index
  void slotShowHelpIndex ();
  /// Slot for the about dialog.
  void slotShowAboutBox ();
  /// Slot for the about Qt dialog.
  void slotShowAboutQt ();

  /*
	Menu Stuff Section
	------------------
  */

private:

  QPopupMenu* file_menu;
  QPopupMenu* edit_menu;
  QPopupMenu* worksheet_menu;
  QPopupMenu* page_menu;
  QPopupMenu* import_menu;
  QPopupMenu* new_plot_menu;
  QPopupMenu* plot_menu;
  QPopupMenu* fitter_menu;
  QPopupMenu* options_menu;
  QPopupMenu* window_menu;
  QPopupMenu* help_menu;

  KMenuBar* menu;
  KToolBar* toolbar;
  KStatusBar* status;
  Tree* tree;

};

#endif

