/*
 Copyright (C) 1999, Mark W J Redding <grawlfang@tesco.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _STARS_INCLUDE
#define _STARS_INCLUDE

extern int OpenStars(double);
extern int FetchStars();
extern int CloseStars();
extern long getBSCatalog();
extern char *getName();
extern char *getShortConst();
extern long getHDCatalog();
extern long getADSCatalog();
extern char *getVarID();
extern short getRAhour();
extern short getRAminute();
extern double getRAsecond();
extern double getRA();
extern short getDECdegree();
extern short getDECminute();
extern double getDECsecond();
extern double getDeclination();
extern double getVMagnitude();
extern double getBVMagnitude();
extern char *getSpectrum();
extern int getStarCount(double);
extern int OpenFind(double,double,double,double);
extern int FetchFind();
extern int CloseFind();
extern char *getConstellation(char *);
extern int ConnectStars(long,long);
extern int UnconnectStars(long,long);
extern int OpenOutlines();
extern int FetchOutlines(double *,double *,double *,double *);
extern int CloseOutlines();

#endif
