// Emacs will be in -*- Mode: c++ -*-
//
// ********** DO NOT REMOVE THIS BANNER **********
//
// SUMMARY: Language for a Finite Element Method
// RELEASE: 2.0     
// USAGE  : You may copy freely these files and use it for    
//          teaching or research. These or part of these may   
//          not be sold or used for a commercial purpose with- 
//          out our consent : fax (33)1 44 27 44 11        
//
// AUTHORS:  D. Bernardi, Y. Darmaillac F. Hecht,    
//           P. Parole O. Pironneau C. Prud'homme
// ORG    :          
// E-MAIL :   pironneau@ann.jussieu.fr     
//
// ORIG-DATE:     June-94
// LAST-MOD:      3-Jan-96 at 13:40:55 by Prud'homme Christophe
//
// DESCRIPTION:  
// DESCRIP-END.
//

#ifndef __FEM_H
#define __FEM_H 1

float solvePDE( fcts *param, int how, int quad);
int initFEM(triangulation* t, int quadra);
creal deriv (int m, creal * f, int ksolv, int i, int quadra);
creal convect(creal* f, creal* u1, creal* u2, float dt, int i, int
quad);
creal rhsConvect(creal* f, creal* u1, creal* u2, float dt, int i, int
quad);
creal fctval(creal* f,float x,float y, int quad);
int getregion(triangulation* t,int k);
void libereFEM();
creal gfemuser( creal what, creal *f, int i);
creal P1ctoP1(creal* f, int i);
creal prodscalar(creal* f, creal* g, int quadra);

creal ginteg(int, int, int, creal*, creal*, int, int);
creal binteg(int, int, int, creal*, creal*, int, int);

void initvarmat ( int how, int flagcomplexe,int N, fcts* param);
void assemble ( int how, int flagcomplexe,int N, int k, creal* a, creal* b, fcts* param);
void solvevarpde(int N,  fcts* param, int how);


#endif /* __FEM_H */
