// -*- Mode: c++ -*-
//
// $Id$
//
// SUMMARY:      
// USAGE:        
//
// AUTHOR:       Christophe Prud'homme
// ORG:          Christophe Prud'homme company
// E-MAIL:       Christophe.Prudhomme@asci.fr
//
// ORIG-DATE:    10-Sep-97 at 02:02:22
// LAST-MOD:     10-Sep-97 at 02:02:22 by Christophe Prud'homme
//
// DESCRIPTION:  
//
// $Log$
// DESCRIP-END.
//
#ifndef __GFem_H
#ifdef __GNUG__
#pragma interface
#endif
#define __GFem_H 1



#include <iostream.h>

#include <qpainter.h>
#include <qwidget.h>
#include <qmsgbox.h> 

#include "../../kfem/canvas.h"

class GFem
{
public:
  GFem(Canvas *qp_ = 0, QString *edp_ = 0, int w = 500, int h = 500): 
    qpd(qp_), edp(edp_), width_(w), height_(h) { 
      qp = new QPainter; 
  }
  ~GFem() { delete qp; }

  void run();
  void drawPoint(int x, int y) { qp->drawPoint(x, y); }
  void moveTo(int x, int y) { qp->moveTo(x, y); } 
  void lineTo(int x, int y) { qp->lineTo(x, y); } 
  void initGraphic() { qp->begin(qpd->zoomedPixmap()); }
  void closeGraphic() { qp->end(); qpd->repaint(0); }
  void flush() { qp->flush(); }
  int width() const { return width_; }
  int height() const { return height_; }
  void clear() { qp->eraseRect(qpd->rect());  }
  bool wait() 
    { 
      bool ok = QMessageBox::query ("Wait", 
				    "You enabled the waiting flag\n"\
				    "So KFem is waiting for you to\n"\
				    "continue the computation\n"\
				    "You may also cancel the job", "Continue", "Stop"); 
      return ok;
  }
private:
  QPainter *qp;
  Canvas* qpd;
  QString *edp;
  
  int width_, height_;
};
#endif /* __GFem_H */
