/*
 * -*- Mode: c -*-
 *
 * SUMMARY:      
 * USAGE:        
 *
 * AUTHOR:       Elie Sadaka
 * ORG:          CNAM
 * E-MAIL:       adaka@cnam.fr
 *
 * ORIG-DATE:     1-Jul-96 at 09:38:14
 * LAST-MOD:      1-Jul-96 at 09:57:16 by Christophe Prudhomme
 *
 * DESCRIPTION:  
 * 
 * - aidvalGfem.c programme qui lit sur le clavier les coordonnees
 * des points de la frontiere exterieure , le nombre des frontieres
 * interieures et pour chacune les coordonnees de ses points
 * le nombre total des point sur les frontieres et les distribue
 * equitablement en fonction de la longueur de chaque segment
 * il lit le nombre des noeuds du maillage : mesh
 * Il ecrit automatiquement les borders
 * 
 * - On peut agrandir sa tache mais ce n'est pas rentable
 * car il devient complique pour l'utilisateur, ainsi il vaut mieux
 * que l'utilisateur, ayant obtenu le fichier produit par aidvalGfem.c,
 * procede a ajuster 
 * 1# les conditions de frontiere
 * 2# les EDP correspondantes
 * 3# Les fichiers de sauvegarde desires
 *
 * ----------------------------------------------------------
 * 
 * Compilation sur zadig:
 * make aidvalGfem
 * 
 * a l'aide du fichier Makefile suivant:
 * [
 * 
 * CC = cc
 * DEBUG = -g
 * 
 * INCLUDE =  -I/usr/openwin/include
 * LIBS =   -lm 
 * 
 * .c:
 * $(CC) -o $@ $(INCLUDE) $< $(LIBS)
 * 
 * ]
 * DESCRIP-END.
 */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <math.h>
FILE                                                 *fp;
int        i,j,n,ni[2000],pi[2000],ntotal,np,nf,nfm,mesh;
float                               s[200],t[200],aux,st;
float               betta[2000][2000], alpha[2000][2000];
float                        x[2000][2000],y[2000][2000];
static char                                  nomfich[20];
char                      na[20],pdefich[20],datfich[20];
long                                               heure;
   
    /*-------------------------------------------------------------------*/
        
main()
{
      
  printf("  aideGfem : c'est un outil  pour le logiciel Gfem v2    \n");
  printf("  et seulement  lorsque les frontieres sont polygonales  \n");
  printf("  Il prepare la partie formee par les borders            \n");
  printf("  Il fait autommatiquement le parametrage des frontieres \n");
  printf("  Apres, l'utilisateur n'a qu'a ajouter a la fin:        \n");
  printf("  et selon la syntaxe de Gfem ;                          \n");
  printf("   les conditions sur les frontieres du probleme         \n");
  printf("   et l'equation au derivees partielles                  \n");
  printf("  c'est-a-dire (par exemple) :                           \n");
  printf("    ............................                         \n");
  printf("    solve(v)                                             \n");
  printf("    {                                                    \n");
  printf("      onbdy(1) dnu(v)= 0;                                \n");
  printf("      onbdy(2)     v = t1;                               \n");
  printf("      onbdy(3) dnu(v)= 0;                                \n");
  printf("      onbdy(4)      v=t0;                                \n");
  printf("      pde(v) -laplace(v)*kappa+id(v) = 0;                \n");
  printf("    };                                                   \n");
  printf("    plot(v);                                             \n");
  printf("      \n");     printf("      \n");
  printf("      \n");     printf("      \n");
  printf("      \n");     printf("      \n");
  /*------------------------------------------------------------------- */
  printf(" Donnez le nom de fichier (sans extension)              \n");
  gets(nomfich);time(&heure);
  strcpy(pdefich ,nomfich);
  strcpy(datfich ,nomfich);
     
  *pdefich = *strcat(pdefich,".pde");
  *datfich = *strcat(datfich,".dat");
    
  printf("Votre fichier (avec extension) est %s            \n",pdefich);
  printf("Votre fichier sauvegarde (avec extension) est %s \n",datfich);
                 
  /*------------------------------------------------------------------- */
  printf(" Donner le nombre nfm des points discr sur les frontieres:\n");
  fgets(na,10,stdin);nfm = atoi(na);
  printf(" Donner le nombre mesh de maillage                       :\n");
  fgets(na,10,stdin);mesh = atoi(na);
  /*------------------------------------------------------------------- */
        
  printf("  Une seule frontiere exterieure :                       \n");
  printf(" Donner le nombre des sommets de la frontiere exterieure:\n");
  *na=*fgets(na,10,stdin);ni[0]=atoi(na);
       
  printf(" Donner ces  sommets dans le sens positif de rotation :  \n");
  for (i=0;i < ni[0];i++)
    {
      printf(" xA%d   ",i+1  );
      *na=*fgets(na,15,stdin); x[0][i]=(float)atof(na);
      printf("%f \n",x[0][i]);
      printf(" yA%d   ",i+1  );
      *na=*fgets(na,15,stdin); y[0][i]=(float)atof(na);
      printf("%f \n",y[0][i]);
    }
           
  /*------------------------------------------------------------------- */
  printf(" Donner le nombre des  frontieres  interieures:\n");
  fgets(na,10,stdin);nf = atoi(na);
  /*------------------------------------------------------------------- */
  for (i= 1;i < nf+1;i++)
    {
      printf(" Donner le nombre des sommets de la ");
      printf("frontiere interieure: C(%d) \n",i);
 
      *na = *fgets(na,10,stdin); ni[i] = atoi(na);
      printf(" Donner ces sommets dans le sens negatif de rotation \n");
      for (j=0;j < ni[i];j++)
        {
          printf("C(%d) : xA%d   \n",i+1,j+1  );
          *na=*fgets(na,15,stdin);  x[i][j]=(float)atof(na);
          printf("%f \n",x[i][j]);
          printf("C(%d) : yA%d  \n ",i+1,j+1  );
          *na=*fgets(na,15,stdin);  y[i][j]=(float)atof(na);
          printf("%f \n",y[i][j]);
        }
    }
  /*------------------------------------------------------------- */
  fp = fopen(pdefich,"w");
  fprintf(fp,"/*------------------------------------------------*/ \n");
  fprintf(fp,"/*\n");
  fprintf(fp," Methode Creation E. Sadaka  mars 1996        \n");
  fprintf(fp," Generateur:  valG                            \n");
  fprintf(fp," Nomm du  Fichier   %s               \n",pdefich );
  fprintf(fp,"Date  de Creation:  %s          \n",ctime(&heure));
  fprintf(fp,"                                              \n");
  fprintf(fp,"*/                                            \n");
  fprintf(fp,"                                              \v");
  fprintf(fp,"                                              \n");
  fprintf(fp,"/*------------------------------------------------*/ \n");
  fprintf(fp,"/*  Une seule frontiere exterieure :       */ \n");
  fprintf(fp,"/*  Les sommets de la frontiere exterieure:   \n");
              /*------------------------------------------------------------- */
  for (j=0;j < ni[0];j++)
    fprintf(fp,"C(0): A%d(%3.1f; %3.1f) \n", j+1,x[0][j],y[0][j] );
  /*------------------------------------------------------------- */
  fprintf(fp," Il y a  %d frontieres  interieures:     \n",nf);
            
  for (i=1;i < nf+1;i++)
    {
      fprintf(fp,"Il y a %d sommets sur la frontiere interieure:C(%d)\n",
              ni[i],i);
         
      for (j=0;j < ni[i];j++)
        {
          fprintf(fp,"C(%d): A%d(%3.1f; %3.1f) \n",
                  i,  j+1,x[i][j],y[i][j] );
        }
    }
  fprintf(fp," */ \n");
  fprintf(fp,"/*------------------------------------------------*/ \n");
              /*-------------------------------------------------------------------*/
  ntotal = 0;
  for (i=0;i < nf+1 ;i++)    ntotal+=ni[i];
      
  fprintf(fp,"/* Le nombre total de points frontieres: %d  */\n",ntotal);
              /*-------------------------------------------------------------------*/
  
  /*-------------------------------------------------------------------*/
  /* Configurationd des  frontieres exterieur et interieures           */
  /*-------------------------------------------------------------------*/
  np=0;
  for (i=0;i<nf+1 ;i++)
    {
      for (j=0;j<ni[i] ;j++)
        {
          s[j+np]= sqrt((x[i][(j+1)%ni[i]]-x[i][j])*
                        (x[i][(j+1)%ni[i]]-x[i][j])+
                        (y[i][(j+1)%ni[i]]-y[i][j])*
                        (y[i][(j+1)%ni[i]]-y[i][j]) ) ;
        }
      np=np+ni[i];
    }
  /*-------------------------------------------------------------------*/
  ntotal=np;
  t[0]=0;
  t[1]=s[0];
  /*-------------------------------------------------------------------*/
  for (i=2;i<ntotal + 1;i++)  t[i]=s[i-1]+t[i-1];
  st=t[ntotal];  /* st le dernier t[i] est la longueur totale */
                 /*-------------------------------------------------------------------*/
  np=0;
  for (i=0;i<nf+1;i++)
    {
      for (j=0;j<ni[i] ;j++)
        {
          alpha[i][j]= (x[i][(j+1)%ni[i]]-x[i][j])/s[j+np] ;
          betta[i][j]= (y[i][(j+1)%ni[i]]-y[i][j])/s[j+np] ;
        } np=np+ni[i];
    }
  /*-------------------------------------------------------------------*/
  /* Repartition uniforme des points de discr sur les frontieres       */
  /*-------------------------------------------------------------------*/
  for (i=1;i<ntotal+1;i++)  pi[i]=(int)(nfm*s[i-1]/st);
  /*-------------------------------------------------------------------*/
  np = 0;
  for (i=0;i<nf+1;i++)
    {
      fprintf(fp,"/*------------------------------------------------*/ \n");
      fprintf(fp," /* frontiere    C(%d)    : */ \n",i);
      fprintf(fp,"/*------------------------------------------------*/ \n");
      for (j= 0;j<ni[i] ;j++)
        {
          fprintf(fp," border(%d,%f,%f,%d)\n ",
                  j+np+1,t[j+np],t[j+np+1],pi[j+np+1]);
          fprintf(fp,"begin \n");
          fprintf(fp,"  x:=%f*(t-%f) + %f;\n",
                  alpha[i][j],t[j+np], x[i][j]) ;
          fprintf(fp,"  y:=%f*(t-%f)+%f;\n",
                  betta[i][j],t[j+np], y[i][j]) ;
          fprintf(fp,"end; \n");
        } np = np+ni[i];
        fprintf(fp,"/*------------------------------------------------*/ \n");
    }
  /*-------------------------------------------------------------------*/
  fprintf(fp,"                                                    \n");
  /*-------------------------------------------------------------------*/
  /*La resolution :il faut corriger les occurences en vu du probleme pose*/
  /*-------------------------------------------------------------------*/
  fprintf(fp,"                                                    \n");
  fprintf(fp,"/*------------------------------------------------*/ \n");
  fprintf(fp,"  buildmesh(%d);  \n",mesh);
  /*-------------------------------------------------------------------*/
  fprintf(fp,"/*------------------------------------------------*/ \n");
  fprintf(fp,"   i:=1;  j:=2;  k:=3;  e:=0.001;                     \n");
  fprintf(fp,"   dt:=0.1; Ra:=80;  nu:=1/Ra;   /* Reynolds  */      \n");
  fprintf(fp,"   /* Initialisation des fonctions (function-Array) */\n");
  fprintf(fp,"   u= one(x>0);                                       \n");
  fprintf(fp,"   v= one(x<0);                                       \n");
  fprintf(fp,"   p=0;                                               \n");
  fprintf(fp,"   un=u;  vn=v;                                       \n");
  /*-----------------------------------------------------------*/
  fprintf(fp,"/*------------------------------------------------*/ \n");
              /*-----------------------------------------------------------*/
  fprintf(fp,"  iter(300)                                          \n");
  fprintf(fp,"  {                                                  \n");
  fprintf(fp,"    f=convect(un,u,v,dt)  ; g=convect(vn,u,v,dt);    \n");
  fprintf(fp,"    solve(u,i)  /* vitesse horizontale */            \n");
  fprintf(fp,"    begin                                            \n");
  fprintf(fp,"      onbdy(1)      u=0;                             \n");
  fprintf(fp,"      onbdy(2)      u=0;                             \n");
  fprintf(fp,"      onbdy(3)      u=1;                             \n");
  fprintf(fp,"      pde(u)  id(u)/dt -laplace(u)*nu = f/dt - dx(p);\n");
  fprintf(fp,"    end;                                             \n");
  fprintf(fp,"   /*plot(u);*/                                      \n");
  fprintf(fp,"/*------------------------------------------------*/ \n");
  fprintf(fp,"  solve(v,j)    /* vitesse verticale */              \n");
  fprintf(fp,"  begin                                              \n");
  fprintf(fp,"    onbdy(1,2,3)         v=0;                        \n");
  fprintf(fp,"    pde(v)  id(v)/dt-laplace(v)*nu = g/dt-dy(p)  ;   \n");
  fprintf(fp,"  end;                                               \n");
  fprintf(fp," /* plot(v);*/                                       \n");
  fprintf(fp,"/*------------------------------------------------*/ \n");
  fprintf(fp,"  solve(p,k)   /* pression */                        \n");
  fprintf(fp,"  begin                                              \n");
  fprintf(fp,"   onbdy(1)       p = 0;                             \n");
  fprintf(fp,"   onbdy(2)       p = 0;                             \n");
  fprintf(fp,"   onbdy(3)       p = 1;                             \n");
  fprintf(fp,"   pde(p) -laplace(p) =(dx(f)+dy(g))/dt ;            \n");
  fprintf(fp,"  end;                                               \n");
  fprintf(fp,"  /* plot(p);  */ un=u;vn=v;                         \n");
  fprintf(fp,"  i:=-1;  j:=-2;  k:=-3;    /* remaillage */         \n");
  fprintf(fp," };                                                  \n");
  fprintf(fp,"/*------------------------------------------------*/ \n");
              /*-----------------------------------------------------------*/
  fprintf(fp,"  plot(u);plot(v);plot(p);                           \n");
  fprintf(fp,"/*------------------------------------------------*/ \n");
              /*-----------------------------------------------------------*/
  fprintf(fp,"  /*  sauvegarde du resultat  */                     \n");
                /*-----------------------------------------------------------*/
  fprintf(fp,"/*------------------------------------------------*/ \n");
  fprintf(fp,"  /*                                                 \n");
  fprintf(fp,"   save(\'u%s\',u);                          \n",datfich);
  fprintf(fp,"   save(\'v%s\',v);                          \n",datfich);
  fprintf(fp,"   save(\'p%s\',p);                          \n",datfich);
  fprintf(fp,"  */                                                 \n");
  fprintf(fp,"/*------------------------------------------------*/ \n");
              /*------------------------------------------------------------*/
  fclose(fp);
}
/*------------------------------------------------------------*/
