/***************************************************************************
                          btextmatrix.cpp  -  description
                             -------------------
    begin                : Sat Jan 22 2000
    copyright            : (C) 2000 by Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "btextmatrix.h"
#include <iostream.h>
#include "bitana.h"

#define STRSEP "\t"

BTextMatrix::BTextMatrix(QWidget *parent, const char *name ) : QTableView(parent,name) {

//setMaximumSize(4000, 4000);

	extern BitanaApp *bitana;
	setFont(bitana->getHebFont2());

// Zellengre aus Fontgre setzen  ??
// 	cout << "Point-Size " << hebfont.pointSize() << endl;

	#define	CELL	13

	setCellWidth (CELL);
  setCellHeight (CELL);

	setSpalten(1);
	setTableFlags(Tbl_autoScrollBars);

// Aufbau der Farbtabelle
// id, rgb-Werte oder Farbname aus  /usr/X11R6/lib/X11/rgb.txt

	ftab.setAutoDelete(true);
	ftab.insert(0, new QColor("black")); // Schwarz - default
	ftab.insert(1, new QColor("white"));
	ftab.insert(2, new QColor("gray"));
	ftab.insert(3, new QColor("red"));
  ftab.insert(4, new QColor("green"));
 	ftab.insert(5, new QColor("blue"));
	ftab.insert(6, new QColor("yellow"));
	ftab.insert(7, new QColor("cyan"));
  ftab.insert(8, new QColor("magneta"));

/* Testausgabe der farbtabelle

  ftab.first();
	do
		cout << ftab.at() << " r-" << ftab.current()->red()  << " g-"
			 << ftab.current()->green() << " b-" << ftab.current()->blue() << endl;
  while (ftab.next() != NULL);

	ftab.at(2);
  cout << ftab.at() << " r-" << ftab.current()->red()  << " g-"
			 << ftab.current()->green() << " b-" << ftab.current()->blue() << endl;

 */
	
 	matrix = "";
	
	mtab.setAutoDelete(true);
	mtab.clear();
	
 setBackgroundColor("white");
//repaint(TRUE);

}
BTextMatrix::~BTextMatrix(){
}

/**  */
void BTextMatrix::paintCell(QPainter *p, int y, int x){

  QColor *m;
  unsigned i;
  i = coordsToIndex(x, y);
  p->setPen(QColor(200,200,200));

  if (matrix.length() > i) {
  	if ( (m = isColored(i)) != NULL ){
   	
     	p->setBackgroundMode (OpaqueMode);
			p->setBackgroundColor(QColor(230, 230, 230));
	 		p->setPen(QColor(black));
//			p->drawRect ( 0, 0, cellWidth(), cellHeight());
     	p->setPen(*m);
   		p->drawText(0, 0, cellWidth(), cellHeight(), AlignCenter, matrix.mid(i, 1) );
   	 // Werte zurcksetzen
			p->setPen(QColor(200,200,200));
     	p->setBackgroundMode (TransparentMode);
     	p->setBackgroundColor(QColor(white));
   	} else
   		p->drawText(0, 0, cellWidth(), cellHeight(), AlignCenter,matrix.mid(i, 1) );
  }

}


/** Anz.Spalten der Matrix / Zeilen werden angepasst*/
void BTextMatrix::setSpalten( int s){

	if (s > 0) setNumCols(s);
	setNumRows(matrix.length() / numCols() + 1); 		
//	updateTableSize(};

}

/** Anz.Spalten der Matrix / Zeilen werden angepasst*/
void BTextMatrix::setZeilen( int z){

	if (z > 0) setNumRows(z);
	else setNumRows(matrix.length() / numCols() + 1); 		

}

void BTextMatrix::clear() {

	matrix = "";
  mtab.clear();
}

/** Fgt bergebenen String in Matrix-String - noch keine Ausgabe */
int BTextMatrix::addMatrixLine(QString s){

	unsigned spos;
	unsigned mpos;

	spos = 0;
	mpos = matrix.length();
	
  while (spos < s.length()) {
		if (s.mid(spos, 1) == STRSEP) {
			spos++;
			mtab.append(new mark);
			mtab.current()->pos = mpos;
			//Farbe char auf bin umrechnen
			if (unsigned(s[spos]- '0') < ftab.count() ) mtab.current()->color = int(s[spos]-'0');
				else  mtab.current()->color = 0;
			spos++;
		}
		matrix.append(s.mid(spos, 1));
		mpos++;
		spos++;
  }


}


/** Umrechnung Spalte Zeile nach Position */
int BTextMatrix::coordsToIndex(int x, int y){

	if(x<0 || x>numCols() || y<0 || y>numRows() )
		cout << "Fehler Koordinatenumrechnung "<< endl;

	return(y * numCols() + x);
}

/** prft, ob Position markiert ist und gibt Zeigar auf Farbe aus Farbtabelle */
QColor* BTextMatrix::isColored(int p){

  if (mtab.first() == NULL) return (NULL);
  do {
       if (mtab.current()->pos == p)
       return(ftab.at(mtab.current()->color));
     } while (mtab.next() != NULL);
  return(NULL);

//	if (mtab.first() == NULL) return (NULL);
//	do if (mtab.current()->pos == p)return(ftab.at(mtab.current()->color));		
//	while (mtab.next() != NULL);	
//	return(NULL);
}


// Ausgabe eines Dokuments

//Del by KDevelop: bool  BTextMatrix::showDoc(QString doc) {
//Del by KDevelop: 
//Del by KDevelop: 	QFile f1;
//Del by KDevelop:   QString zeile;
//Del by KDevelop:   QString s,t;
//Del by KDevelop: 
//Del by KDevelop: 	// Datei
//Del by KDevelop:   QDir d=QDir::root();
//Del by KDevelop:   if (d.cd(TMPDIR)) f1.setName(d.filePath(doc));
//Del by KDevelop:         else  {
//Del by KDevelop:   				QMessageBox::warning(0,"Cannot find the tmp directory",
//Del by KDevelop:                           TMPDIR);
//Del by KDevelop:   				return FALSE;
//Del by KDevelop:  				}
//Del by KDevelop: 	if (!f1.open(IO_ReadOnly))
//Del by KDevelop:                 QMessageBox::warning(0,"Cannot find the file",
//Del by KDevelop:                                        f1.name());
//Del by KDevelop:  	QTextStream dat(&f1);
//Del by KDevelop: 
//Del by KDevelop:   // Ergebnisdokument geffnet
//Del by KDevelop: 
//Del by KDevelop:   // Erste Steuerzeile (Beschreibungszeile) lesen
//Del by KDevelop:   zeile=dat.readLine();
//Del by KDevelop: 
//Del by KDevelop: 
//Del by KDevelop: char z=zeile.at(0);
//Del by KDevelop: 	if(z!='#') return FALSE;
//Del by KDevelop:   zeile.remove(0,2);
//Del by KDevelop: 	cout << zeile << endl;
//Del by KDevelop: // if(!strcmp(zeile,"Matrix ")) return FALSE;
//Del by KDevelop:    zeile=dat.readLine();
//Del by KDevelop:  cout << zeile << endl;
//Del by KDevelop:   z=zeile.at(0);
//Del by KDevelop:   if(z!='#') return FALSE;      // 2.Steuerzeile existiert nicht -> Fehler        zeile.remove(0,3);
//Del by KDevelop: 	 zeile.remove(0,2);
//Del by KDevelop: int p=zeile.find(STRSEP);
//Del by KDevelop:    s=zeile.left(p);
//Del by KDevelop: //   uint l=s.toInt();
//Del by KDevelop: 		cout <<s << s.toInt() << " spalten" << endl;
//Del by KDevelop:              // Anzahl Spalten
//Del by KDevelop:    setSpalten(s.toInt());
//Del by KDevelop: 
//Del by KDevelop: 
//Del by KDevelop: 	//Titelzeilen berlesen
//Del by KDevelop: 	do {
//Del by KDevelop: 		zeile=dat.readLine();
//Del by KDevelop:     z=zeile.at(0);
//Del by KDevelop:   } while(z=='#');
//Del by KDevelop: 
//Del by KDevelop:   // Daten ausgeben
//Del by KDevelop:   while(!dat.eof()){
//Del by KDevelop:   	zeile=dat.readLine();
//Del by KDevelop:  		addMatrixLine(zeile);
//Del by KDevelop:   }
//Del by KDevelop:   setZeilen(0); // aus Spalten berechnen
//Del by KDevelop: }








































































